/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.ngwdm_pub;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.ngwdm_pub.CreateJSFileData;
import com.huawei.nglct.ngwdm_pub.LevelData;
import com.huawei.nglct.ngwdm_pub.OTNModelData;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEOTNModelShowPathMgr {
    private static TEOTNModelShowPathMgr instance = null;
    private ArrayList<OTNModelData> pathDataList = new ArrayList();
    private HashMap<Integer, String> showPathMap = new HashMap();
    private HashMap<String, Integer> getPathMap = new HashMap();
    private HashMap<Integer, String> pathLevelMap = new HashMap();

    private TEOTNModelShowPathMgr() {
        this.parseXML();
    }

    public static synchronized TEOTNModelShowPathMgr getInstance() {
        if (instance == null) {
            instance = new TEOTNModelShowPathMgr();
        }
        return instance;
    }

    private void parseXML() {
        String filepath = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "ngwdm_pub" + File.separator + "wdm_newmodel_showpath.xml";
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", TEResourceManager.getPath() + File.separator + filepath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTNModelShowPathMgr.parseXML fail!", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + filepath);
            return;
        }
        NodeList nodeList = doc.getElementsByTagName("otn_model_desc");
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element node = (Element)nodeList.item(i);
            String pathRange = node.getAttribute("pathrange");
            NodeList itemList = node.getElementsByTagName("item");
            ArrayList<LevelData> otnModelDataList = new ArrayList<LevelData>();
            int len = itemList.getLength();
            for (int j = 0; j < len; ++j) {
                Element itemNode = (Element)itemList.item(j);
                String levelName = itemNode.getAttribute("level");
                String incrementValue = itemNode.getAttribute("increment");
                LevelData data = new LevelData();
                data.level = levelName;
                if (incrementValue != null && !incrementValue.equals("")) {
                    data.increment = Integer.parseInt(incrementValue);
                }
                otnModelDataList.add(data);
            }
            OTNModelData otnData = new OTNModelData();
            otnData.pathRange = pathRange;
            otnData.levelList = otnModelDataList;
            this.pathDataList.add(otnData);
        }
        this.saveToMap();
    }

    private void saveToMap() {
        int len = this.pathDataList.size();
        for (int i = 0; i < len; ++i) {
            OTNModelData otndata = this.pathDataList.get(i);
            ArrayList<Integer> pathList = otndata.getPathList();
            int size = pathList.size();
            for (int j = 0; j < size; ++j) {
                Integer path = pathList.get(j);
                String showPath = this.getShowPath(otndata, path);
                if (this.showPathMap.get(path) == null) {
                    this.showPathMap.put(path, showPath);
                }
                if (this.getPathMap.get(showPath.toUpperCase()) != null) continue;
                this.getPathMap.put(showPath.toUpperCase(), path);
            }
        }
    }

    public String getOTNModelShowPath(int path) {
        String showPath = this.showPathMap.get(path);
        if (showPath != null) {
            return showPath;
        }
        return String.valueOf(path);
    }

    public int getPathFromOTNModelShowPath(String showpath) {
        Integer path = this.getPathMap.get(showpath.toUpperCase());
        if (path != null) {
            return path;
        }
        return -1;
    }

    private String getShowPath(OTNModelData otndata, int path) {
        String[] pathArr = otndata.pathRange.split("-");
        int basenum = path - Integer.parseInt(pathArr[0]) + 1;
        ArrayList dataList = otndata.levelList;
        String[] showValuearr = new String[dataList.size()];
        int size = dataList.size();
        for (int j = size - 1; j >= 0; --j) {
            LevelData leveldata = (LevelData)dataList.get(j);
            int curNum = -1;
            if (leveldata.increment != 1) {
                curNum = basenum % leveldata.increment;
                if (curNum == 0) {
                    curNum = leveldata.increment;
                    basenum /= leveldata.increment;
                } else {
                    basenum = basenum / leveldata.increment + 1;
                }
            } else {
                curNum = basenum / leveldata.increment;
            }
            if (j == 1) {
                curNum = 1;
            }
            showValuearr[j] = leveldata.level + ":" + curNum;
        }
        this.pathLevelMap.put(path, showValuearr[showValuearr.length - 1]);
        StringBuilder pathStr = new StringBuilder("");
        int size2 = showValuearr.length;
        for (int i = 0; i < size2; ++i) {
            if (i != showValuearr.length - 1) {
                pathStr.append(showValuearr[i]).append('-');
                continue;
            }
            pathStr.append(showValuearr[i]);
        }
        if (pathStr.length() > 0) {
            return pathStr.toString();
        }
        return String.valueOf(path);
    }

    public String getODULevelFormPath(int pathid) {
        String level = this.pathLevelMap.get(pathid);
        if (level == null) {
            return "";
        }
        return level.split(":")[0];
    }

    public void createJSFile() {
        String outPath = "wdmsimpleshowpath.js";
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outPath), "utf-8"));
            writer.write("/*\u00b8\u00c3\u00ce\u00c4\u00bc\u00fe\u00d3\u00c9TEOTNModelShowPathMgr.java\u00d7\u00d4\u00b6\u00af\u00c9\u00fa\u00b3\u00c9,\u00b8\u00f9\u00be\u00ddwdm_newmodel_showpath.xml.\u00c8\u00e7\u00d3\u00d0\u00cd\u00a8\u00b5\u00c0\u00cf\u00d4\u00ca\u00be\u00b1\u00e4\u00b6\u00af\u00a3\u00ac\u00c7\u00eb\u00b8\u00fc\u00d0\u00c2\u00a1\u00a3*/");
            writer.write("\r\n");
            writer.write("wdmSimplePath = [];");
            writer.write("\r\n");
            Iterator<Map.Entry<Integer, String>> it = this.showPathMap.entrySet().iterator();
            ArrayList<CreateJSFileData> tempList = new ArrayList<CreateJSFileData>();
            while (it.hasNext()) {
                Map.Entry<Integer, String> entry = it.next();
                Integer key = entry.getKey();
                String value = entry.getValue();
                CreateJSFileData data = new CreateJSFileData();
                data.key = key;
                data.value = value;
                tempList.add(data);
            }
            Collections.sort(tempList);
            int size = tempList.size();
            for (int i = 0; i < size; ++i) {
                CreateJSFileData file = (CreateJSFileData)tempList.get(i);
                StringBuffer sb = new StringBuffer("wdmSimplePath[");
                sb.append(file.key);
                sb.append("] = \"");
                sb.append(file.value);
                sb.append("\";");
                writer.write(sb.toString());
                writer.write("\r\n");
            }
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TEOTNModelShowPathMgr.createJSFile fail!", (Throwable)e);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEOTNModelShowPathMgr.createJSFile fail!", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        TEOTNModelShowPathMgr mgr = TEOTNModelShowPathMgr.getInstance();
        mgr.createJSFile();
    }
}

