/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.ngwdm_pub;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEGenAttrData;
import com.huawei.nglct.ngwdm_pub.TEPathData;
import com.huawei.nglct.ngwdm_pub.TESimGradePortData;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEOTNModelDataMgr {
    private static TEOTNModelDataMgr instance = null;
    private ArrayList<TEPathData> pathDataList = new ArrayList();
    private ArrayList<TEGenAttrData> genCmdList = new ArrayList();
    private ArrayList<TEGenAttrData> genAttrList = new ArrayList();
    private HashMap<Integer, TESimGradePortData> boardGradeMap = new HashMap();
    private static final int INVALID_INT_VALUE = -1;

    private TEOTNModelDataMgr() {
        this.parseXML();
    }

    public static synchronized TEOTNModelDataMgr getInstance() {
        if (instance == null) {
            instance = new TEOTNModelDataMgr();
        }
        return instance;
    }

    private void parseXML() {
        String filepath = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "ngwdm_pub" + File.separator + "wdm_otn_newmodel.xml";
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", TEResourceManager.getPath() + File.separator + filepath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTNModelDataMgr.parseXML fail!", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + filepath);
            return;
        }
        this.interpretConverNmPath(doc);
        this.interpretCmdLayer(doc);
        this.interpretAttrLayer(doc);
        this.interpretBoardGrade(doc);
    }

    private void interpretBoardGrade(Document doc) {
        NodeList nl = doc.getElementsByTagName("board_grade");
        Element eltWdm = (Element)nl.item(0);
        NodeList itemNode = eltWdm.getElementsByTagName("item");
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        int size = itemNode.getLength();
        for (int j = 0; j < size; ++j) {
            Element eltTmp = (Element)itemNode.item(j);
            String cpTypeValue = eltTmp.getAttribute("boardName");
            int cptype = instance.parseInt(cpTypeValue);
            if (cptype == 0) continue;
            String layerValue = eltTmp.getAttribute("grade");
            String portValue = eltTmp.getAttribute("port");
            TIntArrayList portList = new TIntArrayList();
            if (portValue != null) {
                instance.parseIntList(portValue, portList);
            }
            TESimGradePortData data = new TESimGradePortData();
            data.setGrade(Integer.parseInt(layerValue));
            data.setportIDList(portList);
            this.boardGradeMap.put(cptype, data);
        }
    }

    public void putBoardGrade(int cptype, int grade, TIntArrayList portList) {
        if (this.boardGradeMap.get(cptype) == null) {
            TESimGradePortData data = new TESimGradePortData();
            data.setGrade(grade);
            data.setportIDList(portList);
            this.boardGradeMap.put(cptype, data);
        }
    }

    private void interpretCmdLayer(Document doc) {
        NodeList nl = doc.getElementsByTagName("cmd_layer");
        Element eltWdm = (Element)nl.item(0);
        NodeList itemNode = eltWdm.getElementsByTagName("item");
        int size = itemNode.getLength();
        for (int j = 0; j < size; ++j) {
            Element eltTmp = (Element)itemNode.item(j);
            TEGenAttrData attrData = new TEGenAttrData();
            String attrIDValue = eltTmp.getAttribute("cmdList");
            ArrayList<String> attrIDList = this.parseAttrIDValue(attrIDValue);
            attrData.setAttrList(attrIDList);
            String layerValue = eltTmp.getAttribute("layer");
            attrData.setLayer(Integer.parseInt(layerValue));
            this.genCmdList.add(attrData);
        }
    }

    private void interpretAttrLayer(Document doc) {
        NodeList nl = doc.getElementsByTagName("attr_layer");
        Element eltWdm = (Element)nl.item(0);
        NodeList itemNode = eltWdm.getElementsByTagName("item");
        int size = itemNode.getLength();
        for (int j = 0; j < size; ++j) {
            Element eltTmp = (Element)itemNode.item(j);
            TEGenAttrData attrData = new TEGenAttrData();
            String attrIDValue = eltTmp.getAttribute("attrList");
            ArrayList<String> attrIDList = this.parseAttrIDValue(attrIDValue);
            attrData.setAttrList(attrIDList);
            String layerValue = eltTmp.getAttribute("layer");
            attrData.setLayer(Integer.parseInt(layerValue));
            this.genAttrList.add(attrData);
        }
    }

    private ArrayList<String> parseAttrIDValue(String attrIDValue) {
        ArrayList<String> list = new ArrayList<String>();
        String[] strArray = attrIDValue.split(",");
        int len = strArray.length;
        for (int i = 0; i < len; ++i) {
            list.add(strArray[i]);
        }
        return list;
    }

    private void interpretConverNmPath(Document doc) {
        NodeList nl = doc.getElementsByTagName("convert_nmpath");
        Element eltWdm = (Element)nl.item(0);
        NodeList itemNode = eltWdm.getElementsByTagName("item");
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        int size = itemNode.getLength();
        for (int j = 0; j < size; ++j) {
            Element eltTmp = (Element)itemNode.item(j);
            TEPathData pathData = new TEPathData();
            String layerValue = eltTmp.getAttribute("layer");
            pathData.setLayer(Integer.parseInt(layerValue));
            String gradeValue = eltTmp.getAttribute("grade");
            pathData.setGrade(Integer.parseInt(gradeValue));
            TIntArrayList nepathList = new TIntArrayList();
            String nepathValue = eltTmp.getAttribute("nepath");
            mgr.parseIntList(nepathValue, nepathList);
            pathData.setNePathList(nepathList);
            TIntArrayList nmpathList = new TIntArrayList();
            String nmpathValue = eltTmp.getAttribute("nmpath");
            mgr.parseIntList(nmpathValue, nmpathList);
            pathData.setNmPathList(nmpathList);
            TIntArrayList boardList = new TIntArrayList();
            String cpTypeValue = eltTmp.getAttribute("boardName");
            mgr.parseIntList(cpTypeValue, boardList);
            pathData.setBoardTypeList(boardList);
            String objType = eltTmp.getAttribute("objectType");
            pathData.setObjType(Integer.parseInt(objType));
            this.pathDataList.add(pathData);
        }
    }

    public int getAttrNmPath(int portID, int nePath, int boardType, String attrID) {
        if (portID > 51) {
            return nePath;
        }
        int layer = this.getLayerFromAttr(attrID);
        int grade = this.getGradeFromBoard(boardType);
        if (layer == -1 || !this.isSupportSimpleModePort(boardType, portID)) {
            return nePath;
        }
        int tempNmPathID = this.getNmPath(layer, grade, nePath, boardType);
        if (tempNmPathID == -1) {
            tempNmPathID = nePath;
        }
        return tempNmPathID;
    }

    public int getAttrNmPath(int nePath, int boardType, String attrID) {
        int layer = this.getLayerFromAttr(attrID);
        int grade = this.getGradeFromBoard(boardType);
        if (layer == -1 || grade == -1) {
            return nePath;
        }
        int tempNmPathID = this.getNmPath(layer, grade, nePath, boardType);
        if (tempNmPathID == -1) {
            tempNmPathID = nePath;
        }
        return tempNmPathID;
    }

    public int getAttrNePath(int portID, int nmPath, int boardType, String attrID) {
        if (portID > 51) {
            return nmPath;
        }
        int layer = this.getLayerFromAttr(attrID);
        int grade = this.getGradeFromBoard(boardType);
        if (layer == -1 || !this.isSupportSimpleModePort(boardType, portID)) {
            return nmPath;
        }
        int tempNmPathID = this.getNePath(layer, grade, nmPath, boardType);
        if (tempNmPathID == -1) {
            tempNmPathID = nmPath;
        }
        return tempNmPathID;
    }

    public int getAttrNePath(int nmPath, int boardType, String attrID) {
        int layer = this.getLayerFromAttr(attrID);
        int grade = this.getGradeFromBoard(boardType);
        if (layer == -1 || grade == -1) {
            return nmPath;
        }
        int tempNmPathID = this.getNePath(layer, grade, nmPath, boardType);
        if (tempNmPathID == -1) {
            tempNmPathID = nmPath;
        }
        return tempNmPathID;
    }

    public int getNmPathFromNePath(int layer, int grade, int nePath, int boardType) {
        int path = this.getNmPath(layer, grade, nePath, boardType);
        if (path == -1) {
            path = nePath;
        }
        return path;
    }

    public int getNmPath(int layer, int grade, int nePath, int boardType) {
        TEPathData pathData = this.getPathDataFromBoardType(layer, grade, boardType);
        if (pathData != null) {
            return this.getNmPath(layer, grade, nePath, pathData);
        }
        int len = this.pathDataList.size();
        for (int i = 0; i < len; ++i) {
            TEPathData tmppathData = this.pathDataList.get(i);
            TIntArrayList nepathList = tmppathData.getNePathList();
            TIntArrayList nmpathList = tmppathData.getNmPathList();
            if (nepathList.size() != nmpathList.size()) {
                return -1;
            }
            if (tmppathData.getLayer() != layer || tmppathData.getGrade() != grade) continue;
            int size = nepathList.size();
            for (int j = 0; j < size; ++j) {
                int nepath = nepathList.get(j);
                if (nepath != nePath) continue;
                return nmpathList.get(j);
            }
        }
        return -1;
    }

    private int getNmPath(int layer, int grade, int nePath, TEPathData pathData) {
        TIntArrayList nepathList = pathData.getNePathList();
        TIntArrayList nmpathList = pathData.getNmPathList();
        if (nepathList.size() != nmpathList.size()) {
            return -1;
        }
        if (pathData.getLayer() == layer && pathData.getGrade() == grade) {
            int size = nepathList.size();
            for (int j = 0; j < size; ++j) {
                int nepath = nepathList.get(j);
                if (nepath != nePath) continue;
                return nmpathList.get(j);
            }
        }
        return -1;
    }

    private TEPathData getPathDataFromBoardType(int layer, int grade, int boardType) {
        int len = this.pathDataList.size();
        for (int i = 0; i < len; ++i) {
            TEPathData pathData = this.pathDataList.get(i);
            TIntArrayList boardList = pathData.getBoardTypeList();
            if (boardList == null || boardList.size() == 0) continue;
            int size = boardList.size();
            for (int j = 0; j < size; ++j) {
                if (boardList.get(j) != boardType || pathData.getLayer() != layer || pathData.getGrade() != grade) continue;
                return pathData;
            }
        }
        return null;
    }

    public static int getNePath(int neID, int slotID, int nmPath) {
        int boardType;
        TEOTNModelDataMgr otnModelMgr = TEOTNModelDataMgr.getInstance();
        int nepath = otnModelMgr.getNePath(nmPath, boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID));
        if (nepath == -1) {
            nepath = nmPath;
        }
        return nepath;
    }

    public int getNePath(int layer, int grade, int nmPath, int boardType) {
        TEPathData pathData = this.getPathDataFromBoardType(layer, grade, boardType);
        if (pathData != null) {
            return this.getNePath(layer, grade, nmPath, pathData);
        }
        int len = this.pathDataList.size();
        for (int i = 0; i < len; ++i) {
            TEPathData tmppathData = this.pathDataList.get(i);
            TIntArrayList nepathList = tmppathData.getNePathList();
            TIntArrayList nmpathList = tmppathData.getNmPathList();
            if (nepathList.size() != nmpathList.size()) {
                return -1;
            }
            if (tmppathData.getLayer() != layer || tmppathData.getGrade() != grade) continue;
            int size = nmpathList.size();
            for (int j = 0; j < size; ++j) {
                int nmpath = nmpathList.get(j);
                if (nmpath != nmPath) continue;
                return nepathList.get(j);
            }
        }
        return -1;
    }

    public int getNePath(int nmPath, int boardType) {
        int nmpath;
        int j;
        int size;
        TIntArrayList nmpathList;
        TIntArrayList nepathList;
        TEPathData tmppathData;
        int i;
        int len = this.pathDataList.size();
        for (i = 0; i < len; ++i) {
            tmppathData = this.pathDataList.get(i);
            nepathList = tmppathData.getNePathList();
            nmpathList = tmppathData.getNmPathList();
            if (nepathList.size() != nmpathList.size()) {
                return -1;
            }
            if (!tmppathData.getBoardTypeList().contains(boardType)) continue;
            size = nmpathList.size();
            for (j = 0; j < size; ++j) {
                nmpath = nmpathList.get(j);
                if (nmpath != nmPath) continue;
                return nepathList.get(j);
            }
        }
        len = this.pathDataList.size();
        for (i = 0; i < len; ++i) {
            tmppathData = this.pathDataList.get(i);
            nepathList = tmppathData.getNePathList();
            nmpathList = tmppathData.getNmPathList();
            if (nepathList.size() != nmpathList.size()) {
                return -1;
            }
            size = nmpathList.size();
            for (j = 0; j < size; ++j) {
                nmpath = nmpathList.get(j);
                if (nmpath != nmPath) continue;
                return nepathList.get(j);
            }
        }
        return -1;
    }

    private int getNePath(int layer, int grade, int nmPath, TEPathData pathData) {
        TIntArrayList nepathList = pathData.getNePathList();
        TIntArrayList nmpathList = pathData.getNmPathList();
        if (nepathList.size() != nmpathList.size()) {
            return -1;
        }
        if (pathData.getLayer() == layer && pathData.getGrade() == grade) {
            int size = nmpathList.size();
            for (int j = 0; j < size; ++j) {
                int nmpath = nmpathList.get(j);
                if (nmpath != nmPath) continue;
                return nepathList.get(j);
            }
        }
        return -1;
    }

    public int getLayerFromAttrID(String cmdName) {
        int len = this.genCmdList.size();
        for (int i = 0; i < len; ++i) {
            TEGenAttrData attrData = this.genCmdList.get(i);
            ArrayList<String> attrList = attrData.getAttrList();
            int size = attrList.size();
            for (int j = 0; j < size; ++j) {
                if (!attrList.get(j).equalsIgnoreCase(cmdName)) continue;
                return attrData.getLayer();
            }
        }
        return -1;
    }

    public int getLayerFromAttr(String attrName) {
        int len = this.genAttrList.size();
        for (int i = 0; i < len; ++i) {
            TEGenAttrData attrData = this.genAttrList.get(i);
            ArrayList<String> attrList = attrData.getAttrList();
            int size = attrList.size();
            for (int j = 0; j < size; ++j) {
                if (!attrList.get(j).equalsIgnoreCase(attrName)) continue;
                return attrData.getLayer();
            }
        }
        return -1;
    }

    public int getNMPathFromObjType(int objType, int boardType, int nePath) {
        int layer = -1;
        int grade = -1;
        int len = this.pathDataList.size();
        for (int i = 0; i < len; ++i) {
            TEPathData tmppathData = this.pathDataList.get(i);
            if (tmppathData.getObjType() != objType) continue;
            layer = tmppathData.getLayer();
            grade = tmppathData.getGrade();
            break;
        }
        return this.getNmPath(layer, grade, nePath, boardType);
    }

    public int getGradeFromBoard(int bdType) {
        if (this.boardGradeMap.get(bdType) != null) {
            TESimGradePortData tempData = this.boardGradeMap.get(bdType);
            return tempData.getGrade();
        }
        return -1;
    }

    public boolean isSimpleModelBoard(int bdType) {
        return this.getGradeFromBoard(bdType) != -1;
    }

    public boolean isSupportSimpleModePort(int bdType, int portID) {
        TESimGradePortData tempData;
        if (this.boardGradeMap.get(bdType) != null && ((tempData = this.boardGradeMap.get(bdType)).getportIDList().isEmpty() || portID == -1 || portID == 0 || tempData.getportIDList().contains(portID))) {
            return tempData.getGrade() != -1;
        }
        return false;
    }

    public TIntArrayList getSimplePortList(int bdType) {
        if (this.boardGradeMap.get(bdType) != null) {
            TESimGradePortData tempData = this.boardGradeMap.get(bdType);
            return (TIntArrayList)tempData.getportIDList().clone();
        }
        return new TIntArrayList();
    }
}

