/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEGetUSBSerialPortAndBaudRate;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemmlconfig.CMDMonitor;
import com.huawei.nglct.nemmlconfig.CommonFunc;
import com.huawei.nglct.nemmlconfig.DataPacket;
import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.nemmlconfig.TENeConnectMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.net.InetAddress;

public class TESwitchtoNMMode
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        int dest = 0;
        Datainterface outputData = new Datainterface();
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        if (rowParams.getParam("neid") != null && rowParams.getParam("neid").getValue() != null) {
            int neid = Integer.valueOf(rowParams.getParam("neid").getValue());
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            dest = ne.getRealNEID();
        }
        String username = rowParams.getParam("username").getValue();
        String password = rowParams.getParam("password").getValue();
        int neGWType = 5;
        int nePort = Integer.valueOf(TEGetUSBSerialPortAndBaudRate.getUSBSerialPort());
        int baudRate = Integer.valueOf(TEGetUSBSerialPortAndBaudRate.getUSBSerialBaudRate());
        TENeConnectMgr.closeUfComConnect(neGWType, nePort);
        NeConnect connect = null;
        try {
            String localAddr = InetAddress.getLocalHost().getHostAddress();
            connect = TENeConnectMgr.getInstance().getNeConnect(nePort, localAddr);
            if (null == connect) {
                connect = new NeConnect(nePort, baudRate, localAddr, username);
                connect.setConnectType(neGWType);
                TENeConnectMgr.getInstance().addNeConnect(connect);
            }
            if (!connect.getIsNeConnected()) {
                connect.setLoginStatus(false);
                if (connect.createConnect() != 0) {
                    outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1091109266));
                    return outputData;
                }
            }
            connect.clearInfo();
            connect.setCmdNum(2);
            connect.setCompleteCmdIndex(0);
            byte[] bpwd = EncryptUtils.decrypt(password);
            String login = ":lognew:\"" + username + "\",\"" + EncryptUtils.convertByte2Str(bpwd) + "\";";
            EncryptUtils.clearByte(bpwd);
            DataPacket dataPacket = CommonFunc.getPacket(login, 200L, neGWType, dest);
            connect.sendDataPacket(dataPacket);
            connect.setLoginStatus(true);
            CMDMonitor tt = new CMDMonitor(connect, dataPacket.getWaitTime() + 2000L);
            tt.start();
            String setsrlmode = ":cm-set-srlmode:1,nms;";
            dataPacket = CommonFunc.getPacket(setsrlmode, 100L, neGWType, dest);
            connect.sendDataPacket(dataPacket);
            login = null;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESwitchtoNMMode.performBussinessProcess() fail!", (Throwable)e);
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1091092503));
            return outputData;
        }
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return outputData;
    }
}

