/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemmlconfig.CMDMonitor;
import com.huawei.nglct.nemmlconfig.CommonFunc;
import com.huawei.nglct.nemmlconfig.DataPacket;
import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.nemmlconfig.TENeConnectMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class TEMultiNESwitchtoNMMode
extends TENEExplorerBean {
    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        BussinessParams rtnBParams = new BussinessParams();
        int failedCount = 0;
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        int iLength = rowParams.length;
        for (int i = 0; i < iLength; ++i) {
            RowParams rowParam;
            RowParams row = inputData.getBussinessParams().getRowParams(i);
            String neID = row.getParam("neID").getValue();
            String username = row.getParam("username").getValue();
            String password = row.getParam("password").getValue();
            TENE ne = TENEListMgr.getInstance().getNE(Integer.valueOf(neID));
            int nePort = Integer.valueOf(ne.getPort());
            int neGWType = ne.getNEGWType();
            int dest = ne.getRealNEID();
            TENeConnectMgr.closeUfComConnect(neGWType, nePort);
            NeConnect connect = null;
            try {
                connect = this.getNeConnection(username, ne);
                if (!connect.getIsNeConnected()) {
                    connect.setLoginStatus(false);
                    if (connect.createConnect() != 0) {
                        ++failedCount;
                        RowParams rowParam2 = this.fillSmallErrMessage(ne, 1091109266);
                        rtnBParams.addRowParams(rowParam2);
                        continue;
                    }
                }
                connect.clearInfo();
                connect.setCmdNum(2);
                connect.setCompleteCmdIndex(0);
                byte[] bpwd = EncryptUtils.decrypt(password);
                String login = ":lognew:\"" + username + "\",\"" + EncryptUtils.convertByte2Str(bpwd) + "\";";
                EncryptUtils.clearByte(bpwd);
                DataPacket dataPacket = CommonFunc.getPacket(login, 200L, ne.getNEGWType(), dest);
                connect.sendDataPacket(dataPacket);
                connect.setLoginStatus(true);
                String setsrlmode = ":cm-set-srlmode:1,nms;";
                dataPacket = CommonFunc.getPacket(setsrlmode, 100L, ne.getNEGWType(), dest);
                CMDMonitor tt = new CMDMonitor(connect, dataPacket.getWaitTime() + 2000L);
                tt.start();
                connect.sendDataPacket(dataPacket);
                login = null;
                continue;
            }
            catch (SocketException e) {
                connect.closeConnect();
                TENeConnectMgr.getInstance().delNeConnect(connect);
                connect = null;
                TELogFactory.getNormalLogger().error("TEMultiNESwitchtoNMMode.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
                continue;
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TEMultiNESwitchtoNMMode.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
                continue;
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("TEMultiNESwitchtoNMMode.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
                continue;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEMultiNESwitchtoNMMode.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
            }
        }
        ErrorMessage bigErr = this.getBigErrMessage(inputData, failedCount);
        this.outputData.setBussinessParams(rtnBParams);
        this.outputData.setErrorMessage(bigErr);
        return this.outputData;
    }

    private NeConnect getNeConnection(String username, TENE ne) throws UnknownHostException {
        String neIP = ne.getNEGWAddress();
        int nePort = Integer.valueOf(ne.getPort());
        int neGWType = ne.getNEGWType();
        int baudRate = ne.getBaudRate() == null ? 0 : Integer.valueOf(ne.getBaudRate());
        String localAddr = InetAddress.getLocalHost().getHostAddress();
        NeConnect connect = TESysManagerConstants.isSerialPort(neGWType) ? TENeConnectMgr.getInstance().getNeConnect(nePort, localAddr) : TENeConnectMgr.getInstance().getNeConnect(neIP, localAddr);
        if (null == connect) {
            connect = TESysManagerConstants.isSerialPort(neGWType) ? new NeConnect(nePort, baudRate, localAddr, username) : new NeConnect(neIP, nePort, localAddr, username);
            connect.setConnectType(neGWType);
            TENeConnectMgr.getInstance().addNeConnect(connect);
        }
        return connect;
    }

    private RowParams fillSmallErrMessage(TENE ne, int Errcode) {
        RowParams rowParam = new RowParams();
        RowErrors rowError = new RowErrors();
        int neID = ne.getNEID();
        String neName = ne.getNEName();
        rowError.addParam(new Param("neid", String.valueOf(neID)));
        rowError.addParam(new Param("nename", String.valueOf(neName)));
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neID, Errcode));
        rowParam.addRowErrors(rowError);
        return rowParam;
    }

    private ErrorMessage getBigErrMessage(Datainterface inputData, int failedCount) {
        ErrorMessage bigErr = null;
        int tolCount = inputData.getBussinessParams().getRowParamsCount();
        bigErr = failedCount == 0 ? TEErrorResourceUtil.getErrorMessage(0) : (failedCount == tolCount ? TEErrorResourceUtil.getErrorMessage(2) : TEErrorResourceUtil.getErrorMessage(1));
        return bigErr;
    }
}

