/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemmlconfig.CMDMonitor;
import com.huawei.nglct.nemmlconfig.CommandInfo;
import com.huawei.nglct.nemmlconfig.CommonFunc;
import com.huawei.nglct.nemmlconfig.DataPacket;
import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.nemmlconfig.TENeConnectMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NeMmlConfig_v1r3c00
extends TENEExplorerBean {
    private static final int FILE_NOT_FOUND = 1090781211;
    private static final int INVALID = 43138;
    private Map<Integer, CommandInfo> commandMap = new HashMap<Integer, CommandInfo>();

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        int result = this.validateInput(inputData);
        if (0 != result) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result));
            return this.outputData;
        }
        int failedCount = 0;
        BussinessParams rtnBParams = new BussinessParams();
        for (Map.Entry<Integer, CommandInfo> entry : this.commandMap.entrySet()) {
            RowParams rowParam;
            List<String> cmds = entry.getValue().getCommand();
            TENE ne = TENEListMgr.getInstance().getNE(entry.getKey());
            String neIP = ne.getNEGWAddress();
            int nePort = Integer.valueOf(ne.getPort());
            int neGWType = ne.getNEGWType();
            int baudRate = ne.getBaudRate() == null || !TEStringUtils.isNumeric(ne.getBaudRate()) ? 0 : Integer.valueOf(ne.getBaudRate());
            int dest = ne.getRealNEID();
            String username = entry.getValue().getUsername();
            String password = entry.getValue().getPassword();
            ArrayList<DataPacket> datapackets = this.getDatapackets(cmds, neGWType, dest);
            if (0 == datapackets.size()) {
                RowParams rowParam2 = this.fillSmallErrMessage(ne, 43138);
                rtnBParams.addRowParams(rowParam2);
                continue;
            }
            NeConnect connect = null;
            TENeConnectMgr.closeUfComConnect(neGWType, nePort);
            try {
                String localAddr = InetAddress.getLocalHost().getHostAddress();
                connect = TESysManagerConstants.isSerialPort(neGWType) ? TENeConnectMgr.getInstance().getNeConnect(nePort, localAddr) : TENeConnectMgr.getInstance().getNeConnect(neIP, localAddr);
                if (null == connect) {
                    connect = TESysManagerConstants.isSerialPort(neGWType) ? new NeConnect(nePort, baudRate, localAddr, username) : new NeConnect(neIP, nePort, localAddr, username);
                    connect.setConnectType(neGWType);
                    TENeConnectMgr.getInstance().addNeConnect(connect);
                }
                if (!connect.getIsNeConnected()) {
                    connect.setLoginStatus(false);
                    if (connect.createConnect() != 0) {
                        ++failedCount;
                        rowParam = this.fillSmallErrMessage(ne, 1091109266);
                        rtnBParams.addRowParams(rowParam);
                        continue;
                    }
                }
                connect.clearInfo();
                connect.setCmdNum(cmds.size() + 1);
                connect.setCompleteCmdIndex(0);
                byte[] bpwd = EncryptUtils.decrypt(password);
                String login = ":lognew:\"" + username + "\",\"" + EncryptUtils.convertByte2Str(bpwd) + "\";";
                EncryptUtils.clearByte(bpwd);
                DataPacket dataPacket = CommonFunc.getPacket(login, 200L, neGWType, dest);
                connect.sendDataPacket(dataPacket);
                connect.setLoginStatus(true);
                CMDMonitor tt = new CMDMonitor(connect, this.getTotalWaitTime(datapackets) * 2L + 10000L);
                tt.start();
                Thread.sleep(3000L);
                connect.isLoginReceive();
                DataPacket tempPacket = null;
                int len = datapackets.size();
                for (int i = 0; i < len; ++i) {
                    tempPacket = datapackets.get(i);
                    connect.sendDataPacket(tempPacket);
                }
                login = null;
            }
            catch (SocketException e) {
                connect.closeConnect();
                TENeConnectMgr.getInstance().delNeConnect(connect);
                connect = null;
                TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
                ++failedCount;
                rowParam = this.fillSmallErrMessage(ne, 1091092503);
                rtnBParams.addRowParams(rowParam);
            }
        }
        ErrorMessage bigErr = this.getBigErrMessage(inputData, failedCount);
        this.outputData.setBussinessParams(rtnBParams);
        this.outputData.setErrorMessage(bigErr);
        return this.outputData;
    }

    private long getTotalWaitTime(ArrayList<DataPacket> datapackets) {
        long waitTime = 0L;
        DataPacket tempPacket = null;
        int len = datapackets.size();
        for (int i = 0; i < len; ++i) {
            tempPacket = datapackets.get(i);
            waitTime += tempPacket.getWaitTime();
        }
        return waitTime;
    }

    private RowParams fillSmallErrMessage(TENE ne, int Errcode) {
        RowParams rowParam = new RowParams();
        RowErrors rowError = new RowErrors();
        int neID = ne.getNEID();
        String neName = ne.getNEName();
        rowError.addParam(new Param("neid", String.valueOf(neID)));
        rowError.addParam(new Param("nename", String.valueOf(neName)));
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neID, Errcode));
        rowParam.addRowErrors(rowError);
        return rowParam;
    }

    private ErrorMessage getBigErrMessage(Datainterface inputData, int failedCount) {
        ErrorMessage bigErr = null;
        int tolCount = inputData.getBussinessParams().getRowParamsCount();
        bigErr = failedCount == 0 ? TEErrorResourceUtil.getErrorMessage(0) : (failedCount == tolCount ? TEErrorResourceUtil.getErrorMessage(2) : TEErrorResourceUtil.getErrorMessage(1));
        return bigErr;
    }

    private int validateInput(Datainterface inputData) {
        int iLength = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < iLength; ++i) {
            RowParams row = inputData.getBussinessParams().getRowParams(i);
            String fileName = row.getParam("cmdfilename").getValue().trim();
            String neid = inputData.getBussinessParams().getRowParams(i).getParam("neID").getValue();
            if (!(fileName.toLowerCase().endsWith(".ini") || fileName.toLowerCase().endsWith(".txt") || fileName.toLowerCase().endsWith(".cfg"))) {
                return 43138;
            }
            File cmdFile = new File(fileName);
            if (!cmdFile.exists()) {
                return 1090781211;
            }
            ArrayList<String> cmds = CommonFunc.getCmdsFromFile(cmdFile);
            if (0 == cmds.size()) {
                return 43138;
            }
            String username = row.getParam("username").getValue();
            String password = row.getParam("password").getValue();
            this.commandMap.put(Integer.parseInt(neid), new CommandInfo(username, password, cmds));
        }
        return 0;
    }

    private ArrayList<DataPacket> getDatapackets(List<String> cmds, int connectType, int dest) {
        DataPacket packet = null;
        ArrayList<DataPacket> packets = new ArrayList<DataPacket>(0);
        try {
            long waitTime = 0L;
            String temp = "";
            int len = cmds.size();
            for (int index = 0; index < len; ++index) {
                if (index == 0 && TESysManagerConstants.isSerialPort(connectType)) {
                    waitTime = 3000L;
                }
                if ((temp = cmds.get(index)).startsWith(":")) {
                    if (0L == waitTime) {
                        packet = CommonFunc.getPacket(temp, connectType, dest);
                    } else {
                        packet = CommonFunc.getPacket(temp, waitTime, connectType, dest);
                        waitTime = 0L;
                    }
                    packets.add(packet);
                    continue;
                }
                if (!temp.endsWith("ms;") || !temp.startsWith("sleep")) continue;
                waitTime = Long.valueOf(CommonFunc.filteNumber(temp.substring("sleep".length(), temp.indexOf("ms")).trim()));
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("getDatapackets() fail!", (Throwable)ex);
            packets.clear();
        }
        return packets;
    }
}

