/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemmlconfig.CMDMonitor;
import com.huawei.nglct.nemmlconfig.CommonFunc;
import com.huawei.nglct.nemmlconfig.DataPacket;
import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.nemmlconfig.TENeConnectMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;

public class NeMmlConfig
extends TENEExplorerBean {
    private static final int FILE_NOT_FOUND = 1090781211;
    private static final int INVALID = 43138;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        String fileName = row.getParam("cmdfilename").getValue().trim();
        if (!(fileName.toLowerCase().endsWith(".ini") || fileName.toLowerCase().endsWith(".txt") || fileName.toLowerCase().endsWith(".cfg"))) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(43138));
            return this.outputData;
        }
        File cmdFile = new File(fileName);
        if (!cmdFile.exists()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090781211));
            return this.outputData;
        }
        ArrayList<String> cmds = CommonFunc.getCmdsFromFile(cmdFile);
        if (0 == cmds.size()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(43138));
            return this.outputData;
        }
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        String neIP = ne.getNEGWAddress();
        int nePort = Integer.valueOf(ne.getPort());
        int neGWType = ne.getNEGWType();
        int dest = ne.getRealNEID();
        int baudRate = ne.getBaudRate() == null || !TEStringUtils.isNumeric(ne.getBaudRate()) ? 0 : Integer.valueOf(ne.getBaudRate());
        String username = row.getParam("username").getValue();
        String password = row.getParam("password").getValue();
        ArrayList<DataPacket> datapackets = this.getDatapackets(cmds, neGWType, dest);
        if (0 == datapackets.size()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(43138));
            return this.outputData;
        }
        NeConnect connect = null;
        TENeConnectMgr.closeUfComConnect(neGWType, nePort);
        try {
            String localAddr = InetAddress.getLocalHost().getHostAddress();
            connect = neGWType == 3 || neGWType == 5 ? TENeConnectMgr.getInstance().getNeConnect(nePort, localAddr) : TENeConnectMgr.getInstance().getNeConnect(neIP, localAddr);
            if (null == connect) {
                connect = TESysManagerConstants.isSerialPort(neGWType) ? new NeConnect(nePort, baudRate, localAddr, username) : new NeConnect(neIP, nePort, localAddr, username);
                connect.setConnectType(neGWType);
                TENeConnectMgr.getInstance().addNeConnect(connect);
            }
            if (!connect.getIsNeConnected()) {
                connect.setLoginStatus(false);
                if (connect.createConnect() != 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1091109266));
                    return this.outputData;
                }
            }
            connect.clearInfo();
            connect.setCmdNum(cmds.size() + 1);
            connect.setCompleteCmdIndex(0);
            byte[] bpwd = EncryptUtils.decrypt(password);
            String login = ":lognew:\"" + username + "\",\"" + EncryptUtils.convertByte2Str(bpwd) + "\";";
            EncryptUtils.clearByte(bpwd);
            DataPacket dataPacket = CommonFunc.getPacket(login, 200L, neGWType, dest);
            connect.sendDataPacket(dataPacket);
            connect.setLoginStatus(true);
            CMDMonitor tt = new CMDMonitor(connect, this.getTotalWaitTime(datapackets) * 2L + 10000L);
            tt.start();
            Thread.sleep(3000L);
            connect.isLoginReceive();
            DataPacket tempPacket = null;
            int len = datapackets.size();
            for (int i = 0; i < len; ++i) {
                tempPacket = datapackets.get(i);
                connect.sendDataPacket(tempPacket);
            }
            login = null;
        }
        catch (SocketException e) {
            connect.closeConnect();
            TENeConnectMgr.getInstance().delNeConnect(connect);
            connect = null;
            TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1091092503));
            return this.outputData;
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1091092503));
            return this.outputData;
        }
        catch (InterruptedException e) {
            TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1091092503));
            return this.outputData;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("NeMmlConfig.performBussinessProcess() fail!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1091092503));
            return this.outputData;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return this.outputData;
    }

    private long getTotalWaitTime(ArrayList<DataPacket> datapackets) {
        long waitTime = 0L;
        DataPacket tempPacket = null;
        int len = datapackets.size();
        for (int i = 0; i < len; ++i) {
            tempPacket = datapackets.get(i);
            waitTime += tempPacket.getWaitTime();
        }
        return waitTime;
    }

    private ArrayList<DataPacket> getDatapackets(ArrayList<String> cmds, int connectType, int dest) {
        DataPacket packet = null;
        ArrayList<DataPacket> packets = new ArrayList<DataPacket>(0);
        try {
            long waitTime = 0L;
            String temp = "";
            int len = cmds.size();
            for (int index = 0; index < len; ++index) {
                if (index == 0 && TESysManagerConstants.isSerialPort(connectType)) {
                    waitTime = 3000L;
                }
                if ((temp = cmds.get(index)).startsWith(":")) {
                    if (0L == waitTime) {
                        packet = CommonFunc.getPacket(temp, connectType, dest);
                    } else {
                        packet = CommonFunc.getPacket(temp, waitTime, connectType, dest);
                        waitTime = 0L;
                    }
                    packets.add(packet);
                    continue;
                }
                if (!temp.endsWith("ms;") || !temp.startsWith("sleep")) continue;
                waitTime = Long.valueOf(CommonFunc.filteNumber(temp.substring("sleep".length(), temp.indexOf("ms")).trim()));
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("getDatapackets() fail!", (Throwable)ex);
            packets.clear();
        }
        return packets;
    }
}

