/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemmlconfig.CommonFunc;
import com.huawei.nglct.nemmlconfig.DataPacket;
import com.huawei.nglct.nemmlconfig.PacketHead;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.IOStreamConvertor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.zip.DataFormatException;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class NeConnect {
    private int connectType = 1;
    private InetSocketAddress sockAddr = null;
    private Socket socket = null;
    private CommPortIdentifier comId = null;
    private SerialPort port = null;
    private int baudrate = 9600;
    private DataInputStream inStream = null;
    private DataOutputStream outStream = null;
    private boolean loginStatus = false;
    private byte[] m_PrevBuff;
    private StringBuffer m_PrevInfo;
    private Object m_PrevInfo_lock = new Object();
    private Object m_PrevBuff_lock = new Object();
    private Object conectObj = new Object();
    private int completeCmdIndex = 0;
    private static final byte changeLine = 10;
    private StringBuffer displayInfo = new StringBuffer(0);
    private boolean isReceive = false;
    private String neAddress;
    private String srcIP;
    private int nePort;
    private int cmdNum = 0;
    private String strUserName = "";
    public static final int CONNECT_TIMEOUT = 20000;
    private static final String errSpanStart = "<span style='color:red'>";
    private static final String errSpanEnd = "</span>";
    private static final CharSequence[] errLabels = new CharSequence[]{"not login", "failed", "error", "missing para", "extra para", "bad para", "unregistered command"};
    private static final int LOGIN_TIMEOUT = 5;

    public NeConnect(String szNeIp, int lNePort) {
        this.neAddress = szNeIp;
        this.nePort = lNePort;
    }

    public NeConnect(String szNeIp, int lNePort, String srcIP, String username) {
        this.neAddress = szNeIp;
        this.nePort = lNePort;
        this.srcIP = srcIP;
        this.strUserName = username;
    }

    public NeConnect(int lNePort, int baudrate) {
        this.nePort = lNePort;
        this.baudrate = baudrate;
    }

    public NeConnect(int lNePort, int baudrate, String srcIP, String username) {
        this.nePort = lNePort;
        this.baudrate = baudrate;
        this.srcIP = srcIP;
        this.strUserName = username;
    }

    public synchronized int createConnect() throws DataFormatException {
        if (TESysManagerConstants.isSerialPort(this.connectType)) {
            return this.createConnect(this.nePort, this.baudrate);
        }
        return this.createConnect(this.neAddress, this.nePort);
    }

    public synchronized int createConnect(String szNeIp, int lNePort) throws DataFormatException {
        block8: {
            if (!CommonFunc.ipIsValid(szNeIp)) {
                throw new DataFormatException("IP Is Invalid");
            }
            try {
                this.neAddress = szNeIp;
                if (null == this.socket || this.socket.isClosed()) {
                    this.socket = new Socket();
                }
                this.sockAddr = new InetSocketAddress(szNeIp, lNePort);
                this.socket.connect(this.sockAddr, 20000);
                this.socket.setSoTimeout(20000);
                this.inStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.outStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                this.notifyAll();
            }
            catch (Exception ex) {
                TELogFactory.getNormalLogger().error("NeConnect.createConnect() fail!", (Throwable)ex);
                if (this.socket == null) break block8;
                try {
                    this.socket.close();
                    if (this.inStream != null) {
                        this.inStream.close();
                        this.inStream = null;
                    }
                    if (this.outStream != null) {
                        this.outStream.close();
                        this.outStream = null;
                    }
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("NeConnect.createConnect() fail!", (Throwable)e);
                }
                return 1;
            }
        }
        return 0;
    }

    public synchronized int createConnect(int lNePort, int baudrate) {
        try {
            this.comId = CommPortIdentifier.getPortIdentifier((String)("COM" + lNePort));
            if (null == this.comId) {
                return 1;
            }
            if (null != this.comId && 1 != this.comId.getPortType()) {
                TELogFactory.getNormalLogger().error("NeConnect.createConnect() fail!COM" + lNePort + "is not a serial port.");
                return 1;
            }
            this.port = (SerialPort)this.comId.open("NG LCT", 20000);
            this.inStream = new DataInputStream(new BufferedInputStream(this.port.getInputStream()));
            this.outStream = new DataOutputStream(new BufferedOutputStream(this.port.getOutputStream()));
            this.notifyAll();
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("NeConnect.createConnect() fail!", (Throwable)ex);
            if (this.port != null) {
                try {
                    this.port.close();
                    if (this.inStream != null) {
                        this.inStream.close();
                        this.inStream = null;
                    }
                    if (this.outStream != null) {
                        this.outStream.close();
                        this.outStream = null;
                    }
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("NeConnect.createConnect() fail!", (Throwable)e);
                }
            }
            return 1;
        }
        try {
            this.port.setSerialPortParams(baudrate, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            TELogFactory.getNormalLogger().error("set serial port params error", (Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeConnect() {
        try {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error(ex.getMessage());
        }
        finally {
            try {
                if (this.port != null) {
                    this.port.close();
                    this.port = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().error(ex.getMessage());
            }
        }
        this.setLoginStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getIsNeConnected() {
        Object object = this.conectObj;
        synchronized (object) {
            if (TESysManagerConstants.isSerialPort(this.connectType)) {
                return this.port != null;
            }
            return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
        }
    }

    public int sendDataPacket(DataPacket dataPacket) throws InterruptedException, IOException, SocketException {
        if (this.cmdNum == 0) {
            return -1;
        }
        byte[] data = dataPacket.getPacketInfor();
        if (null == data) {
            return -1;
        }
        return this.sendData(data, 0, data.length, dataPacket.getWaitTime());
    }

    public boolean isLoginReceive() {
        int i = 0;
        boolean isOK = false;
        while (i++ < 5) {
            if (this.isReceive) {
                isOK = true;
                break;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return isOK;
    }

    private synchronized int sendData(byte[] b, int offset, int length, long waitTime) throws InterruptedException, IOException, SocketException {
        if (null == this.outStream) {
            return -1;
        }
        if (length > 0) {
            this.notifyAll();
            byte[] mbyte = new byte[length];
            System.arraycopy(b, offset, mbyte, 0, length);
        }
        this.wait(waitTime);
        this.isReceive = false;
        this.outStream.write(b, offset, length);
        this.outStream.flush();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] recvData(int offset) {
        int available = 0;
        byte[] result = null;
        if (null == this.inStream) {
            return result;
        }
        try {
            Object object = this.m_PrevBuff_lock;
            synchronized (object) {
                available = this.inStream.available();
                if (null == this.m_PrevBuff && available == 0) {
                    return result;
                }
                if (null != this.m_PrevBuff) {
                    available += this.m_PrevBuff.length;
                }
                result = new byte[available];
                if (null != this.m_PrevBuff) {
                    System.arraycopy(this.m_PrevBuff, 0, result, 0, this.m_PrevBuff.length);
                    available -= this.m_PrevBuff.length;
                    offset += this.m_PrevBuff.length;
                }
                this.inStream.readFully(result, offset, available);
                this.m_PrevBuff = null;
                if (TESysManagerConstants.isSerialPort(this.connectType)) {
                    this.processDispalyInfo(result);
                } else {
                    this.processRecvBuff(result);
                }
            }
        }
        catch (SocketTimeoutException ste) {
            TELogFactory.getNormalLogger().error(ste.getMessage());
        }
        catch (EOFException eof) {
            TELogFactory.getNormalLogger().error(eof.getMessage());
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error(ex.getMessage());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] processRecvBuff(byte[] buff) throws DataFormatException, InterruptedException {
        int nleavingCount;
        byte[] packetInforData = null;
        if (0 == buff.length) {
            return null;
        }
        if (buff.length == 16) {
            TELogFactory.getNormalLogger().error("\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3");
        }
        int packHeadLen = 16;
        int nCursor = 0;
        if (buff.length < packHeadLen) {
            return null;
        }
        while ((nleavingCount = buff.length - nCursor) > 0) {
            if (nleavingCount < packHeadLen) {
                Object object = this.m_PrevBuff_lock;
                synchronized (object) {
                    this.m_PrevBuff = new byte[nleavingCount];
                    System.arraycopy(buff, nCursor, this.m_PrevBuff, 0, nleavingCount);
                    this.m_PrevBuff_lock.notifyAll();
                    break;
                }
            }
            byte[] packetHeadData = new byte[packHeadLen];
            System.arraycopy(buff, nCursor, packetHeadData, 0, packHeadLen);
            PacketHead packetHead = CommonFunc.convertPacket(packetHeadData);
            short DataLen = packetHead.getLen();
            nleavingCount = buff.length - (nCursor += packHeadLen);
            if (nleavingCount < 0) break;
            if (nleavingCount < DataLen) {
                Object object = this.m_PrevBuff_lock;
                synchronized (object) {
                    this.m_PrevBuff = new byte[nleavingCount + packHeadLen];
                    System.arraycopy(buff, nCursor - packHeadLen, this.m_PrevBuff, 0, nleavingCount + packHeadLen);
                    this.m_PrevBuff_lock.notifyAll();
                    break;
                }
            }
            if (DataLen > 0) {
                packetInforData = new byte[DataLen];
                System.arraycopy(buff, nCursor, packetInforData, 0, DataLen);
            }
            if (null != packetInforData) {
                DataPacket pack = new DataPacket(packetHead, packetInforData);
                this.processRevPack(pack);
            }
            if ((nCursor += DataLen) <= buff.length - 1) continue;
        }
        return null;
    }

    private void processRevPack(DataPacket dataPacket) throws DataFormatException, InterruptedException {
        if (!this.getIsNeConnected()) {
            return;
        }
        short cmdType = dataPacket.getHead().getCmd();
        switch (cmdType) {
            case 100: {
                this.closeConnect();
                throw new DataFormatException("Ne Has reached the limit(Max. connection is 16).ErrorCode: 36864");
            }
            case 0: 
            case 3: {
                short dataLength = dataPacket.getHead().getLen();
                if (dataLength <= 0) break;
                byte[] buff = new byte[dataLength + 1];
                if (10 == dataPacket.getPacketInfor()[0]) {
                    System.arraycopy(dataPacket.getPacketInfor(), 1, buff, 0, dataLength - 1);
                } else {
                    System.arraycopy(dataPacket.getPacketInfor(), 0, buff, 0, dataLength);
                }
                buff[dataLength] = 0;
                dataPacket.setPacketInfor(buff);
                this.processDispalyInfo(dataPacket.getPacketInfor());
                break;
            }
            case 103: {
                TELogFactory.getNormalLogger().error("link response package\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3\u00a1\u00a3");
                break;
            }
            case 5: {
                TELogFactory.getNormalLogger().error("receive QX packet.ErrorCode: 36880");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                TELogFactory.getNormalLogger().error("recv osloop");
                break;
            }
        }
    }

    private void processDispalyInfo(byte[] packetInfor) throws InterruptedException {
        String info = new String(packetInfor).trim();
        if (null != this.m_PrevInfo) {
            this.m_PrevInfo.append("\r\n");
            this.m_PrevInfo.append(info);
        } else {
            this.m_PrevInfo = new StringBuffer(info);
        }
        this.putInfo(this.m_PrevInfo);
        this.m_PrevInfo = null;
    }

    public int getCmdNum() {
        return this.cmdNum;
    }

    public void setCmdNum(int cmdNum) {
        this.cmdNum = cmdNum;
    }

    public synchronized String getNeAddress() {
        return this.neAddress;
    }

    public int getNePort() {
        return this.nePort;
    }

    public StringBuffer getDisplayInfo() {
        return this.displayInfo;
    }

    public void setLoginStatus(boolean loginStatus) {
        this.loginStatus = loginStatus;
    }

    public boolean getLoginStatus() {
        return this.getIsNeConnected() && this.loginStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInfo(StringBuffer buffInfo) throws InterruptedException {
        Object object = this.m_PrevInfo_lock;
        synchronized (object) {
            String temp = this.isSuccessful(buffInfo.toString());
            this.displayInfo.append(temp.concat("</br>"));
            this.isReceive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInfo() throws InterruptedException {
        Object object = this.m_PrevInfo_lock;
        synchronized (object) {
            this.displayInfo.delete(0, this.displayInfo.capacity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String isSuccessful(String tempinfo) {
        Object object = this.m_PrevInfo_lock;
        synchronized (object) {
            if (null == tempinfo) {
                return tempinfo;
            }
            String temp = IOStreamConvertor.removeSpecialStr(tempinfo);
            temp = IOStreamConvertor.replaceSpecialStr(temp);
            temp = temp.replaceAll(" ", "&nbsp;").replaceAll("\r\n", "</br>");
            int len = errLabels.length;
            for (int label = 0; label < len; ++label) {
                if (!tempinfo.toLowerCase(Locale.ENGLISH).contains(errLabels[label])) continue;
                temp = errSpanStart.concat(temp).concat(errSpanEnd);
                break;
            }
            return temp;
        }
    }

    public synchronized int getCompleteCmdIndex() {
        return this.completeCmdIndex;
    }

    public synchronized void setCompleteCmdIndex(int completeCmdIndex) {
        this.completeCmdIndex = completeCmdIndex;
    }

    public String getSrcIP() {
        return this.srcIP;
    }

    public void setSrcIP(String srcIP) {
        this.srcIP = srcIP;
    }

    public String getStrUserName() {
        return this.strUserName;
    }

    public void setStrUserName(String strUserName) {
        this.strUserName = strUserName;
    }

    public int getConnectType() {
        return this.connectType;
    }

    public void setConnectType(int connectType) {
        this.connectType = connectType;
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }
}

