/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.nemmlconfig.TENeConnectMgr;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DisplayResponse_v1r3c00
extends TENEExplorerBean {
    private static final String LINE = "\r\n";
    private static final CharSequence ERRTAG = "<span style='color:red'>";

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        int iLength = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < iLength; ++i) {
            String strNeid = inputData.getBussinessParams().getRowParams(i).getParam("neID").getValue();
            TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(strNeid));
            String neIP = ne.getNEGWAddress();
            int nePort = Integer.valueOf(ne.getPort());
            int neGWType = ne.getNEGWType();
            NeConnect connect = null;
            try {
                String localAddr = InetAddress.getLocalHost().getHostAddress();
                connect = TESysManagerConstants.isSerialPort(neGWType) ? TENeConnectMgr.getInstance().getNeConnect(nePort, localAddr) : TENeConnectMgr.getInstance().getNeConnect(neIP, localAddr);
                if (null == connect) continue;
                try {
                    this.handleOutput(bussinessParams, connect);
                }
                catch (InterruptedException e) {
                    TELogFactory.getNormalLogger().error("DisplayResponse.performBussinessProcess() fail!", (Throwable)e);
                }
                continue;
            }
            catch (UnknownHostException e1) {
                TELogFactory.getNormalLogger().error("DisplayResponse.performBussinessProcess() fail!", (Throwable)e1);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return this.outputData;
    }

    public void handleOutput(BussinessParams bussinessParams, NeConnect connect) throws InterruptedException {
        RowParams rowparams = new RowParams();
        String tmpInfo = connect.getDisplayInfo().toString().trim();
        if (!"".equals(tmpInfo)) {
            tmpInfo.concat(LINE);
        }
        TELogFactory.getNormalLogger().info("displayinfo:" + tmpInfo);
        Param param = new Param("displayinfo", tmpInfo);
        rowparams.addParam(param);
        param = new Param("isNeConnected", String.valueOf(connect.getIsNeConnected()));
        rowparams.addParam(param);
        if (connect.getCompleteCmdIndex() == -1) {
            param = new Param("isComplete", String.valueOf(true));
            TELogFactory.getNormalLogger().info("isComplete:true;");
        } else {
            param = new Param("isComplete", String.valueOf(false));
            TELogFactory.getNormalLogger().info("isComplete:false;");
        }
        rowparams.addParam(param);
        param = new Param("errtag", "" + tmpInfo.contains(ERRTAG));
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }
}

