/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEGetUSBSerialPortAndBaudRate;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.nemmlconfig.TENeConnectMgr;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DisplayResponse
implements TENEListInterface {
    private static final String LINE = "\r\n";
    private static final CharSequence ERRTAG = "<span style='color:red'>";

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        int cmdType = Integer.valueOf(rowParams.getParam("cmdType").getValue());
        String neIP = null;
        int nePort = 0;
        int neGWType = 1;
        if (cmdType == 0) {
            int neID = Integer.valueOf(rowParams.getParam("neID").getValue());
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            neIP = ne.getNEGWAddress();
            nePort = Integer.valueOf(ne.getPort());
            neGWType = ne.getNEGWType();
        } else {
            nePort = Integer.valueOf(TEGetUSBSerialPortAndBaudRate.getUSBSerialPort());
            neGWType = 5;
        }
        try {
            String localAddr = InetAddress.getLocalHost().getHostAddress();
            NeConnect connect = null;
            connect = TESysManagerConstants.isSerialPort(neGWType) ? TENeConnectMgr.getInstance().getNeConnect(nePort, localAddr) : TENeConnectMgr.getInstance().getNeConnect(neIP, localAddr);
            if (null != connect) {
                BussinessParams bussinessParams = new BussinessParams();
                outputData.setBussinessParams(bussinessParams);
                try {
                    this.handleOutput(bussinessParams, connect);
                }
                catch (InterruptedException e) {
                    TELogFactory.getNormalLogger().error("DisplayResponse.performBussinessProcess() fail!", (Throwable)e);
                }
            }
        }
        catch (UnknownHostException e1) {
            TELogFactory.getNormalLogger().error("DisplayResponse.performBussinessProcess() fail!", (Throwable)e1);
        }
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return outputData;
    }

    public void handleOutput(BussinessParams bussinessParams, NeConnect connect) throws InterruptedException {
        RowParams rowparams = new RowParams();
        String tmpInfo = connect.getDisplayInfo().toString().trim();
        if (!"".equals(tmpInfo)) {
            tmpInfo.concat(LINE);
        }
        String displayInfo = "";
        Param param = new Param("isNeConnected", String.valueOf(connect.getIsNeConnected()));
        rowparams.addParam(param);
        if (connect.getCompleteCmdIndex() == -1) {
            param = new Param("isComplete", String.valueOf(true));
            displayInfo = tmpInfo;
        } else {
            param = new Param("isComplete", String.valueOf(false));
        }
        rowparams.addParam(param);
        param = new Param("displayinfo", displayInfo);
        rowparams.addParam(param);
        param = new Param("errtag", "" + tmpInfo.contains(ERRTAG));
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }
}

