/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemmlconfig.DataPacket;
import com.huawei.nglct.nemmlconfig.PacketHead;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;

public class CommonFunc {
    private CommonFunc() {
    }

    public static boolean ipIsValid(String ip) {
        boolean isValid = false;
        int dotPosition = null == ip ? 0 : ip.indexOf(46);
        int loopTime = 0;
        String partOfIp = "";
        while (dotPosition > 0 && !"".equals(partOfIp = ip.substring(0, dotPosition))) {
            ip = ip.substring(dotPosition + 1);
            dotPosition = ip.indexOf(46);
            ++loopTime;
        }
        if (loopTime == 3) {
            isValid = true;
        }
        return isValid;
    }

    public static String byteToString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(bytes[i]).append(' ');
        }
        return buffer.toString();
    }

    public static final int readUnsignedByte(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public static final byte[] short2Bytes(short a) {
        byte[] b = new byte[]{(byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return b;
    }

    public static final byte[] UnsignedShort2Bytes(int a) {
        byte[] b = new byte[]{(byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return b;
    }

    public static final int readUnsignedShort(byte[] b, int offset) {
        int ch1 = CommonFunc.readUnsignedByte(b[0 + offset]);
        int ch2 = CommonFunc.readUnsignedByte(b[1 + offset]);
        return (ch1 << 8) + (ch2 << 0);
    }

    public static final byte[] int2Bytes(int a) {
        byte[] b = new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return b;
    }

    public static final int readInt(byte[] b, int offset) {
        int ch1 = CommonFunc.readUnsignedByte(b[0 + offset]);
        int ch2 = CommonFunc.readUnsignedByte(b[1 + offset]);
        int ch3 = CommonFunc.readUnsignedByte(b[2 + offset]);
        int ch4 = CommonFunc.readUnsignedByte(b[3 + offset]);
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final byte[] long2Bytes(long a) {
        byte[] b = new byte[]{(byte)(a >> 56 & 0xFFL), (byte)(a >> 48 & 0xFFL), (byte)(a >> 40 & 0xFFL), (byte)(a >> 32 & 0xFFL), (byte)(a >> 24 & 0xFFL), (byte)(a >> 16 & 0xFFL), (byte)(a >> 8 & 0xFFL), (byte)(a & 0xFFL)};
        return b;
    }

    public static DataPacket getPacket(String cmd, int connectType, int dest) {
        DataPacket dataPacket = CommonFunc.getPacket(cmd, 100L, connectType, dest);
        cmd = null;
        return dataPacket;
    }

    public static DataPacket getPacket(String cmd, long waitTime, int connectType, int dest) {
        DataPacket dataPacket = CommonFunc.getPacket(cmd, "", waitTime, connectType, dest);
        cmd = null;
        return dataPacket;
    }

    public static DataPacket getPacket(String cmd, String comment, int connectType, int dest) {
        DataPacket dataPacket = CommonFunc.getPacket(cmd, 100L, connectType, dest);
        dataPacket.setComment(comment);
        cmd = null;
        return dataPacket;
    }

    public static DataPacket getPacket(String cmd, String comment, long waitTime, int connectType, int dest) {
        DataPacket dataPacket = CommonFunc.getPacket(cmd, 0, dest, connectType);
        dataPacket.setWaitTime(waitTime);
        dataPacket.setComment("".equals(comment) ? cmd : comment);
        cmd = null;
        return dataPacket;
    }

    public static DataPacket getPacket(String cmd, int src, int dst, int connectType) {
        byte[] cmd2Bytes = cmd.getBytes();
        int index = 0;
        DataPacket dataPacket = new DataPacket();
        if (TESysManagerConstants.isSerialPort(connectType)) {
            if (cmd.indexOf(":lognew") >= 0) {
                byte[] data = new byte[cmd2Bytes.length + 3];
                data[0] = 13;
                index = 1;
                System.arraycopy(cmd2Bytes, 0, data, index, cmd2Bytes.length);
                data[index += cmd2Bytes.length] = 59;
                data[index + 1] = 13;
                dataPacket.setPacketInfor(data);
            } else {
                byte[] data = new byte[cmd2Bytes.length + 2];
                System.arraycopy(cmd2Bytes, 0, data, index, cmd2Bytes.length);
                data[index += cmd2Bytes.length] = 59;
                data[index + 1] = 13;
                dataPacket.setPacketInfor(data);
            }
        } else {
            PacketHead head = new PacketHead();
            head.setSrc(src);
            head.setDst(dst);
            head.setReserved(0);
            head.setCmd((short)3);
            head.setLen((short)(cmd2Bytes.length + 3));
            byte[] data = new byte[head.getHeadLength() + head.getLen()];
            byte[] temp = CommonFunc.int2Bytes(head.getDst());
            System.arraycopy(temp, 0, data, index, temp.length);
            index += temp.length;
            temp = CommonFunc.int2Bytes(head.getSrc());
            System.arraycopy(temp, 0, data, index, temp.length);
            index += temp.length;
            temp = CommonFunc.short2Bytes(head.getCmd());
            System.arraycopy(temp, 0, data, index, temp.length);
            index += temp.length;
            temp = CommonFunc.short2Bytes(head.getLen());
            System.arraycopy(temp, 0, data, index, temp.length);
            index += temp.length;
            temp = CommonFunc.int2Bytes(head.getReserved());
            System.arraycopy(temp, 0, data, index, temp.length);
            System.arraycopy(cmd2Bytes, 0, data, index += temp.length, cmd2Bytes.length);
            data[index += cmd2Bytes.length] = 59;
            data[index + 1] = 13;
            data[index + 2] = 0;
            dataPacket.setHead(head);
            dataPacket.setPacketInfor(data);
        }
        return dataPacket;
    }

    public static PacketHead convertPacket(byte[] packetHeadData) {
        PacketHead head = new PacketHead();
        byte[] temp = null;
        int cursor = 0;
        temp = new byte[4];
        System.arraycopy(packetHeadData, cursor, temp, 0, temp.length);
        head.setDst(CommonFunc.readInt(temp, 0));
        System.arraycopy(packetHeadData, cursor += temp.length, temp, 0, temp.length);
        head.setSrc(CommonFunc.readInt(temp, 0));
        cursor += temp.length;
        temp = new byte[2];
        System.arraycopy(packetHeadData, cursor, temp, 0, temp.length);
        head.setCmd((short)CommonFunc.readUnsignedShort(temp, 0));
        System.arraycopy(packetHeadData, cursor += temp.length, temp, 0, temp.length);
        head.setLen((short)CommonFunc.readUnsignedShort(temp, 0));
        cursor += temp.length;
        temp = new byte[4];
        System.arraycopy(packetHeadData, cursor, temp, 0, temp.length);
        head.setDst(CommonFunc.readInt(temp, 0));
        head.setReserved(CommonFunc.readInt(temp, 0));
        return head;
    }

    public static boolean isInforComplete(StringBuffer stringbuff) {
        boolean isComplete = true;
        if (stringbuff != null) {
            String tempInfor = stringbuff.toString();
            if (tempInfor.indexOf("INSTALLED-BOARD") >= 0) {
                isComplete = tempInfor.indexOf("Total records") > 0;
            } else if (tempInfor.indexOf("SM_GET_ALLUSER") >= 0) {
                isComplete = tempInfor.indexOf("Total records") > 0;
            } else if (tempInfor.indexOf("Last log time") >= 0) {
                isComplete = tempInfor.indexOf("Please modify your password") > 0;
            }
        }
        return isComplete;
    }

    public static ArrayList<String> getCmdsFromFile(File fileName) {
        ArrayList<String> al = new ArrayList<String>(0);
        try {
            BufferedReader bufreader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
            String lineMsg = null;
            while ((lineMsg = bufreader.readLine()) != null) {
                if ((lineMsg = lineMsg.trim()).startsWith("//")) continue;
                if (lineMsg.startsWith(":")) {
                    lineMsg = lineMsg.endsWith(";") ? lineMsg : lineMsg.concat(";");
                    al.add(lineMsg);
                    continue;
                }
                if (lineMsg.indexOf(58) >= 0 || !(lineMsg = lineMsg.toLowerCase(Locale.ENGLISH)).startsWith("sleep")) continue;
                lineMsg = lineMsg.endsWith(";") ? lineMsg : lineMsg.concat(";");
                lineMsg = lineMsg.endsWith("ms;") ? lineMsg : lineMsg.concat("ms;");
                al.add(lineMsg);
            }
            bufreader.close();
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("CommonFunc.getCmdsFromFile() fail!", (Throwable)ex);
        }
        return al;
    }

    public static String filteNumber(String target) {
        if (null == target) {
            return "0";
        }
        StringBuffer buff = new StringBuffer(0);
        char[] chararr = target.toCharArray();
        char b2 = ' ';
        for (char b2 : chararr) {
            if (!Character.isDigit(b2)) continue;
            buff.append(b2);
        }
        return buff.toString();
    }
}

