/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEGetUSBSerialPortAndBaudRate;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.nemmlconfig.TENeConnectMgr;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CancelMmlConfig
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        int iLength = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < iLength; ++i) {
            RowParams row = inputData.getBussinessParams().getRowParams(i);
            int cmdType = Integer.valueOf(row.getParam("cmdType").getValue());
            String neIP = null;
            int nePort = 0;
            int neGWType = 1;
            if (cmdType == 0) {
                int neID = Integer.valueOf(row.getParam("neID").getValue());
                TENE ne = TENEListMgr.getInstance().getNE(neID);
                neIP = ne.getNEGWAddress();
                nePort = Integer.valueOf(ne.getPort());
                neGWType = ne.getNEGWType();
            } else {
                nePort = Integer.valueOf(TEGetUSBSerialPortAndBaudRate.getUSBSerialPort());
                neGWType = 5;
            }
            try {
                String localAddr = InetAddress.getLocalHost().getHostAddress();
                NeConnect connect = null;
                connect = TESysManagerConstants.isSerialPort(neGWType) ? TENeConnectMgr.getInstance().getNeConnect(nePort, localAddr) : TENeConnectMgr.getInstance().getNeConnect(neIP, localAddr);
                if (null == connect) continue;
                connect.closeConnect();
                continue;
            }
            catch (UnknownHostException e1) {
                TELogFactory.getNormalLogger().error("CancelMmlConfig.performBussinessProcess() fail!", (Throwable)e1);
            }
        }
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return outputData;
    }
}

