/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemmlconfig;

import com.huawei.nglct.nemmlconfig.NeConnect;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import java.util.Timer;
import java.util.TimerTask;

public class CMDMonitor
extends Thread {
    private NeConnect connect;
    private byte[] result;
    private Timer timer;
    private long waitTime;
    private TimerTask task = new inputTask();

    public CMDMonitor(NeConnect connect, long waitTime) {
        this.connect = connect;
        this.waitTime = TESysManagerConstants.isSerialPort(connect.getConnectType()) ? waitTime / 100L : waitTime / 500L;
    }

    public CMDMonitor(NeConnect connect, String name, long waitTime) {
        super(name);
        this.connect = connect;
        this.waitTime = TESysManagerConstants.isSerialPort(connect.getConnectType()) ? waitTime / 100L : waitTime / 500L;
    }

    @Override
    public void run() {
        this.timer = new Timer();
        if (TESysManagerConstants.isSerialPort(this.connect.getConnectType())) {
            this.timer.scheduleAtFixedRate(this.task, 0L, 100L);
        } else {
            this.timer.scheduleAtFixedRate(this.task, 500L, 500L);
        }
    }

    private class inputTask
    extends TimerTask {
        int index = 0;

        private inputTask() {
        }

        @Override
        public void run() {
            if (CMDMonitor.this.connect.getIsNeConnected()) {
                CMDMonitor.this.connect.recvData(0);
                if (null != CMDMonitor.this.result && CMDMonitor.this.result.length > 0) {
                    this.index = 0;
                } else {
                    if ((long)this.index >= CMDMonitor.this.waitTime) {
                        CMDMonitor.this.connect.closeConnect();
                        CMDMonitor.this.connect.setCompleteCmdIndex(-1);
                        CMDMonitor.this.timer.cancel();
                    }
                    ++this.index;
                }
            } else {
                CMDMonitor.this.connect.setCompleteCmdIndex(-1);
                CMDMonitor.this.timer.cancel();
            }
        }
    }
}

