/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.pnp.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunAttrParam;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrMgr;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrObj;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrOption;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgColKeyObj;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgShowCol;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPSelectInput;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPTextInput;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEPNPGenCfgInterpreter
extends XMLInterpreterImpl {
    private static final String READ_ONLY = "0";

    @Override
    public int interpretXMLTag(Node tag) {
        try {
            NodeList attrList = ((Element)tag).getElementsByTagName("gencfgattr");
            Element attrNode = null;
            TEPNPGenCfgAttrObj attrObj = null;
            int iSize = attrList.getLength();
            for (int i = 0; i < iSize; ++i) {
                attrNode = (Element)attrList.item(i);
                if (!attrNode.hasChildNodes() && !attrNode.hasAttributes()) {
                    return 0;
                }
                String attrId = attrNode.getAttributeNode("id").getValue();
                String attrMacro = attrNode.getAttributeNode("value").getValue();
                if (attrMacro == null || "".equals(attrMacro)) {
                    attrMacro = "-1";
                }
                String neType = attrNode.getAttribute("supportDevType");
                String supportNeVer = attrNode.getAttribute("supportNeVer");
                attrObj = this.parseAttrNode(attrNode);
                attrObj.setAttrID(attrId);
                attrObj.setAttrMacroValue(Integer.parseInt(attrMacro));
                this.parseNeVer(attrObj, supportNeVer);
                TEPNPGenCfgAttrMgr.getInstance().addAttr(neType, attrId, attrObj);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEPNPGenCfgInterpreter.interpretXMLTag() fail!", (Throwable)e);
        }
        return 0;
    }

    private void parseNeVer(TEPNPGenCfgAttrObj attrObj, String supportNeVer) {
        String tempVerStr = supportNeVer.substring(supportNeVer.indexOf("[") + 1, supportNeVer.indexOf("]"));
        String[] verArr = tempVerStr.split("-");
        attrObj.setSupportMinNeVer(verArr[0]);
        attrObj.setSupportMaxNeVer(verArr[1]);
    }

    private TEPNPGenCfgAttrObj parseAttrNode(Element attrNode) {
        TEPNPGenCfgAttrObj attrObj = new TEPNPGenCfgAttrObj();
        NodeList subNodeList = attrNode.getElementsByTagName("attrdescrib");
        if (subNodeList != null && subNodeList.getLength() > 0) {
            this.parseAttrDescrib(attrObj, (Element)subNodeList.item(0));
        }
        if ((subNodeList = attrNode.getElementsByTagName("attrshow")) != null && subNodeList.getLength() > 0) {
            this.parseAttrShow(attrObj, (Element)subNodeList.item(0));
        }
        if ((subNodeList = attrNode.getElementsByTagName("belongfun")) != null && subNodeList.getLength() > 0) {
            this.parseBelongFun(attrObj, (Element)subNodeList.item(0));
        }
        if ((subNodeList = attrNode.getElementsByTagName("qxMapping")) != null && subNodeList.getLength() > 0) {
            this.parseQxMapping(attrObj, (Element)subNodeList.item(0));
        }
        String baseURI = attrNode.getBaseURI();
        String filePath = baseURI.substring(baseURI.indexOf("nemgr"), baseURI.lastIndexOf("/")) + "/qxdescrib.xml";
        attrObj.setQxFilePath(filePath);
        return attrObj;
    }

    private void parseAttrDescrib(TEPNPGenCfgAttrObj attrObj, Element attrDescribNode) {
        Element subNode = (Element)attrDescribNode.getElementsByTagName("attrname").item(0);
        String attrZHName = subNode.getAttribute("zh");
        String attrENName = subNode.getAttribute("en");
        attrObj.setAttrZHName(attrZHName);
        attrObj.setAttrENName(attrENName);
        subNode = (Element)attrDescribNode.getElementsByTagName("attrvalue").item(0);
        NodeList optionList = subNode.getElementsByTagName("option");
        TEPNPGenCfgAttrOption attrOption = null;
        int iSize = optionList.getLength();
        for (int i = 0; i < iSize; ++i) {
            Element optionNode = (Element)optionList.item(i);
            String optionValue = optionNode.getAttribute("value");
            String zhName = optionNode.getAttribute("zh_name");
            String enName = optionNode.getAttribute("en_name");
            attrOption = new TEPNPGenCfgAttrOption(optionValue, zhName, enName);
            attrObj.addAttrValueOption(attrOption);
        }
    }

    private void parseAttrShow(TEPNPGenCfgAttrObj attrObj, Element attrShowNode) {
        TEPNPGenCfgShowCol showColObj = new TEPNPGenCfgShowCol();
        Element subNode = (Element)attrShowNode.getElementsByTagName("col").item(0);
        String colId = subNode.getAttribute("id");
        String isSort = subNode.getAttribute("isSort");
        String width = subNode.getAttribute("width");
        showColObj.setColId(colId);
        showColObj.setIsSort(isSort);
        showColObj.setColWidth(width);
        NodeList cellNodeList = subNode.getElementsByTagName("cell");
        Element cellNode = null;
        int iSize = cellNodeList.getLength();
        for (int i = 0; i < iSize; ++i) {
            cellNode = (Element)cellNodeList.item(i);
            this.processCellEdit(showColObj, cellNode);
        }
        attrObj.setShowColObj(showColObj);
    }

    private void processCellEdit(TEPNPGenCfgShowCol showColObj, Element cellNode) {
        String isEdit = cellNode.getAttribute("isEdit");
        String showElement = ((Element)cellNode.getElementsByTagName("showElement").item(0)).getAttribute("type");
        showColObj.setShowElementType(showElement);
        Element keyNode = (Element)cellNode.getElementsByTagName("key").item(0);
        NodeList optionNodeList = keyNode.getElementsByTagName("option");
        int jSize = optionNodeList.getLength();
        for (int j = 0; j < jSize; ++j) {
            Element optionNode = (Element)optionNodeList.item(j);
            String name = optionNode.getAttribute("name");
            String convert = optionNode.getAttribute("convert");
            showColObj.addKeyOption(new TEPNPGenCfgColKeyObj(name, convert));
        }
        showColObj.setIsEdit(isEdit);
        if (isEdit.equals(READ_ONLY)) {
            return;
        }
        Element editElement = (Element)cellNode.getElementsByTagName("editElement").item(0);
        if (editElement != null) {
            String editType = editElement.getAttribute("type");
            if (editType == null || editType.equals("")) {
                return;
            }
            if (editType.equalsIgnoreCase("text")) {
                showColObj.setEditElementType(editType);
                TEPNPTextInput textInput = new TEPNPTextInput();
                String inputType = editElement.getAttribute("inputType");
                if (inputType == null || inputType.equals("")) {
                    return;
                }
                if (inputType.equalsIgnoreCase("num")) {
                    String range = editElement.getAttribute("range");
                    textInput.setRange(range);
                } else if (inputType.equalsIgnoreCase("string")) {
                    String inputLength = editElement.getAttribute("inputLength");
                    textInput.setInputLength(inputLength);
                }
                textInput.setInputType(inputType);
                showColObj.setTextInput(textInput);
            } else if (editType.equalsIgnoreCase("select")) {
                showColObj.setEditElementType(editType);
                TEPNPSelectInput selectInput = new TEPNPSelectInput();
                TEPNPGenCfgAttrOption option = null;
                NodeList optionList = editElement.getElementsByTagName("option");
                Element optionNode = null;
                int iSize = optionList.getLength();
                for (int i = 0; i < iSize; ++i) {
                    optionNode = (Element)optionList.item(i);
                    String optionValue = optionNode.getAttribute("value");
                    String optionZhName = optionNode.getAttribute("zh_name");
                    String optionEnName = optionNode.getAttribute("en_name");
                    option = new TEPNPGenCfgAttrOption(optionValue, optionZhName, optionEnName);
                    selectInput.addOption(option);
                }
                showColObj.setSelectInput(selectInput);
            }
        }
    }

    private void parseBelongFun(TEPNPGenCfgAttrObj attrObj, Element belongFunNode) {
        String funid = belongFunNode.getAttribute("funid");
        String subPageName = ((Element)belongFunNode.getElementsByTagName("subpage").item(0)).getAttribute("name");
        attrObj.setBelongFunID(funid);
        attrObj.setSubPageName(subPageName);
    }

    private void parseQxMapping(TEPNPGenCfgAttrObj attrObj, Element qxMappingNode) {
        NodeList nodeList = qxMappingNode.getElementsByTagName("group_define");
        HashMap groupMap = new HashMap();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            this.handleGroupNode(nodeList.item(i), groupMap);
        }
        TEGenCfgFunCmd obj = new TEGenCfgFunCmd();
        nodeList = qxMappingNode.getElementsByTagName("action");
        Element action = null;
        ArrayList qxlist = null;
        String actionName = "";
        int len2 = nodeList.getLength();
        for (int i = 0; i < len2; ++i) {
            action = (Element)nodeList.item(i);
            actionName = action.getAttribute("name");
            qxlist = this.handleActionNode(action, groupMap);
            if (null == qxlist) continue;
            if (actionName.equalsIgnoreCase("QueryFromNE")) {
                obj.setQueryQxList(qxlist);
                continue;
            }
            if (!actionName.equalsIgnoreCase("SET")) continue;
            obj.setSetQxList(qxlist);
        }
        attrObj.setFunCmd(obj);
    }

    private void handleGroupNode(Node groupNode, HashMap groupMap) {
        NodeList itemNodeList = ((Element)groupNode).getElementsByTagName("item");
        Element itemEle = null;
        Integer groupId = null;
        ArrayList groupAttrList = null;
        int len = itemNodeList.getLength();
        for (int i = 0; i < len; ++i) {
            itemEle = (Element)itemNodeList.item(i);
            groupId = Integer.valueOf(itemEle.getAttribute("groupID"));
            groupAttrList = TEParseXMLFile.splitFromChar(itemEle.getAttribute("attrID"), ',');
            if (null == groupAttrList) continue;
            groupMap.put(groupId, groupAttrList);
        }
    }

    private ArrayList handleActionNode(Element action, HashMap groupMap) {
        ArrayList<TEGenCfgFunAttr> attrList = new ArrayList<TEGenCfgFunAttr>();
        NodeList nodelist = action.getElementsByTagName("attr");
        NodeList cmdlist = null;
        NodeList tmp = null;
        Element attrElement = null;
        TEGenCfgFunAttr funAttr = null;
        TEGenCfgFunAttrParam param = null;
        Integer groupId = null;
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            attrElement = (Element)nodelist.item(i);
            cmdlist = attrElement.getElementsByTagName("qx5_req_cmd_param");
            if (cmdlist.getLength() <= 0) continue;
            funAttr = new TEGenCfgFunAttr();
            funAttr.setAttrId(attrElement.getAttribute("id"));
            tmp = attrElement.getElementsByTagName("object_type");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setObjectType("");
            } else {
                funAttr.setObjectType(((Element)tmp.item(0)).getAttribute("id"));
            }
            tmp = attrElement.getElementsByTagName("ptcode");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setPtcode("");
            } else {
                funAttr.setPtcode(((Element)tmp.item(0)).getAttribute("cmdcode"));
            }
            tmp = attrElement.getElementsByTagName("addition_cmd");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setAdditionCmd("");
            } else if (null != (tmp = ((Element)tmp.item(0)).getElementsByTagName("verifycode")) && tmp.getLength() != 0) {
                funAttr.setAdditionCmd(((Element)tmp.item(0)).getAttribute("cmdcode"));
            }
            tmp = attrElement.getElementsByTagName("recordGroup");
            if (null != tmp && tmp.getLength() != 0) {
                groupId = Integer.valueOf(((Element)tmp.item(0)).getAttribute("groupID"));
                funAttr.setGroupAttrList((ArrayList)groupMap.get(groupId));
            }
            tmp = attrElement.getElementsByTagName("param");
            int size = tmp.getLength();
            for (int index = 0; index < size; ++index) {
                param = new TEGenCfgFunAttrParam();
                param.setId(((Element)tmp.item(index)).getAttribute("id"));
                param.setValue(((Element)tmp.item(index)).getAttribute("value"));
                param.setConvertId(((Element)tmp.item(index)).getAttribute("convertId"));
                funAttr.addParam(param);
            }
            attrList.add(funAttr);
        }
        return attrList;
    }
}

