/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.pnp.gencfg;

import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrObj;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrOption;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgColKeyObj;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgShowCol;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPSelectInput;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPTextInput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEPNPGenCfgAttrMgr {
    private static TEPNPGenCfgAttrMgr instance = null;
    private Map<String, Map<String, TEPNPGenCfgAttrObj>> neTypeAttrMap = new HashMap<String, Map<String, TEPNPGenCfgAttrObj>>();

    private TEPNPGenCfgAttrMgr() {
    }

    public static synchronized TEPNPGenCfgAttrMgr getInstance() {
        if (instance == null) {
            instance = new TEPNPGenCfgAttrMgr();
        }
        return instance;
    }

    public void addAttr(String neType, String attrId, TEPNPGenCfgAttrObj attrObj) {
        if (!this.neTypeAttrMap.containsKey(neType)) {
            this.neTypeAttrMap.put(neType, new HashMap());
        }
        this.neTypeAttrMap.get(neType).put(attrId, attrObj);
    }

    public TEPNPGenCfgAttrObj getAttrById(int neId, String attrId) {
        int neType = TEConfigurationDataMgr.getInstance().getNE(neId).getNEType();
        String neTypeStr = String.valueOf(neType);
        if (!this.neTypeAttrMap.containsKey(neTypeStr)) {
            return null;
        }
        return this.neTypeAttrMap.get(neTypeStr).get(attrId);
    }

    public boolean isContainsInPNP(int neid, String attrId) {
        int neType = TEConfigurationDataMgr.getInstance().getNE(neid).getNEType();
        String neTypeStr = String.valueOf(neType);
        if (!this.neTypeAttrMap.containsKey(neTypeStr)) {
            return false;
        }
        if (!this.neTypeAttrMap.get(neTypeStr).containsKey(attrId)) {
            return false;
        }
        TEPNPGenCfgAttrObj attrObj = this.neTypeAttrMap.get(neTypeStr).get(attrId);
        String neVer = TEConfigurationDataMgr.getInstance().getNE(neid).getHostVersion();
        String minNeVer = attrObj.getSupportMinNeVer();
        String maxNeVer = attrObj.getSupportMaxNeVer();
        if (!minNeVer.equals("") && neVer.compareTo(minNeVer) < 0) {
            return false;
        }
        return maxNeVer.equals("") || neVer.compareTo(maxNeVer) <= 0;
    }

    public RowParams getPNPRowParams(int neid, String attrId) {
        if (!this.isContainsInPNP(neid, attrId)) {
            return null;
        }
        TEPNPGenCfgAttrObj attrObj = this.getAttrById(neid, attrId);
        RowParams rParams = new RowParams();
        rParams.addParam("attrId", attrObj.getAttrID());
        rParams.addParam("attrZHName", attrObj.getAttrZHName());
        rParams.addParam("attrENName", attrObj.getAttrENName());
        rParams.addParam("belongFunID", attrObj.getBelongFunID());
        rParams.addParam("subPageName", attrObj.getSubPageName());
        List<TEPNPGenCfgAttrOption> valueOptionList = attrObj.getAttrValueOptionList();
        Param valueOptionParam = new Param("valueOption", "");
        Param enNameOptionParam = new Param("enNameOption", "");
        Param zhNameOptionParam = new Param("zhNameOption", "");
        int iSize = valueOptionList.size();
        for (int i = 0; i < iSize; ++i) {
            TEPNPGenCfgAttrOption valueOption = valueOptionList.get(i);
            valueOptionParam.addOption(new Option(valueOption.getValue()));
            enNameOptionParam.addOption(new Option(valueOption.getEnName()));
            zhNameOptionParam.addOption(new Option(valueOption.getZhName()));
        }
        rParams.addParam(valueOptionParam);
        rParams.addParam(enNameOptionParam);
        rParams.addParam(zhNameOptionParam);
        TEPNPGenCfgShowCol showCol = attrObj.getShowColObj();
        rParams.addParam("colId", showCol.getColId());
        rParams.addParam("colWidth", showCol.getColWidth());
        rParams.addParam("zhName", showCol.getZhName());
        rParams.addParam("enName", showCol.getEnName());
        rParams.addParam("isSort", showCol.getIsSort());
        rParams.addParam("isEdit", showCol.getIsEdit());
        rParams.addParam("showElement", showCol.getShowElementType());
        List<TEPNPGenCfgColKeyObj> keyOptionList = showCol.getKeyOptionList();
        Param keyOptionParam = new Param("keyOption", "");
        Param convertParam = new Param("convertOption", "");
        int jSize = keyOptionList.size();
        for (int j = 0; j < jSize; ++j) {
            TEPNPGenCfgColKeyObj keyOption = keyOptionList.get(j);
            keyOptionParam.addOption(new Option(keyOption.getKeyName()));
            convertParam.addOption(new Option(keyOption.getConvert()));
        }
        rParams.addParam(keyOptionParam);
        rParams.addParam(convertParam);
        String editElement = showCol.getEditElementType();
        if (!editElement.equals("")) {
            rParams.addParam("editElement", showCol.getEditElementType());
            TEPNPTextInput textInput = showCol.getTextInput();
            if (textInput != null) {
                String inputType = textInput.getInputType();
                rParams.addParam("inputType", inputType);
                if (inputType.equals("num")) {
                    rParams.addParam("range", textInput.getRange());
                } else {
                    rParams.addParam("inputLength", textInput.getInputLength());
                }
            } else {
                TEPNPSelectInput selectInput = showCol.getSelectInput();
                Param optionParam = new Param("option", "");
                Param enNameParam = new Param("enOption", "");
                Param zhNameParam = new Param("zhOption", "");
                List<TEPNPGenCfgAttrOption> optionList = selectInput.getOptionList();
                int kSize = optionList.size();
                for (int k = 0; k < kSize; ++k) {
                    TEPNPGenCfgAttrOption option = optionList.get(k);
                    optionParam.addOption(new Option(option.getValue()));
                    enNameParam.addOption(new Option(option.getEnName()));
                    zhNameParam.addOption(new Option(option.getZhName()));
                }
                rParams.addParam(optionParam);
                rParams.addParam(enNameParam);
                rParams.addParam(zhNameParam);
            }
        }
        return rParams;
    }
}

