/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.pnp.fault;

import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEAlarmKey;
import com.huawei.nglct.nelist.TENEListConstant;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEPNPAlarmInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        if (!node.hasChildNodes()) {
            return 0;
        }
        String name = null;
        NodeList nodeList = node.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            node = nodeList.item(i);
            name = node.getNodeName();
            if (!"alarm_data_description".equals(name)) continue;
            this.parseAlarmInfo(node);
        }
        return 0;
    }

    private void parseAlarmInfo(Node para) {
        NodeList nList = para.getChildNodes();
        int size = nList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nList.item(i);
            String name = node.getNodeName();
            if (!"alarm_info".equalsIgnoreCase(name)) continue;
            this.getAlarmInfo(node);
        }
    }

    private void getAlarmInfo(Node node) {
        TEAlarmKey aKey = new TEAlarmKey();
        TEAlarmData aData = new TEAlarmData();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int m = namedNodeMap.getLength();
        for (int i = 0; i < m; ++i) {
            Node attr = namedNodeMap.item(i);
            this.setAlarmAttr(attr, aKey, aData);
            this.setAlarmDetail(node, aData);
        }
        TENEListConstant.getInstance().getAlmData().put(aKey, aData);
    }

    private void setAlarmAttr(Node node, TEAlarmKey aKey, TEAlarmData aData) {
        String name = node.getNodeName();
        String value = node.getNodeValue();
        if ("euipment_type".equalsIgnoreCase(name)) {
            aKey.setDeviceType(Integer.parseInt(value));
            aData.setEqType(Integer.parseInt(value));
        } else if ("alarm_id".equalsIgnoreCase(name)) {
            aKey.setAlarmID(Integer.parseInt(value));
            aData.setAeID(Integer.parseInt(value));
        } else if ("aid_type".equalsIgnoreCase(name)) {
            aData.setaIDType(Integer.parseInt(value));
        } else if ("alarm_type".equalsIgnoreCase(name)) {
            aData.setAeType(Integer.parseInt(value));
        } else if ("location".equalsIgnoreCase(name)) {
            aData.setLocation(Integer.parseInt(value));
        } else if ("direction".equalsIgnoreCase(name)) {
            aData.setDirection(Integer.parseInt(value));
        } else if ("alarm_severity".equalsIgnoreCase(name)) {
            aData.setAeSeverity(Integer.parseInt(value));
        } else if ("auto_report".equalsIgnoreCase(name)) {
            aData.setAutoReportState(Integer.parseInt(value));
        } else if ("suppress".equalsIgnoreCase(name)) {
            aData.setSuppressState(Integer.parseInt(value));
        } else if ("effect_service".equalsIgnoreCase(name)) {
            aData.setEffectState(Integer.parseInt(value));
        } else if ("probable_case".equalsIgnoreCase(name)) {
            aData.setProbableCase(value);
        } else if ("alarm_name".equalsIgnoreCase(name)) {
            aData.setAeName(value);
        } else if ("object_type".equalsIgnoreCase(name)) {
            aData.setObjectType(Integer.parseInt(value));
        }
    }

    private void setAlarmDetail(Node para, TEAlarmData aData) {
        NodeList nList = para.getChildNodes();
        int size = nList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nList.item(i);
            String name = node.getNodeName();
            if (!this.getKeyWord().equalsIgnoreCase(name)) continue;
            NamedNodeMap nodeAttrMap = node.getAttributes();
            int len = nodeAttrMap.getLength();
            for (int j = 0; j < len; ++j) {
                String attrName = nodeAttrMap.item(j).getNodeName();
                String attrValue = nodeAttrMap.item(j).getNodeValue();
                if ("alarm_detail".equalsIgnoreCase(attrName)) {
                    aData.setAeDetailName(attrValue);
                    continue;
                }
                if (!"alarm_reason".equalsIgnoreCase(attrName)) continue;
                aData.setAeReason(attrValue);
            }
        }
    }

    private String getKeyWord() {
        String preKey = "en".equalsIgnoreCase(TESysManagerBean.getInstance().getlanguage()) ? "en" : "cn";
        String keyWord = preKey + "_alarm_info";
        return keyWord;
    }
}

