/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.pnp.boardmgr;

import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPFuncDescribe;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEPNPPatchInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        if (!node.hasChildNodes()) {
            return 0;
        }
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            node = nodeList.item(i);
            if (!"func".equals(node.getNodeName())) continue;
            this.interpretFunction(node);
        }
        return 0;
    }

    private void interpretFunction(Node node) {
        TEPNPFuncDescribe funcDesc = new TEPNPFuncDescribe();
        this.setFuncInfo(node, funcDesc);
        NodeList nodeList = node.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            TEPNPFuncDescribe.Item item;
            TEPNPFuncDescribe.Properties p;
            node = nodeList.item(i);
            if ("PARAS".equals(node.getNodeName()) && (p = this.interpretParas(node)) != null) {
                funcDesc.addProperties(p);
            }
            if (!"item".equals(node.getNodeName()) || (item = this.interpretItem(node)) == null) continue;
            funcDesc.addItem(item);
        }
    }

    private TEPNPFuncDescribe.Item interpretItem(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        TEPNPFuncDescribe.Item item = new TEPNPFuncDescribe.Item();
        item.setName(this.getNodeName(node));
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            TEPNPFuncDescribe.Properties p;
            node = nodeList.item(i);
            if ("PARAS".equals(node.getNodeName()) && (p = this.interpretParas(node)) != null) {
                item.addProperties(p);
            }
            if (!"item".equals(node.getNodeName())) continue;
            TEPNPFuncDescribe.Item subitem = this.interpretItem(node);
            if (item == null) continue;
            item.addItem(subitem);
        }
        return item;
    }

    private String getNodeName(Node node) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        String itemName = null;
        int i = 0;
        int size = map.getLength();
        if (i < size) {
            node = map.item(i);
            if (node.getNodeName().equals("name")) {
                itemName = node.getNodeValue();
            }
            return itemName;
        }
        return null;
    }

    private TEPNPFuncDescribe.Properties interpretParas(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        TEPNPFuncDescribe.Properties p = new TEPNPFuncDescribe.Properties();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            node = nodeList.item(i);
            if (!"PARA".equals(node.getNodeName())) continue;
            p.addProperty(this.interpretPara(node));
        }
        return p;
    }

    private TEPNPFuncDescribe.Property interpretPara(Node node) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        String itemName = null;
        String itemValue = null;
        int size = map.getLength();
        for (int i = 0; i < size; ++i) {
            node = map.item(i);
            if (node.getNodeName().equals("name")) {
                itemName = node.getNodeValue();
                continue;
            }
            if (!node.getNodeName().equals("value")) continue;
            itemValue = node.getNodeValue();
        }
        return new TEPNPFuncDescribe.Property(itemName, itemValue);
    }

    private void setFuncInfo(Node node, TEPNPFuncDescribe desc) {
        if (node == null) {
            return;
        }
        NamedNodeMap map = node.getAttributes();
        int size = map.getLength();
        for (int i = 0; i < size; ++i) {
            node = map.item(i);
            if (node.getNodeName().equals("name")) {
                desc.setFuncName(node.getNodeValue());
                continue;
            }
            if (!node.getNodeName().equals("id")) continue;
            desc.setFuncId(node.getNodeValue());
        }
    }

    public static void main(String[] args) {
        TEPNPPatchInterpreter inter = new TEPNPPatchInterpreter();
        Document doc = TEParseXMLFile.parseFile("f:\\pnp.xml");
        NodeList nodeList = doc.getElementsByTagName("root");
        inter.interpretXMLTag(nodeList.item(0));
    }
}

