/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.pnp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.pnp.TEPNPBaseLineVerMgr;
import com.huawei.nglct.nelist.pnp.TEPNPFileMgr;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class TEUploadPNPFileMgr {
    public static final String NE_PNP_STORAGE_PATH = "/ofs1/bdm";
    private static final String PNP_FILE_NAME = "PNP_WEBLCT.ZIP";
    private Map<Integer, Integer> uploadStateMap = new HashMap<Integer, Integer>();
    private Map<Integer, String> baselineVerMap = new HashMap<Integer, String>();
    private Map<Integer, String> neVerMap = new HashMap<Integer, String>();
    private static TEUploadPNPFileMgr instance = null;
    private static final int UPLOAD_STATE_UNKNOWN = -1;
    private static final int UPLOAD_STATE_UNLOAD = 0;
    public static final int UPLOAD_STATE_LOADING = 1;
    private static final int UPLOAD_STATE_END = 2;
    private static final int FILE_IS_EXISTED = 1091092492;
    private Logger log = TELogFactory.getNormalLogger();

    private TEUploadPNPFileMgr() {
    }

    public static synchronized TEUploadPNPFileMgr getInstance() {
        if (instance == null) {
            instance = new TEUploadPNPFileMgr();
        }
        return instance;
    }

    public void addNEUploadState(int neid, int state) {
        this.uploadStateMap.put(neid, state);
    }

    public int getNEUploadState(int neid) {
        if (!this.uploadStateMap.containsKey(neid)) {
            return -1;
        }
        return this.uploadStateMap.get(neid);
    }

    public int uploadPNPFile(int neid) {
        if (!this.isNeedUpload(neid)) {
            return 1091092492;
        }
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        String ipAddress = ne.getNEGWAddress();
        String localFilePath = this.getLocalFilePath(neid);
        String fileName = this.getFileName(neid);
        int phyNeID = ne.getRealNEID();
        int result = this.getFileFromNE(ipAddress, phyNeID, NE_PNP_STORAGE_PATH, localFilePath, fileName);
        if (result == 0 || result == 1091092492) {
            TEPNPFileMgr.unZipFile(localFilePath + fileName, localFilePath);
            this.uploadStateMap.put(neid, 2);
            TEPNPBaseLineVerMgr.getInstance().updateBaseLineFile(ne.getNEType(), this.neVerMap.get(neid), this.baselineVerMap.get(neid));
        } else {
            this.uploadStateMap.put(neid, 0);
        }
        this.log.info("<HFCP> Get PNP File ---- result: " + result);
        return result;
    }

    private int getFileFromNE(String ipAddress, int neid, String neFilePath, String localFilePath, String fileName) {
        this.log.info("<HFCP> Get PNP File ---- Begin!");
        this.log.info("<HFCP> Get PNP File ---- IP address is : " + ipAddress);
        this.log.info("<HFCP> Get PNP File ---- File name is : " + fileName);
        this.log.info("<HFCP> Get PNP File ---- NE File Path is : " + neFilePath);
        this.log.info("<HFCP> Get PNP File ---- Local File Path is : " + localFilePath);
        String filePathName = localFilePath + fileName;
        int isSuccess = 0;
        byte[] fileData = TEHFCPHandler.instance().getHFCPFile(neFilePath, localFilePath, fileName, neid);
        isSuccess = TEHFCPHandler.instance().getRet();
        if ((null == fileData || fileData.length == 0) && isSuccess != 0) {
            this.log.info("<HFCP> Get File ---- The file length is 0 or file is null!");
            return isSuccess;
        }
        this.writeFile(localFilePath, filePathName, fileData);
        this.log.info("<HFCP> Get File ---- End!");
        return isSuccess;
    }

    public int writeFile(String localFilePath, String fileName, byte[] fileData) {
        try {
            boolean mkdirRst;
            File directory = new File(localFilePath);
            if (!directory.exists() && !(mkdirRst = directory.mkdirs())) {
                TELogFactory.getNormalLogger().error("Mkdir fail! Path:" + localFilePath);
                return 2;
            }
            BufferedOutputStream bufOut = new BufferedOutputStream(new FileOutputStream(fileName));
            if (null == fileData) {
                fileData = new byte[]{};
            }
            bufOut.write(fileData, 0, fileData.length);
            bufOut.flush();
            bufOut.close();
        }
        catch (Exception e) {
            this.log.error("<HFCP> File Copy Handler ---- Write file exception!", (Throwable)e);
        }
        this.log.info("<HFCP> File Copy Handler ---- Write file result is : 0");
        return 0;
    }

    private String getFileName(int neid) {
        return PNP_FILE_NAME;
    }

    private String getLocalFilePath(int neid) {
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String localFilePath = TEResourceManager.getPath() + File.separator + "nemgr" + File.separator + "device" + File.separator + "ngwdm" + File.separator + "ne_" + neType + File.separator + "conf" + File.separator + "pnp" + File.separator;
        return localFilePath;
    }

    private boolean isNeedUpload(int neid) {
        if (this.uploadStateMap.containsKey(neid) && (this.uploadStateMap.get(neid) == 1 || this.uploadStateMap.get(neid) == 2)) {
            return false;
        }
        Output baselineOutput = this.getBaselineOutput(neid);
        if (baselineOutput == null) {
            return false;
        }
        String baselineVer = baselineOutput.getPartValue("baselinever");
        if (baselineVer == null || baselineVer.equals("")) {
            return false;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        String oldBaseLineVer = TEPNPBaseLineVerMgr.getInstance().getBaseLineVer(neType, baselineOutput.getPartValue("never"));
        if (oldBaseLineVer != null && !oldBaseLineVer.equals("") && oldBaseLineVer.compareTo(baselineVer) >= 0) {
            return false;
        }
        this.baselineVerMap.put(neid, baselineVer);
        this.neVerMap.put(neid, baselineOutput.getPartValue("never"));
        this.uploadStateMap.put(neid, 1);
        return true;
    }

    private Output getBaselineOutput(int neID) {
        try {
            Operation aOperation;
            Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PNP_VER");
            if (oper == null) {
                return null;
            }
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)15).retCode;
            if (result == 0 && (aOperation = (Operation)operationList.get(0)).getOutput()[0].getFault()[0].getCode().equals(String.valueOf(0))) {
                return aOperation.getOutput(0);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

