/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.pnp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEPNPFileMgr {
    private static final String FILE_PNP_CONFIGURATION = "core" + File.separatorChar + "conf" + File.separatorChar + "xml" + File.separatorChar + "pnp" + File.separatorChar + "pnp_configuration.xml";

    public static boolean unZipFile(String fileName, String unZipFilePath) {
        File tempFile = new File(fileName);
        if (!tempFile.exists()) {
            return true;
        }
        boolean flag = true;
        FileInputStream fi = null;
        String zeName = "";
        String filename = "";
        String filepath = "";
        try {
            ZipEntry ze;
            fi = new FileInputStream(fileName);
            CheckedInputStream csumi = new CheckedInputStream(fi, new Adler32());
            ZipInputStream in2 = new ZipInputStream(new BufferedInputStream(csumi));
            while ((ze = in2.getNextEntry()) != null) {
                int x;
                boolean createFileRst;
                zeName = ze.getName();
                filename = unZipFilePath + File.separator + zeName;
                if (ze.isDirectory()) {
                    File dir = new File(filename);
                    boolean mkdirRst = dir.mkdir();
                    if (mkdirRst) continue;
                    in2.close();
                    fi.close();
                    TELogFactory.getNormalLogger().error("Mkdir fail! Path:" + dir.getPath());
                    return mkdirRst;
                }
                File target = new File(filename);
                if (!target.exists() && !(createFileRst = target.createNewFile())) {
                    in2.close();
                    fi.close();
                    TELogFactory.getNormalLogger().error("Create new file fail! File path is:" + target.getPath());
                    return createFileRst;
                }
                FileOutputStream file = new FileOutputStream(target);
                while ((x = in2.read()) != -1) {
                    file.write(x);
                }
                file.close();
                if (TEPNPFileMgr.hasUnZipFile(filename)) {
                    File jarfile = new File(filename);
                    filepath = jarfile.getParentFile().getPath();
                    if (TEPNPFileMgr.unZipFile(filename, filepath)) continue;
                    flag = false;
                    TEPNPFileMgr.deleteFile(filepath);
                    continue;
                }
                if (!filename.endsWith(".xml") || filename.indexOf("qxdescrib") != -1) continue;
                TEPNPFileMgr.addFileToPNPConfig(filename);
            }
            in2.close();
            fi.close();
        }
        catch (Exception e) {
            flag = false;
            TELogFactory.getNormalLogger().error("UnZip file fail!", (Throwable)e);
            TEPNPFileMgr.deleteFile(filename);
        }
        return flag;
    }

    private static boolean hasUnZipFile(String fileName) {
        boolean flag = false;
        File file = new File(fileName);
        String lastProfix = fileName.substring(fileName.lastIndexOf(".") + 1);
        String parent = file.getParentFile().getName();
        if (lastProfix.equals("jar") && !parent.equals("path") && !parent.equals("lib")) {
            flag = true;
        }
        return flag;
    }

    private static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            File[] filelist = file.listFiles();
            if (null != filelist && filelist.length > 0) {
                for (int i = filelist.length - 1; i >= 0; --i) {
                    TEPNPFileMgr.deleteFile(filelist[i].getPath());
                }
            }
            return file.delete();
        }
        return file.delete();
    }

    public static void addFileToPNPConfig(String fileName) {
        String pnpFilePath = TEResourceManager.getPath() + File.separatorChar + FILE_PNP_CONFIGURATION;
        File file = new File(pnpFilePath);
        String needAddFileName = fileName.substring(fileName.indexOf("nemgr"), fileName.length()).replace("\\\\", "\\");
        if (!file.exists()) {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pnpFilePath), "UTF-8"));
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.write("\r");
                writer.write("<root interpreter=\"sd_interpreter\">");
                writer.write("\r");
                writer.write("</root>");
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("Create nelist.xml fail", (Throwable)e);
            }
        }
        try {
            Document doc = TEParseXMLFile.parseFile(pnpFilePath);
            NodeList includeNodeList = doc.getElementsByTagName("include");
            if (TEPNPFileMgr.isExist(includeNodeList, needAddFileName)) {
                return;
            }
            Element newNode = doc.createElement("include");
            newNode.setAttribute("file", needAddFileName);
            doc.getDocumentElement().appendChild(newNode);
            doc.setXmlStandalone(false);
            doc.normalize();
            TEResourceManager.writeXmlFile(doc, pnpFilePath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Write pnp_configuration.xml file fail!", (Throwable)e);
        }
    }

    private static boolean isExist(NodeList nodeList, String fileName) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("file").equals(fileName)) continue;
            return true;
        }
        return false;
    }
}

