/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.pnp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEPNPBaseLineVerMgr {
    private static TEPNPBaseLineVerMgr instance = null;
    private Map<String, Map<String, String>> neBaseLineVerMap = new HashMap<String, Map<String, String>>();
    private static final String BASELINE_FILE_FILE = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "pnp" + File.separator + "pnpversion.xml");

    private TEPNPBaseLineVerMgr() {
        this.parseBaseLineVerXML();
    }

    public static synchronized TEPNPBaseLineVerMgr getInstance() {
        if (instance == null) {
            instance = new TEPNPBaseLineVerMgr();
        }
        return instance;
    }

    private void parseBaseLineVerXML() {
        File file = new File(BASELINE_FILE_FILE);
        if (!file.exists()) {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(BASELINE_FILE_FILE), "UTF-8"));
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.write("\r");
                writer.write("<root>");
                writer.write("\r");
                writer.write("</root>");
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Create pnpversion.xml fail", (Throwable)e);
            }
            return;
        }
        Document doc = null;
        NodeList nodeList = null;
        Element elementTmp = null;
        try {
            doc = TEParseXMLFile.parseFile(BASELINE_FILE_FILE);
            if (null == doc) {
                return;
            }
            nodeList = doc.getElementsByTagName("pnp");
            HashMap<String, String> baseLineVerInfo = null;
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                elementTmp = (Element)nodeList.item(i);
                if (!elementTmp.hasAttributes()) continue;
                baseLineVerInfo = new HashMap<String, String>();
                String neType = elementTmp.getAttribute("netype");
                String neVer = elementTmp.getAttribute("never");
                String baseLineVer = elementTmp.getAttribute("baselinever");
                baseLineVerInfo.put("neType", neType);
                baseLineVerInfo.put("never", neVer);
                baseLineVerInfo.put("baselinever", baseLineVer);
                this.neBaseLineVerMap.put(neType + "-" + neVer, baseLineVerInfo);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEPNPBaseLineVerMgr.parseBaseLineVerXML() fail!", (Throwable)e);
        }
    }

    public String getBaseLineVer(int neType, String neVer) {
        Map<String, String> baseLineVerInfo = this.neBaseLineVerMap.get("" + neType + "-" + neVer);
        if (baseLineVerInfo == null) {
            return null;
        }
        return baseLineVerInfo.get("baselinever");
    }

    public synchronized boolean updateBaseLineFile(int neType, String neVer, String baseLineVer) {
        try {
            Document doc = TEParseXMLFile.parseFile(BASELINE_FILE_FILE);
            if (null == doc) {
                return false;
            }
            Element pnpNode = this.getBaseLineNode(doc, neType, neVer);
            if (null == pnpNode) {
                Element pnpElem = doc.createElement("pnp");
                pnpElem.setAttribute("netype", String.valueOf(neType));
                pnpElem.setAttribute("never", neVer);
                pnpElem.setAttribute("baselinever", baseLineVer);
                doc.getDocumentElement().appendChild(pnpElem);
            } else {
                pnpNode.setAttribute("baselinever", baseLineVer);
                pnpNode.setAttribute("never", neVer);
            }
            doc.normalize();
            TEResourceManager.writeXmlFile(doc, BASELINE_FILE_FILE);
            HashMap<String, String> baseLineVerInfo = new HashMap<String, String>();
            baseLineVerInfo.put("neType", String.valueOf(neType));
            baseLineVerInfo.put("never", neVer);
            baseLineVerInfo.put("baselinever", baseLineVer);
            this.neBaseLineVerMap.put("" + neType + "-" + neVer, baseLineVerInfo);
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("write pnpversion.xml file fail!" + neType + "-" + neVer + "baseLineVer=" + baseLineVer, (Throwable)e);
            return false;
        }
    }

    private Element getBaseLineNode(Document doc, int neType, String neVer) {
        try {
            if (null == doc) {
                return null;
            }
            NodeList pnpNodeList = doc.getElementsByTagName("pnp");
            Element pnpNode = null;
            int isize = pnpNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                pnpNode = (Element)pnpNodeList.item(i);
                String tmpNeType = pnpNode.getAttribute("netype");
                if (!tmpNeType.equals(String.valueOf(neType))) continue;
                return pnpNode;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Not find ne(" + neType + "-" + neVer + ")in pnpversion.xml!");
        }
        return null;
    }
}

