/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.tl1alarm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import java.util.ArrayList;

public class TETL1PortBitErrorTh
implements Comparable {
    private int portID;
    private int pathID;
    private ArrayList bitErrorThList;
    boolean supportInverse = false;
    private String aidStruct = "";
    private String currMod2 = "";
    private boolean isTL1 = true;
    private static final int FEC_BIT_ERROR = 135;

    public TETL1PortBitErrorTh() {
        this.portID = 1;
        this.pathID = 1;
        this.bitErrorThList = new ArrayList();
    }

    public TETL1PortBitErrorTh(int portID, int pathID) {
        this.portID = portID;
        this.pathID = pathID;
    }

    public TETL1PortBitErrorTh(int portID, int pathID, ArrayList bitErrorThList, boolean isTL1) {
        this.portID = portID;
        this.pathID = pathID;
        this.bitErrorThList = bitErrorThList;
        this.isTL1 = isTL1;
    }

    public void addBitErrorThList(ArrayList bitList) {
        if (bitList.size() == 0) {
            return;
        }
        ArrayList<TEBitErrorTh> tempList = new ArrayList<TEBitErrorTh>();
        int src = bitList.size();
        for (int i = 0; i < src; ++i) {
            TEBitErrorTh srcTH = (TEBitErrorTh)bitList.get(i);
            boolean flag = false;
            int snk = this.bitErrorThList.size();
            for (int j = 0; j < snk; ++j) {
                TEBitErrorTh snkTH = (TEBitErrorTh)this.bitErrorThList.get(j);
                if (srcTH.getThtype() != snkTH.getThtype()) continue;
                snkTH.setBitErrorvalue(srcTH.getBitErrorvalue());
                snkTH.setMod2(srcTH.getMod2());
                flag = true;
                break;
            }
            if (flag) continue;
            tempList.add(srcTH);
        }
        if (tempList.size() > 0) {
            this.bitErrorThList.addAll(tempList);
        }
    }

    public String toString() {
        return "" + this.portID + this.pathID;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.pathID;
        hashCode = 37 * hashCode + this.portID;
        Boolean isTl1 = this.isTL1;
        hashCode = 37 * hashCode + isTl1.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TETL1PortBitErrorTh)) {
            return false;
        }
        TETL1PortBitErrorTh tEPortBitErrorTh = (TETL1PortBitErrorTh)obj;
        return tEPortBitErrorTh.portID == this.portID && tEPortBitErrorTh.pathID == this.pathID && this.isTL1 == tEPortBitErrorTh.isTL1;
    }

    public boolean getSupportInverse() {
        return this.supportInverse;
    }

    public void setSuportInverse(boolean supportInverse) {
        this.supportInverse = supportInverse;
    }

    public ArrayList getBitErrorThList() {
        return this.bitErrorThList;
    }

    public void setBitErrorThList(ArrayList bitErrorThList) {
        this.bitErrorThList = bitErrorThList;
    }

    public int getPathID() {
        return this.pathID;
    }

    public void setPathID(int pathID) {
        this.pathID = pathID;
    }

    public int getPortID() {
        return this.portID;
    }

    public void setPortID(int portID) {
        this.portID = portID;
    }

    public String getCurrMod2() {
        return this.currMod2;
    }

    public void setCurrMod2(String currMod2) {
        this.currMod2 = currMod2;
    }

    public String getAidStruct() {
        return this.aidStruct;
    }

    public void setAidStruct(String aidStruct) {
        this.aidStruct = aidStruct;
    }

    public int compareTo(Object obj) {
        TETL1PortBitErrorTh tEPortBitErrorTh;
        try {
            tEPortBitErrorTh = (TETL1PortBitErrorTh)obj;
        }
        catch (ClassCastException ex) {
            TELogFactory.getNormalLogger().error("TETL1PortBitErrorTh.compareTo() fail!", (Throwable)ex);
            return 1;
        }
        if (tEPortBitErrorTh == null) {
            return 1;
        }
        if (this.portID != tEPortBitErrorTh.portID) {
            return this.portID - tEPortBitErrorTh.portID;
        }
        if (this.pathID != tEPortBitErrorTh.pathID) {
            return this.pathID - tEPortBitErrorTh.pathID;
        }
        return 0;
    }

    public RowParams toRowParams(int neID, int slotID) {
        RowParams row = new RowParams();
        Param param = new Param();
        param.setName("portID");
        param.setValue(String.valueOf(this.portID));
        row.addParam(param);
        param = new Param();
        param.setName("pathID");
        param.setValue(String.valueOf(this.pathID));
        row.addParam(param);
        param = new Param();
        param.setName("aidStruct");
        param.setValue(String.valueOf(this.aidStruct));
        row.addParam(param);
        param = new Param();
        param.setName("monObject");
        String monObject = this.convertMonObjStr(neID, slotID);
        param.setValue(monObject);
        row.addParam(param);
        int size = this.bitErrorThList.size();
        for (int i = 0; i < size; ++i) {
            TEBitErrorTh bitError = (TEBitErrorTh)this.bitErrorThList.get(i);
            row.addParam(bitError.toParam());
            if (bitError.getThtype() != 135) continue;
            row.addParam(new Param("biterr_type_1001", ""));
        }
        return row;
    }

    public String makeBitErrorKey(int neID, int slotID, String mod2) {
        String tl1Path;
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neID, slotID, this.portID);
        String slotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neID, slotID);
        String neport = "" + TETL1CommonUtil.getAIDPortNo(neID, slotID, this.portID);
        String aidStr = aidFrefix + "-" + slotStr + "-" + neport;
        int cpType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        if (this.pathID != 0 && !(tl1Path = TETL1AIDTranslateRuleMgr.getInstance().getTL1Path(cpType, mod2, aidFrefix, String.valueOf(this.pathID))).isEmpty()) {
            aidStr = aidStr + "-" + tl1Path;
        }
        return aidStr;
    }

    public String convertMonObjStr(int neID, int slotID) {
        return TETL1CommonUtil.getGencfgObjFromAID(neID, this.aidStruct, this.currMod2);
    }

    public Object clone() {
        ArrayList list = null;
        if (this.bitErrorThList != null) {
            list = (ArrayList)this.bitErrorThList.clone();
        }
        TETL1PortBitErrorTh o = new TETL1PortBitErrorTh(this.portID, this.pathID, list, this.isTL1);
        return o;
    }
}

