/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.tl1alarm;

import com.huawei.nglct.nelist.model.AlmFBKeyType;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nelist.model.tl1alarm.TETL1AlarmMonObjID;
import com.huawei.nglct.nelist.model.tl1alarm.TETL1PortBitErrorTh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TETL1AlarmDataMgr {
    private HashMap portNOMap = new HashMap();
    private HashMap alarmBITThMap = new HashMap();
    private HashMap thtypeMap = new HashMap();
    private HashMap alarmFBMap = new HashMap();
    private HashMap alarmCptypeFBMap = new HashMap();
    private HashMap boardSupportAlmMap = new HashMap();
    private HashMap almAttrToFBMap = new HashMap();
    private static TETL1AlarmDataMgr instance = null;

    private TETL1AlarmDataMgr() {
    }

    public static synchronized TETL1AlarmDataMgr getInstance() {
        if (instance == null) {
            instance = new TETL1AlarmDataMgr();
        }
        return instance;
    }

    public void fillPortNOMap(int cpType, ArrayList portNOList) {
        if (!this.portNOMap.containsKey(new Integer(cpType))) {
            this.portNOMap.put(new Integer(cpType), portNOList);
        }
    }

    public void fillBITThList(int cpType, TETL1PortBitErrorTh portBitErrorTh) {
        if (!this.alarmBITThMap.containsKey(new Integer(cpType))) {
            ArrayList<TETL1PortBitErrorTh> alarmBITThList = new ArrayList<TETL1PortBitErrorTh>();
            alarmBITThList.add(portBitErrorTh);
            this.alarmBITThMap.put(new Integer(cpType), alarmBITThList);
        } else {
            ArrayList alarmBITThList = (ArrayList)this.alarmBITThMap.get(new Integer(cpType));
            if (!alarmBITThList.contains(portBitErrorTh)) {
                alarmBITThList.add(portBitErrorTh);
            }
        }
    }

    public void fillBITTypeList(int cpType, int thtype) {
        Integer type = new Integer(thtype);
        if (!this.thtypeMap.containsKey(new Integer(cpType))) {
            ArrayList<Integer> thtypeList = new ArrayList<Integer>();
            thtypeList.add(type);
            this.thtypeMap.put(new Integer(cpType), thtypeList);
        } else {
            ArrayList thtypeList = (ArrayList)this.thtypeMap.get(new Integer(cpType));
            if (!thtypeList.contains(type)) {
                thtypeList.add(type);
            }
        }
    }

    public ArrayList getBITTypeList(int cpType) {
        return (ArrayList)this.thtypeMap.get(new Integer(cpType));
    }

    public ArrayList getPortNOList(int cpType) {
        return (ArrayList)this.portNOMap.get(new Integer(cpType));
    }

    public ArrayList getBITThList(int cpType) {
        return (ArrayList)this.alarmBITThMap.get(new Integer(cpType));
    }

    public HashMap getAlarmBITThMap() {
        return this.alarmBITThMap;
    }

    public void setAlarmBITThMap(HashMap alarmBITThMap) {
        this.alarmBITThMap = alarmBITThMap;
    }

    public HashMap getAlarmFBMap() {
        return this.alarmFBMap;
    }

    public void setAlarmFBMap(int cpType, TEAlmFBObj fbObj) {
        if (!this.alarmFBMap.containsKey(new Integer(cpType))) {
            ArrayList<TEAlmFBObj> alarmFbList = new ArrayList<TEAlmFBObj>();
            alarmFbList.add(fbObj);
            this.alarmFBMap.put(new Integer(cpType), alarmFbList);
        } else {
            ArrayList alarmFbList = (ArrayList)this.alarmFBMap.get(new Integer(cpType));
            if (!alarmFbList.contains(fbObj)) {
                alarmFbList.add(fbObj);
            }
        }
    }

    public void setAlarmMap(HashMap almAttrToFBMap) {
        this.almAttrToFBMap.putAll(almAttrToFBMap);
    }

    public Integer getAlarmFbType(AlmFBKeyType fbKeyType) {
        return (Integer)this.almAttrToFBMap.get(fbKeyType);
    }

    public HashMap getAlarmMap() {
        return this.almAttrToFBMap;
    }

    public ArrayList getAlarmFbList(int cpType) {
        return (ArrayList)this.alarmFBMap.get(new Integer(cpType));
    }

    public ArrayList getAlmMonObjIDList(int cpType, int slotID, int neID) {
        ArrayList list = (ArrayList)this.alarmFBMap.get(new Integer(cpType));
        ArrayList<TETL1AlarmMonObjID> almMonObjIDList = new ArrayList<TETL1AlarmMonObjID>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            TEAlmFBObj fbObj = (TEAlmFBObj)list.get(i);
            TETL1AlarmMonObjID monObjID = new TETL1AlarmMonObjID();
            monObjID.m_ulNEID = neID;
            monObjID.m_usSlotID = slotID;
            monObjID.m_usFBType = fbObj.m_usFBType;
            monObjID.m_usPortID = fbObj.m_usPortID;
            monObjID.m_usPathID = fbObj.m_usPathID;
            almMonObjIDList.add(monObjID);
        }
        return almMonObjIDList;
    }

    public ArrayList getSupportAlarmList(int cpType, TEAlmFBObj fbObj) {
        HashMap fBAlarmMap = (HashMap)this.alarmCptypeFBMap.get(new Integer(cpType));
        return (ArrayList)fBAlarmMap.get(fbObj);
    }

    public ArrayList getSupportAlarmList(int cpType) {
        HashMap fBAlarmMap = null;
        Object obj = this.alarmCptypeFBMap.get(new Integer(cpType));
        fBAlarmMap = null == obj ? new HashMap() : (HashMap)obj;
        ArrayList supportList = new ArrayList();
        Iterator it = fBAlarmMap.values().iterator();
        while (it.hasNext()) {
            supportList.addAll((ArrayList)it.next());
        }
        return supportList;
    }

    public void setAlarmCptypeFBMap(int cpType, TEAlmFBObj fbObj, ArrayList supportAlmList) {
        if (!this.alarmCptypeFBMap.containsKey(new Integer(cpType))) {
            HashMap<TEAlmFBObj, ArrayList> fBAlarmMap = new HashMap<TEAlmFBObj, ArrayList>();
            fBAlarmMap.put(fbObj, supportAlmList);
            this.alarmCptypeFBMap.put(new Integer(cpType), fBAlarmMap);
        } else {
            HashMap fBAlarmMap = (HashMap)this.alarmCptypeFBMap.get(new Integer(cpType));
            if (!fBAlarmMap.containsKey(fbObj)) {
                fBAlarmMap.put(fbObj, supportAlmList);
            } else {
                ArrayList list = (ArrayList)fBAlarmMap.get(fbObj);
                list.addAll(supportAlmList);
            }
        }
    }

    public HashMap getBoardSupportMOD2() {
        HashMap mod2Map = new HashMap();
        Iterator it = this.alarmFBMap.entrySet().iterator();
        while (it.hasNext()) {
            ArrayList<String> mod2List = new ArrayList<String>();
            Map.Entry entry = it.next();
            Integer board = (Integer)entry.getKey();
            ArrayList fbList = (ArrayList)entry.getValue();
            int size = fbList.size();
            for (int i = 0; i < size; ++i) {
                TEAlmFBObj fbOjb = (TEAlmFBObj)fbList.get(i);
                String fbName = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(fbOjb.m_usFBType);
                if (mod2List.contains(fbName)) continue;
                mod2List.add(fbName);
            }
            mod2Map.put(board, mod2List);
        }
        return mod2Map;
    }
}

