/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.performance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.AlmObjKeyType;
import com.huawei.nglct.nelist.model.TEPerformanceDataMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.performance.TEPerformModel;
import com.huawei.nglct.nelist.model.performance.TEPfmBsFBInfo;
import com.huawei.nglct.nelist.model.performance.TEPfmBsFBObj;
import com.huawei.nglct.nelist.model.performance.TEPfmCPEventEx;
import com.huawei.nglct.nelist.model.performance.TEPfmCPEventFB;
import com.huawei.nglct.nelist.model.performance.TEPfmObjInfo;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEPerformanceInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        this.parseXML(node);
        return 0;
    }

    public void parseXML(Node node) {
        Element element = (Element)node;
        Element elementPfm = null;
        NodeList nodeList = element.getElementsByTagName("perform");
        if (nodeList.getLength() <= 0) {
            return;
        }
        TEPerformModel performModel = new TEPerformModel();
        performModel.neID = -1;
        elementPfm = (Element)nodeList.item(0);
        String cpTypeStr = elementPfm.getAttribute("cp_type");
        cpTypeStr = cpTypeStr == null || cpTypeStr.equals("") ? elementPfm.getAttribute("cptype") : cpTypeStr;
        performModel.cpType = SDXMLInterpreterMgr.getInstance().parseInt(cpTypeStr);
        this.parseSupportEventNode(elementPfm, performModel);
        this.parseSupportFBObjNode(element, performModel);
        this.parseSupportPerformNode(element, performModel);
        this.parseSupportPfmfuncNode(element, performModel);
        this.parsePfmmidmapNode(element, performModel);
        this.parseSupportPfmObjFunction(node, performModel);
        TEPerformanceDataMgr.getInstance().putPerformModel(performModel.cpType, performModel);
    }

    private void parseSupportEventNode(Element element, TEPerformModel performModel) {
        NodeList nodeList = element.getElementsByTagName("support_event");
        if (nodeList.getLength() > 0) {
            ArrayList NAEventIDs = performModel.eventListNA;
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Element elementTmp = (Element)nodeList.item(i);
                String evenStr = elementTmp.getAttribute("eventid");
                String isNaSupport = elementTmp.getAttribute("isnasupport");
                ArrayList tmpIDs = TENEListUtils.getIncrementPortArr(evenStr);
                performModel.eventList.addAll(tmpIDs);
                if (isNaSupport.equalsIgnoreCase("false")) continue;
                NAEventIDs.addAll(tmpIDs);
            }
            performModel.setEventIDList(performModel.eventList);
            performModel.setEventIDListNA(NAEventIDs);
        }
    }

    private void parseSupportFBObjNode(Element element, TEPerformModel performModel) {
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = element.getElementsByTagName("support_fbobj");
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element elementTmp = (Element)nodeList.item(i);
            String fbTypeStr = elementTmp.getAttribute("fbtype");
            String isnotsupport = elementTmp.getAttribute("isnasupport");
            TEPfmBsFBInfo pfmBsFBInfo = new TEPfmBsFBInfo();
            pfmBsFBInfo.fbType = instance.parseInt(fbTypeStr);
            if (pfmBsFBInfo.fbType == 91 || pfmBsFBInfo.fbType == 92) {
                TENEListUtils.getNumList(elementTmp.getAttribute("vc4"), pfmBsFBInfo.vc4);
                performModel.fb2vc4Map.put(pfmBsFBInfo.fbType, pfmBsFBInfo.vc4);
            }
            String indexBeginStr = elementTmp.getAttribute("indexbegin");
            pfmBsFBInfo.indexBegin = Integer.parseInt(indexBeginStr);
            String indexEndStr = elementTmp.getAttribute("indexend");
            pfmBsFBInfo.indexEnd = Integer.parseInt(indexEndStr);
            String portNoStr = elementTmp.getAttribute("portno");
            pfmBsFBInfo.portID = TENEListUtils.getNumList(portNoStr, new ArrayList());
            String pathNoStr = elementTmp.getAttribute("pathno");
            pfmBsFBInfo.pathID = TENEListUtils.getNumList(pathNoStr, new ArrayList());
            String domainStr = elementTmp.getAttribute("domain");
            pfmBsFBInfo.domain = instance.parseInt(domainStr);
            performModel.supFbObjMap.addAll(this.expandFbObjs(pfmBsFBInfo));
            if (isnotsupport.equalsIgnoreCase("false")) continue;
            performModel.supFbObjMapNA.addAll(this.expandFbObjs(pfmBsFBInfo));
        }
    }

    private void parseSupportPerformNode(Element element, TEPerformModel performModel) {
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = element.getElementsByTagName("support_perform");
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            String pathidstr;
            String portidstr;
            Element elementTmp = (Element)nodeList.item(i);
            String fbtypestr = elementTmp.getAttribute("fbtype");
            if (fbtypestr == null || fbtypestr.isEmpty()) continue;
            TEPfmCPEventFB cpEventFb = new TEPfmCPEventFB();
            cpEventFb.setFbType(instance.parseInt(TEPfmUtility.convertCTPFbType(fbtypestr)));
            String domainstr = elementTmp.getAttribute("domain");
            if (domainstr != null && !domainstr.isEmpty()) {
                cpEventFb.setDomain(instance.parseInt(domainstr));
            }
            if ((portidstr = elementTmp.getAttribute("portid")) != null && !portidstr.isEmpty()) {
                ArrayList<Integer> portids = new ArrayList<Integer>();
                instance.parseIntList(portidstr, portids);
                cpEventFb.setPortIDs(portids);
            }
            if ((pathidstr = elementTmp.getAttribute("pathid")) != null && !pathidstr.isEmpty()) {
                ArrayList<Integer> pathids = new ArrayList<Integer>();
                instance.parseIntList(pathidstr, pathids);
                cpEventFb.setPathIDs(pathids);
            }
            String eventidstr = elementTmp.getAttribute("eventid");
            if (pathidstr != null && !pathidstr.isEmpty()) {
                ArrayList<Integer> eventids = new ArrayList<Integer>();
                instance.parseIntList(eventidstr, eventids);
                cpEventFb.setEventIDs(eventids);
            }
            performModel.addCpEventFBs(cpEventFb);
        }
    }

    private void parseSupportPfmfuncNode(Element element, TEPerformModel performModel) {
        NodeList nodeList = element.getElementsByTagName("support_pfmfunc");
        if (nodeList.getLength() > 0) {
            Element elementTmp = (Element)nodeList.item(0);
            String support_obj_str = elementTmp.getAttribute("support_obj");
            performModel.pfmCpSupFunc.support_obj = Boolean.parseBoolean(support_obj_str);
            String support_thr_str = elementTmp.getAttribute("support_thr");
            performModel.pfmCpSupFunc.support_thr = Boolean.parseBoolean(support_thr_str);
            String support_fst_str = elementTmp.getAttribute("support_fst");
            performModel.pfmCpSupFunc.support_fst = Boolean.parseBoolean(support_fst_str);
            String support_uat_str = elementTmp.getAttribute("support_uat");
            performModel.pfmCpSupFunc.support_uat = Boolean.parseBoolean(support_uat_str);
        }
    }

    private void parsePfmmidmapNode(Element element, TEPerformModel performModel) {
        NodeList nodeList = element.getElementsByTagName("pfmidmap");
        TEPfmCPEventEx pfmCPEventEx = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element elementTmp = (Element)nodeList.item(i);
            String indexEndStr = elementTmp.getAttribute("nmeventid");
            indexEndStr = indexEndStr.replace('[', ' ');
            indexEndStr = indexEndStr.replace(']', ' ');
            String[] indexEndStrArray = indexEndStr.trim().split("-");
            String neEventIDStr = elementTmp.getAttribute("neeventid");
            neEventIDStr = neEventIDStr.replace('[', ' ');
            String[] neEventIDStrArray = (neEventIDStr = neEventIDStr.replace(']', ' ')).trim().split("-");
            if (indexEndStrArray.length == neEventIDStrArray.length) {
                int startId;
                int endId = startId = Integer.parseInt(neEventIDStrArray[0]);
                if (neEventIDStrArray.length == 2) {
                    endId = Integer.parseInt(neEventIDStrArray[1]);
                }
                int nmStartId = Integer.parseInt(indexEndStrArray[0]);
                while (startId <= endId) {
                    if (performModel.pfmidMap.containsKey(startId)) {
                        pfmCPEventEx = (TEPfmCPEventEx)performModel.pfmidMap.get(startId);
                    } else {
                        pfmCPEventEx = new TEPfmCPEventEx();
                        pfmCPEventEx.nmEventID = nmStartId;
                        pfmCPEventEx.neEventID = startId;
                        performModel.pfmidMap.put(startId, pfmCPEventEx);
                    }
                    String portIDStr = elementTmp.getAttribute("portid");
                    TENEListUtils.getPortArr(portIDStr, pfmCPEventEx.portIDList);
                    String pathIDStr = elementTmp.getAttribute("pathid");
                    TENEListUtils.getPortArr(pathIDStr, pfmCPEventEx.pathIDList);
                    if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(performModel.cpType)) {
                        this.convertPathID(performModel.cpType, pfmCPEventEx.pathIDList);
                    }
                    ++startId;
                    ++nmStartId;
                }
                continue;
            }
            TELogFactory.getNormalLogger().error("parseXml fail! The range of nmeventid is not match with the range of neeventid!");
        }
    }

    private void convertPathID(int cpType, ArrayList<Integer> pathIDList) {
        int size = pathIDList.size();
        for (int i = 0; i < size; ++i) {
            int modelpath = pathIDList.get(i);
            if (modelpath <= 1200) continue;
            int nePath = TEOTNModelDataMgr.getInstance().getNePath(modelpath, cpType);
            nePath = nePath == -1 ? modelpath : nePath;
            pathIDList.set(i, nePath);
        }
    }

    List<TEPfmBsFBObj> expandFbObjs(TEPfmBsFBInfo pfmBsFBInfo) {
        int portID;
        int i;
        int portlen;
        ArrayList<TEPfmBsFBObj> fbObjList = new ArrayList<TEPfmBsFBObj>();
        TEPfmBsFBObj fbObj = new TEPfmBsFBObj();
        fbObj.m_usFBType = pfmBsFBInfo.fbType;
        ArrayList<Integer> portList = pfmBsFBInfo.portID;
        ArrayList<Integer> pathList = pfmBsFBInfo.pathID;
        if (pfmBsFBInfo.usePortEnable() && pfmBsFBInfo.usePathEnable()) {
            portlen = portList.size();
            for (i = 0; i < portlen; ++i) {
                portID = portList.get(i);
                int pathlen = pathList.size();
                for (int j = 0; j < pathlen; ++j) {
                    int pathID = pathList.get(j);
                    fbObj.m_usPortID = portID;
                    fbObj.m_usPathID = pathID;
                    fbObjList.add((TEPfmBsFBObj)fbObj.clone());
                }
            }
        }
        if (pfmBsFBInfo.usePortEnable() && !pfmBsFBInfo.usePathEnable()) {
            portlen = portList.size();
            for (i = 0; i < portlen; ++i) {
                fbObj.m_usPortID = portID = portList.get(i).intValue();
                int length = pfmBsFBInfo.vc4.size();
                for (int usIndex = pfmBsFBInfo.indexBegin; usIndex <= pfmBsFBInfo.indexEnd; ++usIndex) {
                    fbObj.m_usPathID = pfmBsFBInfo.fbType == 91 && length > 0 ? this.convert(usIndex, pfmBsFBInfo.vc4, 91) : (pfmBsFBInfo.fbType == 92 && length > 0 ? this.convert(usIndex, pfmBsFBInfo.vc4, 92) : usIndex);
                    fbObjList.add((TEPfmBsFBObj)fbObj.clone());
                }
            }
        }
        if (!pfmBsFBInfo.usePortEnable() && pfmBsFBInfo.usePathEnable()) {
            for (int usIndex = pfmBsFBInfo.indexBegin; usIndex <= pfmBsFBInfo.indexEnd; ++usIndex) {
                fbObj.m_usPortID = usIndex;
                int pathlen = pathList.size();
                for (int j = 0; j < pathlen; ++j) {
                    int pathID;
                    fbObj.m_usPathID = pathID = pathList.get(j).intValue();
                    fbObjList.add((TEPfmBsFBObj)fbObj.clone());
                }
            }
        }
        if (!pfmBsFBInfo.usePortEnable() && !pfmBsFBInfo.usePathEnable()) {
            fbObj.m_usPortID = 0;
            fbObj.m_usPathID = 0;
            fbObjList.add((TEPfmBsFBObj)fbObj.clone());
        }
        return fbObjList;
    }

    private int convert(int usIndex, ArrayList vc4, int fb) {
        int fb1 = 0;
        int fb2 = 0;
        int index = 0;
        if (fb == 91) {
            index = (usIndex - 1) / 3 + 1;
            fb1 = (Integer)vc4.get(index - 1);
            fb2 = (usIndex - 1) % 3 + 1;
        } else {
            index = (usIndex - 1) / 63 + 1;
            fb1 = (Integer)vc4.get(index - 1);
            fb2 = (usIndex - 1) % 63 + 1;
        }
        return (fb1 << 16) + (0xFFFF & fb2);
    }

    private void parseSupportPfmObjFunction(Node node, TEPerformModel performModel) {
        HashMap<AlmObjKeyType, List<TEPfmObjInfo>> pfmAttrToObjMap = new HashMap<AlmObjKeyType, List<TEPfmObjInfo>>();
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("lpperform");
        if (null == nodeList) {
            return;
        }
        Element elementTmp = (Element)nodeList.item(0);
        if (null == elementTmp) {
            return;
        }
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        String cpTypeStr = elementTmp.getAttribute("cp_type");
        cpTypeStr = cpTypeStr == null || cpTypeStr.equals("") ? elementTmp.getAttribute("cptype") : cpTypeStr;
        int cpType = instance.parseInt(cpTypeStr);
        nodeList = elementTmp.getElementsByTagName("support_event");
        if (null == nodeList) {
            return;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            elementTmp = (Element)nodeList.item(i);
            String objTypeStr = elementTmp.getAttribute("objtype");
            TEPfmObjInfo tEPfmObjInfo = new TEPfmObjInfo();
            tEPfmObjInfo.objType = mgr.parseInt(objTypeStr);
            String fbTypeStr = elementTmp.getAttribute("fbtype");
            tEPfmObjInfo.fbType = instance.parseInt(fbTypeStr);
            String evenStr = elementTmp.getAttribute("eventid");
            ArrayList supportEventList = new ArrayList();
            TENEListUtils.getPortArr(evenStr, supportEventList);
            String portIDStr = elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            tEPfmObjInfo.portIDList = TENEListUtils.getPortArr(portIDStr, portNoList);
            String pathIDStr = elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            tEPfmObjInfo.pathIDList = TENEListUtils.getPortArr(pathIDStr, pathNoList);
            this.expandObjectObjs(cpType, tEPfmObjInfo, supportEventList, pfmAttrToObjMap);
        }
        TEPerformanceDataMgr.getInstance().setPerformObjMap(pfmAttrToObjMap);
        performModel.pfmAttrToObjMap.putAll(pfmAttrToObjMap);
    }

    private void expandObjectObjs(int cpType, TEPfmObjInfo tEPfmObjInfo, ArrayList supportEventList, HashMap<AlmObjKeyType, List<TEPfmObjInfo>> pfmAttrToObjMap) {
        ArrayList portList = tEPfmObjInfo.portIDList;
        ArrayList pathIDList = tEPfmObjInfo.pathIDList;
        TEPfmObjInfo pfmObj = null;
        int portID = 0;
        int pathID = 0;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                pfmObj = new TEPfmObjInfo();
                pfmObj.objType = tEPfmObjInfo.objType;
                pfmObj.eventidList = supportEventList;
                pfmObj.fbType = tEPfmObjInfo.fbType;
                portID = (Integer)portList.get(i);
                AlmObjKeyType key = new AlmObjKeyType(cpType, portID, pathID = ((Integer)pathIDList.get(j)).intValue());
                if (!pfmAttrToObjMap.containsKey(key)) {
                    ArrayList<TEPfmObjInfo> objs = new ArrayList<TEPfmObjInfo>();
                    objs.add(pfmObj);
                    pfmAttrToObjMap.put(key, objs);
                    continue;
                }
                List<TEPfmObjInfo> list = pfmAttrToObjMap.get(key);
                TEPfmObjInfo ObjTemp = null;
                boolean blExist = false;
                int m = list.size();
                for (int k = 0; k < m; ++k) {
                    ObjTemp = list.get(k);
                    if (ObjTemp.objType != pfmObj.objType) continue;
                    ObjTemp.eventidList.addAll(supportEventList);
                    blExist = true;
                    break;
                }
                if (blExist) continue;
                list.add(pfmObj);
            }
        }
    }
}

