/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.gencfg;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGencfgConvertQxFile;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGenCfgInterpreter
extends XMLInterpreterImpl {
    private SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();

    @Override
    public int interpretXMLTag(Node node) {
        this.parseXML(node);
        return 0;
    }

    public void parseXML(Node node) {
        Element element = (Element)node;
        NodeList defineList = element.getElementsByTagName("define");
        if (null == defineList || defineList.getLength() == 0) {
            return;
        }
        Element defineEle = (Element)defineList.item(0);
        String cpTypeStr = defineEle.getAttribute("cpType");
        int cpType = this.mgr.parseInt(cpTypeStr);
        if (cpType > 0) {
            NodeList nodeList = defineEle.getElementsByTagName("support_attr");
            this.handleSupportAttrNode(nodeList, cpType);
            TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode(cpType);
            if (null != genCfgModel) {
                nodeList = defineEle.getElementsByTagName("attr");
                this.handleAttrAccessNode(nodeList, genCfgModel);
                nodeList = defineEle.getElementsByTagName("port_attr");
                this.handlePortAttrNode(nodeList, genCfgModel);
                nodeList = defineEle.getElementsByTagName("genattr_qx");
                this.handleGenattrQxNode(nodeList, genCfgModel);
            }
        }
    }

    private void handleGenattrQxNode(NodeList nodelist, TEGenCfgModel genCfgModel) {
        boolean isCes = false;
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            Element qxnode = (Element)nodelist.item(i);
            isCes = "true".equals(qxnode.getAttribute("isCes"));
            genCfgModel.addFunAttrQx(qxnode.getAttribute("genCfgAttrDesPath"), new TEGencfgConvertQxFile(qxnode.getAttribute("genCfgAttrDesConvertPath"), isCes));
        }
    }

    private void handleSupportAttrNode(NodeList nodelist, int cpType) {
        NodeList unSupportItemList = null;
        HashMap unSupportMap = null;
        if (null != nodelist) {
            TIntArrayList iList = new TIntArrayList();
            TEGenCfgModel genCfgModel = new TEGenCfgModel();
            TEGenCfgAttribute attrObj = null;
            Element element = null;
            ArrayList values = null;
            String tattrid = null;
            for (int i = nodelist.getLength() - 1; i >= 0; --i) {
                element = (Element)nodelist.item(i);
                unSupportItemList = element.getElementsByTagName("unsupport_item_version");
                unSupportMap = this.handleUnSupportNode(unSupportItemList);
                values = TEParseXMLFile.splitFromChar(element.getAttribute("value"), ',');
                int m = values.size();
                for (int j = 0; j < m; ++j) {
                    attrObj = new TEGenCfgAttribute();
                    tattrid = values.get(j).toString();
                    tattrid = tattrid.intern();
                    attrObj.setAttrId(tattrid);
                    if (element.hasAttribute("domain_list")) {
                        this.mgr.parseIntList(element.getAttribute("domain_list"), iList);
                        attrObj.setDomainList(this.fillArrayList(iList));
                    }
                    if (element.hasAttribute("value_range")) {
                        this.setValueRange(attrObj, element.getAttribute("value_range"));
                    }
                    if (element.hasAttribute("unit")) {
                        attrObj.setUnit(Integer.parseInt(element.getAttribute("unit")));
                    }
                    attrObj.setUnSupportMap(unSupportMap);
                    genCfgModel.addSupportAttr(attrObj);
                }
            }
            TEGenCfgDataMgr.fillGencfgData(cpType, genCfgModel);
        }
    }

    private void handleAttrAccessNode(NodeList nodelist, TEGenCfgModel genCfgModel) {
        NodeList childList = null;
        Element attrElement = null;
        Element subElement = null;
        Element itemElement = null;
        String attrId = null;
        String accType = null;
        TEGenCfgAttribute attrObj = null;
        for (int i = nodelist.getLength() - 1; i >= 0; --i) {
            attrElement = (Element)nodelist.item(i);
            attrId = attrElement.getAttribute("id");
            attrObj = genCfgModel.getAttrFromId(attrId);
            if (null == attrObj) continue;
            childList = attrElement.getElementsByTagName("attr_access");
            if (null != childList && childList.getLength() > 0 && null != (childList = (subElement = (Element)childList.item(0)).getElementsByTagName("item")) && childList.getLength() > 0) {
                itemElement = (Element)childList.item(0);
                accType = itemElement.getAttribute("value");
                attrObj.setAccType(accType);
            }
            if (null == (childList = attrElement.getElementsByTagName("default_value")) || childList.getLength() <= 0 || null == (childList = (subElement = (Element)childList.item(0)).getElementsByTagName("item")) || childList.getLength() <= 0) continue;
            itemElement = (Element)childList.item(0);
            accType = itemElement.getAttribute("value");
            attrObj.setDefaultValue(accType);
        }
    }

    private void handlePortAttrNode(NodeList nodelist, TEGenCfgModel genCfgModel) {
        Element subPackgeElement = null;
        NodeList itemList = null;
        Element item = null;
        ArrayList<TEGenCfgPortAttribute> portObjList = new ArrayList<TEGenCfgPortAttribute>();
        ArrayList attrList = null;
        String attrId = null;
        String portStrlist = null;
        String pathStrlist = null;
        int fbType = -1;
        String tl1PortMode = "";
        String tl1boardMode = "";
        ArrayList<String> tl1boardModeList = null;
        ArrayList portList = null;
        ArrayList pathList = null;
        TEGenCfgPortAttribute portObj = null;
        TEGenCfgPortAttribute tmpPortObj = null;
        TIntArrayList iList = new TIntArrayList();
        NodeList unSupportItemList = null;
        HashMap unSupportMap = null;
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            subPackgeElement = (Element)nodelist.item(i);
            itemList = subPackgeElement.getElementsByTagName("item");
            int itemlen = itemList.getLength();
            for (int j = 0; j < itemlen; ++j) {
                item = (Element)itemList.item(j);
                attrList = TEParseXMLFile.splitFromChar(item.getAttribute("attr_id_list"), ',');
                portStrlist = item.getAttribute("portid_list");
                fbType = SDXMLInterpreterMgr.getInstance().parseInt(item.getAttribute("fbtype"));
                tl1PortMode = item.getAttribute("tl1_port_mode");
                tl1boardMode = item.getAttribute("tl1_board_mode");
                tl1boardModeList = new ArrayList<String>();
                if (tl1boardMode != null && !tl1boardMode.isEmpty()) {
                    String[] boardModeStrList;
                    for (String board : boardModeStrList = tl1boardMode.split(",")) {
                        tl1boardModeList.add(board);
                    }
                }
                unSupportItemList = item.getElementsByTagName("unsupport_item_version");
                unSupportMap = this.handleUnSupportNode(unSupportItemList);
                pathStrlist = item.getAttribute("fbid1_list");
                this.mgr.parseIntList(portStrlist, iList);
                portList = this.fillArrayList(iList);
                this.mgr.parseIntList(pathStrlist, iList);
                pathList = this.fillArrayList(iList);
                if (pathList.size() > genCfgModel.getMaxFbid1_listSize()) {
                    genCfgModel.setMaxFbid1_listSize(pathList.size());
                }
                portObjList.clear();
                int size = portList.size();
                for (int k = 0; k < size; ++k) {
                    portObj = new TEGenCfgPortAttribute();
                    portObj.setPort((Integer)portList.get(k));
                    portObj.setFbtype(fbType);
                    portObj.setTl1PortMode(tl1PortMode);
                    portObj.setTl1BoardMode(tl1boardModeList);
                    if (null != pathList && !pathList.isEmpty()) {
                        for (int m = pathList.size() - 1; m >= 0; --m) {
                            tmpPortObj = (TEGenCfgPortAttribute)portObj.clone();
                            tmpPortObj.setPath(Integer.parseInt(String.valueOf(pathList.get(m))));
                            tmpPortObj.setUnSupportMap(unSupportMap);
                            portObjList.add(tmpPortObj);
                        }
                        continue;
                    }
                    portObj.setUnSupportMap(unSupportMap);
                    portObjList.add(portObj);
                }
                size = attrList.size();
                for (int index = 0; index < size; ++index) {
                    attrId = (String)attrList.get(index);
                    TEGenCfgAttribute attrObj = genCfgModel.getAttrFromId(attrId = attrId.intern());
                    if (null == attrObj) continue;
                    this.setAttrId(portObjList, attrId);
                    attrObj.addPortList(portObjList);
                }
            }
        }
    }

    private void setAttrId(ArrayList portObjList, String attrId) {
        for (int i = portObjList.size() - 1; i >= 0; --i) {
            ((TEGenCfgPortAttribute)portObjList.get(i)).setAttrId(attrId);
        }
    }

    private HashMap handleUnSupportNode(NodeList nodeList) {
        HashMap<Integer, String[]> unSupportMap = new HashMap<Integer, String[]>();
        Element unSupportEle = null;
        String neTypeStr = null;
        String neVerStr = null;
        if (null == nodeList) {
            return unSupportMap;
        }
        int len = nodeList.getLength();
        for (int index = 0; index < len; ++index) {
            unSupportEle = (Element)nodeList.item(index);
            neTypeStr = unSupportEle.getAttribute("neType");
            neVerStr = unSupportEle.getAttribute("neVersion");
            neTypeStr = neTypeStr.substring(1, neTypeStr.length() - 1);
            neVerStr = neVerStr.substring(1, neVerStr.length() - 1);
            unSupportMap.put(Integer.valueOf(neTypeStr), neVerStr.split(","));
        }
        return unSupportMap;
    }

    private void setValueRange(TEGenCfgAttribute attrObj, String valueRange) {
        String[] range = valueRange.split("~");
        if (range.length < 2) {
            return;
        }
        String minValue = range[0].substring(1, range[0].length() - 1);
        String maxValue = range[1].substring(1, range[1].length() - 1);
        attrObj.setMinvalue(minValue);
        attrObj.setMaxvalue(maxValue);
    }

    private ArrayList fillArrayList(TIntArrayList iList) {
        ArrayList<Integer> aList = new ArrayList<Integer>();
        int m = iList.size();
        for (int i = 0; i < m; ++i) {
            aList.add(iList.get(i));
        }
        return aList;
    }
}

