/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret.frame;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.eventinterpret.frame.CommentPart;
import com.huawei.nglct.nelist.model.eventinterpret.frame.TEEventDesc;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class TECommonAbNormalNoticeHandler
implements NoticeHandler {
    private TEEventDesc eventdesc;

    public TECommonAbNormalNoticeHandler(TEEventDesc desc) {
        this.eventdesc = desc;
    }

    public void handleNotice(int cmdKey, int neID, Operation operation) {
        TEResourceUtil res = TEResourceUtil.getInstance(this.eventdesc.getResFilePath() + "_" + TENEListUtils.getLanguage() + ".ini");
        TEAbNormalEvent abnormalEvent = new TEAbNormalEvent();
        abnormalEvent.eventID = this.eventdesc.getEventId() != null ? Integer.parseInt(this.eventdesc.getEventId()) : operation.getCmdid();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        abnormalEvent.objStr = ne.getNEName();
        abnormalEvent.nodeType = ne.getNEType();
        abnormalEvent.eventName = res.getString(this.eventdesc.getEventName());
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        abnormalEvent.timeStr = startTime;
        abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        abnormalEvent.severityLevel = this.getLevel(this.eventdesc.getLevel());
        abnormalEvent.severityStr = TENEListUtils.getString(String.valueOf(abnormalEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        abnormalEvent.eventType = this.getType(this.eventdesc.getType());
        abnormalEvent.typeStr = TENEListUtils.getString("alarmType" + abnormalEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        abnormalEvent.comment = this.getComment(operation, res);
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, abnormalEvent);
    }

    private int getType(String type) {
        if (type.equalsIgnoreCase("COMMUNICATE_TYPE")) {
            return 1;
        }
        if (type.equalsIgnoreCase("QOS_TYPE")) {
            return 2;
        }
        if (type.equalsIgnoreCase("EQUIPMENT_TYPE")) {
            return 3;
        }
        if (type.equalsIgnoreCase("PROCESSING_FAILURE_TYPE")) {
            return 4;
        }
        if (type.equalsIgnoreCase("SECURITY_TYPE")) {
            return 5;
        }
        if (type.equalsIgnoreCase("ENVIRONMENT_TYPE")) {
            return 6;
        }
        return 3;
    }

    private int getLevel(String level) {
        if (level.equalsIgnoreCase("waring")) {
            return 4;
        }
        if (level.equalsIgnoreCase("junior")) {
            return 3;
        }
        if (level.equalsIgnoreCase("major")) {
            return 2;
        }
        if (level.equalsIgnoreCase("critical")) {
            return 1;
        }
        return 4;
    }

    private String getComment(Operation operation, TEResourceUtil res) {
        StringBuffer descriptionStr = new StringBuffer(50);
        List<CommentPart> commentPartList = this.eventdesc.getComments();
        for (CommentPart part : commentPartList) {
            descriptionStr.append(res.getString(part.getName()));
            String value = this.getOutputValue(operation, part.getQxpart());
            if (value == null) continue;
            String resvalue = res.getString(part.getName() + "_" + value);
            if (resvalue != null && !resvalue.equals(part.getName() + "_" + value)) {
                descriptionStr.append(":").append(resvalue).append(";");
                continue;
            }
            descriptionStr.append(":").append(value).append(";");
        }
        return descriptionStr.toString();
    }

    private String getOutputValue(Operation operation, String partName) {
        Output[] outputs = operation.getOutput();
        for (int i = 0; i < outputs.length; ++i) {
            if (partName.equalsIgnoreCase("fault")) {
                if (outputs[i].getFault().length <= 0 || outputs[i].getFault()[0] == null) continue;
                return outputs[i].getFault()[0].getValue();
            }
            Part part = outputs[i].getPart(partName);
            if (part == null) continue;
            return part.getValue();
        }
        return null;
    }
}

