/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret.frame;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.eventinterpret.frame.TECommonAbNormalNoticeHandler;
import com.huawei.nglct.nelist.model.eventinterpret.frame.TEEventDesc;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TECommonAbNormalEventMgr {
    private static TECommonAbNormalEventMgr instance = null;

    private TECommonAbNormalEventMgr() {
    }

    public static synchronized TECommonAbNormalEventMgr getInstance() {
        if (instance == null) {
            instance = new TECommonAbNormalEventMgr();
        }
        return instance;
    }

    public void qxEventRegister(String bundlename, List<TEEventDesc> eventDesList) {
        for (TEEventDesc eventDes : eventDesList) {
            Operation oper = TECreateObjectFactory.getOperation(bundlename, eventDes.getQxFilePath(), eventDes.getEventName());
            TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)new TECommonAbNormalNoticeHandler(eventDes));
        }
    }

    public void qxEventUnregister(String bundlename, List<TEEventDesc> eventDesList) {
        for (TEEventDesc eventDes : eventDesList) {
            Operation oper = TECreateObjectFactory.getOperation(bundlename, eventDes.getQxFilePath(), eventDes.getEventId());
            TENECommMgr.getInstance().unregisterListener(oper, (NoticeHandler)new TECommonAbNormalNoticeHandler(eventDes));
        }
    }

    public void registerEvent(String bundleName, String fileName) {
        try {
            Document doc = TEParseXMLFile.parseFile(bundleName, fileName);
            if (null == doc) {
                TELogFactory.getNormalLogger().info("Parse " + bundleName + "[" + fileName + "]  fail!");
                return;
            }
            Element root = doc.getDocumentElement();
            NodeList children = root.getChildNodes();
            ArrayList<TEEventDesc> eventDesList = new ArrayList<TEEventDesc>();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node aNode = children.item(i);
                if (!(aNode instanceof Element)) continue;
                TEEventDesc eventDes = new TEEventDesc((Element)aNode);
                eventDesList.add(eventDes);
            }
            this.qxEventRegister(bundleName, eventDesList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
    }
}

