/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.datetime.GetTimeDiff;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TESecurityEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation operation) {
        switch (cmdKey) {
            case 28433: {
                this.interpretLoginEvent(cmdKey, neID, operation);
                break;
            }
            case 28434: {
                this.interpretLogoutEvent(cmdKey, neID, operation);
                break;
            }
            case 28446: {
                this.interpretLogoutEventNew(cmdKey, neID, operation);
                break;
            }
            case 28435: {
                this.interpretUMEditEvent(cmdKey, neID, operation);
                break;
            }
            case 28436: {
                this.interpretUMAddEvent(cmdKey, neID, operation);
                break;
            }
            case 28437: {
                this.interpretUMDelEvent(cmdKey, neID, operation);
                break;
            }
            case 28438: {
                this.interpretUMLockEvent(cmdKey, neID, operation);
                break;
            }
            case 28439: {
                this.interpretUMLockModeEvent(cmdKey, neID, operation);
                break;
            }
            case 28440: {
                this.interpretLoginIllegalEvent(cmdKey, neID, operation);
                break;
            }
            case 28441: {
                this.interpretUMCFGChangeEvent(cmdKey, neID, operation);
                break;
            }
            case 28445: {
                this.interpretLoginWarningEvent(cmdKey, neID, operation);
                break;
            }
            case 28447: {
                this.interpretLoginPassWordEvent(cmdKey, neID, operation);
                break;
            }
            case 20561: 
            case 20562: 
            case 20563: 
            case 20567: 
            case 20568: 
            case 20571: 
            case 20572: 
            case 20573: 
            case 20574: 
            case 20575: 
            case 20576: 
            case 20577: 
            case 28442: 
            case 28444: {
                this.neEventHandler(cmdKey, neID, operation);
                break;
            }
            case 18534: {
                this.interpretNEResumeResultEvent(cmdKey, neID, operation);
                break;
            }
            case 20578: {
                this.interpretPasswordNeedModifyEvent(cmdKey, neID, operation);
                break;
            }
        }
    }

    private void interpretLogoutEventNew(int cmdKey, int neID, Operation operation) {
        String srcUserName = "";
        int logoutType = -1;
        int eventID = 18;
        StringBuffer descriptionStr = new StringBuffer();
        String logoutReasonStr = "UM_LOGOUT_REASON";
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("logoutUserName")) {
                    srcUserName = IOStreamConvertor.replaceSpecialStr(value).trim();
                }
                if (!name.equalsIgnoreCase("logoutType") || null == value) continue;
                logoutType = Integer.parseInt(value);
                logoutReasonStr = logoutReasonStr + logoutType;
            }
        }
        String loginStr1 = TENEListUtils.getString("UM_NEUSER");
        descriptionStr.append(loginStr1);
        descriptionStr.append(srcUserName);
        loginStr1 = TENEListUtils.getString(logoutReasonStr);
        descriptionStr.append(loginStr1);
        TEAbNormalEvent logoutEvent1 = new TEAbNormalEvent();
        logoutEvent1.eventID = eventID;
        logoutEvent1.eventName = TENEListUtils.getString(String.valueOf(eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        logoutEvent1.objStr = ne.getNEName();
        int netype = ne.getNEType();
        logoutEvent1.nodeType = netype == -1 ? this.getNeType(neID) : netype;
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        logoutEvent1.timeStr = startTime;
        logoutEvent1.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        logoutEvent1.severityLevel = 4;
        logoutEvent1.severityStr = TENEListUtils.getString(String.valueOf(logoutEvent1.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        logoutEvent1.eventType = 1;
        logoutEvent1.typeStr = TENEListUtils.getString("alarmType" + logoutEvent1.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        logoutEvent1.eventType = 1;
        logoutEvent1.typeStr = TENEListUtils.getString("alarmType" + logoutEvent1.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        logoutEvent1.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, logoutEvent1);
    }

    private void interpretLoginEvent(int cmdkey, int neID, Operation operation) {
        int eventID = 17;
        String userName = "";
        StringBuffer descriptionStr = new StringBuffer();
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (!name.equalsIgnoreCase("userName")) continue;
                userName = IOStreamConvertor.replaceSpecialStr(value).trim();
            }
            String loginStr = TENEListUtils.getString("UM_LOGIN_DESCRIPTION");
            loginStr = loginStr.replaceFirst("%s", userName);
            descriptionStr.append(loginStr);
        }
        TEAbNormalEvent loginEvent = new TEAbNormalEvent();
        loginEvent.eventID = eventID;
        loginEvent.eventName = TENEListUtils.getString(String.valueOf(eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        loginEvent.objStr = ne.getNEName();
        loginEvent.nodeType = ne.getNEType();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        loginEvent.timeStr = startTime;
        loginEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        loginEvent.severityLevel = 4;
        loginEvent.severityStr = TENEListUtils.getString(String.valueOf(loginEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        loginEvent.eventType = 1;
        loginEvent.typeStr = TENEListUtils.getString("alarmType" + loginEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        loginEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, loginEvent);
    }

    private void interpretLogoutEvent(int cmdkey, int neID, Operation operation) {
        int eventID = 18;
        long userID = 0L;
        int logoutType = -1;
        StringBuffer descriptionStr = new StringBuffer();
        String logoutReasonStr = "UM_LOGOUT_REASON";
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("userID")) {
                    userID = Long.parseLong(value);
                }
                if (!name.equalsIgnoreCase("logoutType") || null == value) continue;
                logoutType = Integer.parseInt(value);
                logoutReasonStr = logoutReasonStr + logoutType;
            }
        }
        String loginStr = TENEListUtils.getString("UM_NEUSER");
        descriptionStr.append(loginStr);
        descriptionStr.append(" id:");
        descriptionStr.append(userID);
        loginStr = TENEListUtils.getString(logoutReasonStr);
        descriptionStr.append(loginStr);
        TEAbNormalEvent logoutEvent = new TEAbNormalEvent();
        logoutEvent.eventID = eventID;
        logoutEvent.eventName = TENEListUtils.getString(String.valueOf(eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        logoutEvent.objStr = ne.getNEName();
        int netype = ne.getNEType();
        logoutEvent.nodeType = netype == -1 ? this.getNeType(neID) : netype;
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        logoutEvent.timeStr = startTime;
        logoutEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        logoutEvent.severityLevel = 4;
        logoutEvent.severityStr = TENEListUtils.getString(String.valueOf(logoutEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        logoutEvent.eventType = 1;
        logoutEvent.typeStr = TENEListUtils.getString("alarmType" + logoutEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        logoutEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, logoutEvent);
    }

    private void interpretUMEditEvent(int cmdkey, int neID, Operation operation) {
        int modifyUserID = 0;
        int modifyedUserID = 0;
        int modifyType = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("modifyUserID")) {
                    modifyUserID = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("modifyedUserID")) {
                    modifyedUserID = Integer.parseInt(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("modifyType")) continue;
                modifyType = Integer.parseInt(value);
                --modifyType;
            }
        }
        String loginStr = "";
        if (modifyUserID == modifyedUserID) {
            loginStr = "UM_EDIT_DESCRIPTION";
            loginStr = loginStr + modifyType;
        } else {
            loginStr = "UM_EDIT_DESCRIPTIONX";
            loginStr = loginStr + modifyType;
        }
        loginStr = TENEListUtils.getString(loginStr);
        if (modifyUserID == modifyedUserID) {
            loginStr = loginStr.replaceFirst("%s", String.valueOf(modifyUserID));
        } else {
            loginStr = loginStr.replaceFirst("%s", String.valueOf(modifyUserID));
            loginStr = loginStr.replaceFirst("%s", String.valueOf(modifyedUserID));
        }
        TEAbNormalEvent userInfoEditEvent = new TEAbNormalEvent();
        userInfoEditEvent.eventID = 19;
        userInfoEditEvent.eventName = TENEListUtils.getString(String.valueOf(userInfoEditEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        userInfoEditEvent.objStr = ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        userInfoEditEvent.timeStr = startTime;
        userInfoEditEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        userInfoEditEvent.severityLevel = 4;
        userInfoEditEvent.severityStr = TENEListUtils.getString(String.valueOf(userInfoEditEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        userInfoEditEvent.eventType = 1;
        userInfoEditEvent.typeStr = TENEListUtils.getString("alarmType" + userInfoEditEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        userInfoEditEvent.nodeType = ne.getNEType();
        userInfoEditEvent.comment = loginStr;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, userInfoEditEvent);
    }

    private void interpretUMAddEvent(int cmdkey, int neID, Operation operation) {
        int userID = 0;
        int addUserID = 0;
        StringBuffer descriptionStr = new StringBuffer();
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("userID")) {
                    userID = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("addUserID")) continue;
                addUserID = Integer.parseInt(value);
            }
        }
        descriptionStr.append(userID);
        descriptionStr.append(TENEListUtils.getString("UM_ADD_NEUSER"));
        descriptionStr.append(addUserID);
        TEAbNormalEvent userAddEvent = new TEAbNormalEvent();
        userAddEvent.eventID = 34;
        userAddEvent.eventName = TENEListUtils.getString(String.valueOf(userAddEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        userAddEvent.objStr = ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        userAddEvent.timeStr = startTime;
        userAddEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        userAddEvent.severityLevel = 4;
        userAddEvent.severityStr = TENEListUtils.getString(String.valueOf(userAddEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        userAddEvent.eventType = 1;
        userAddEvent.typeStr = TENEListUtils.getString("alarmType" + userAddEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        userAddEvent.nodeType = ne.getNEType();
        userAddEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, userAddEvent);
    }

    private void interpretUMDelEvent(int cmdkey, int neID, Operation operation) {
        int userID = 0;
        int deletedUserID = 0;
        StringBuffer descriptionStr = new StringBuffer();
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("userID")) {
                    userID = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("deletedUserID")) continue;
                deletedUserID = Integer.parseInt(value);
            }
        }
        descriptionStr.append(userID);
        descriptionStr.append(TENEListUtils.getString("UM_DEL_NEUSER"));
        descriptionStr.append(deletedUserID);
        TEAbNormalEvent userDelEvent = new TEAbNormalEvent();
        userDelEvent.eventID = 33;
        userDelEvent.eventName = TENEListUtils.getString(String.valueOf(userDelEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        userDelEvent.objStr = ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        userDelEvent.timeStr = startTime;
        userDelEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        userDelEvent.severityLevel = 4;
        userDelEvent.severityStr = TENEListUtils.getString(String.valueOf(userDelEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        userDelEvent.eventType = 1;
        userDelEvent.typeStr = TENEListUtils.getString("alarmType" + userDelEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        userDelEvent.nodeType = ne.getNEType();
        userDelEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, userDelEvent);
    }

    private void interpretUMLockEvent(int cmdkey, int neID, Operation operation) {
        int userID = 0;
        int lockStatus = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("userID")) {
                    userID = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("lockStatus")) continue;
                lockStatus = Integer.parseInt(value);
            }
        }
        String lockStr = "UM_LOCK_DESCRIPTION";
        lockStr = lockStr + lockStatus;
        lockStr = TENEListUtils.getString(lockStr);
        lockStr = lockStr.replaceFirst("%s", String.valueOf(userID));
        TEAbNormalEvent userLockEvent = new TEAbNormalEvent();
        userLockEvent.eventID = 20;
        if (lockStatus != 0) {
            userLockEvent.eventID = 20;
        }
        userLockEvent.eventName = TENEListUtils.getString(String.valueOf(userLockEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        userLockEvent.objStr = ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        userLockEvent.timeStr = startTime;
        userLockEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        userLockEvent.severityLevel = 4;
        userLockEvent.severityStr = TENEListUtils.getString(String.valueOf(userLockEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        userLockEvent.eventType = 1;
        userLockEvent.typeStr = TENEListUtils.getString("alarmType" + userLockEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        userLockEvent.nodeType = ne.getNEType();
        userLockEvent.comment = lockStr;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, userLockEvent);
    }

    private void interpretUMLockModeEvent(int cmdkey, int neID, Operation operation) {
        int userID = 0;
        int modeID = 0;
        int delayTime = 0;
        int lockStatus = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("userID")) {
                    userID = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("modeID")) {
                    modeID = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("delayTime")) {
                    delayTime = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("lockStatus")) continue;
                lockStatus = Integer.parseInt(value);
            }
        }
        String lockMOStr = "";
        String moStr = "UM_MODEL_NAME";
        if (lockStatus > 0) {
            lockMOStr = "UM_LOCKMOD_DESCRIPTION";
            lockMOStr = lockMOStr + (delayTime > 0 ? 1 : 0);
        } else {
            lockMOStr = "UM_UNLOCKMOD_DESCRIPTION";
        }
        moStr = moStr + modeID;
        lockMOStr = TENEListUtils.getString(lockMOStr);
        moStr = TENEListUtils.getString(moStr);
        lockMOStr = lockMOStr.replaceFirst("%s", moStr);
        lockMOStr = lockMOStr.replaceFirst("%s", String.valueOf(userID));
        if (lockStatus > 0 && delayTime > 0) {
            lockMOStr = lockMOStr.replaceFirst("%s", String.valueOf(delayTime));
        }
        TEAbNormalEvent nmLockModeEvent = new TEAbNormalEvent();
        nmLockModeEvent.eventID = lockStatus == 0 ? 22 : 21;
        nmLockModeEvent.eventName = TENEListUtils.getString(String.valueOf(nmLockModeEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        nmLockModeEvent.objStr = ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        nmLockModeEvent.timeStr = startTime;
        nmLockModeEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        nmLockModeEvent.severityLevel = 4;
        nmLockModeEvent.severityStr = TENEListUtils.getString(String.valueOf(nmLockModeEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        nmLockModeEvent.eventType = 1;
        nmLockModeEvent.typeStr = TENEListUtils.getString("alarmType" + nmLockModeEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        nmLockModeEvent.nodeType = ne.getNEType();
        nmLockModeEvent.comment = lockMOStr;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, nmLockModeEvent);
    }

    private void interpretLoginIllegalEvent(int cmdkey, int neID, Operation operation) {
        int userID = 0;
        int operationType = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("userID")) {
                    userID = Integer.parseInt(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("operationType")) continue;
                operationType = Integer.parseInt(value);
            }
        }
        String loginIllegalStr = "UM_ILLEGAL_LOGIN_DESCRIPTION";
        loginIllegalStr = TENEListUtils.getString(loginIllegalStr);
        loginIllegalStr = loginIllegalStr.replaceFirst("%s", String.valueOf(userID));
        String reasonStr = "UM_ILLEGAL_LOGIN_REASON";
        reasonStr = reasonStr + (operationType - 1);
        reasonStr = TENEListUtils.getString(reasonStr);
        loginIllegalStr = loginIllegalStr + reasonStr;
        TEAbNormalEvent loginIllegalEvent = new TEAbNormalEvent();
        loginIllegalEvent.eventID = 35;
        loginIllegalEvent.eventName = TENEListUtils.getString(String.valueOf(loginIllegalEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        loginIllegalEvent.objStr = ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        loginIllegalEvent.timeStr = startTime;
        loginIllegalEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        loginIllegalEvent.severityLevel = 4;
        loginIllegalEvent.severityStr = TENEListUtils.getString(String.valueOf(loginIllegalEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        loginIllegalEvent.eventType = 1;
        loginIllegalEvent.typeStr = TENEListUtils.getString("alarmType" + loginIllegalEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        loginIllegalEvent.nodeType = ne.getNEType();
        loginIllegalEvent.timeStr = startTime;
        loginIllegalEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        loginIllegalEvent.comment = loginIllegalStr;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, loginIllegalEvent);
    }

    private void interpretUMCFGChangeEvent(int cmdKey, int neID, Operation operation) {
        int userID = 0;
        int modelID = 0;
        int subModelID = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("userID")) {
                    userID = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("modelID")) {
                    modelID = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("subModelID")) continue;
                subModelID = Integer.parseInt(value);
            }
        }
        String cfgChangeStr = "";
        String modelStr = "UM_MODEL_NAME";
        modelStr = modelStr + modelID;
        modelStr = TENEListUtils.getString(modelStr);
        String subModelStr = "UM_QX5_MODEL_NAME";
        if (subModelID > 0) {
            cfgChangeStr = "UM_CFG_DESCRIPTION1";
            cfgChangeStr = TENEListUtils.getString(cfgChangeStr);
            subModelStr = subModelStr + subModelID;
            subModelStr = TENEListUtils.getString(subModelStr);
            cfgChangeStr = cfgChangeStr.replaceFirst("%s", modelStr);
            cfgChangeStr = cfgChangeStr.replaceFirst("%s", subModelStr);
            cfgChangeStr = cfgChangeStr.replaceFirst("%s", String.valueOf(userID));
        } else {
            cfgChangeStr = "UM_CFG_DESCRIPTION0";
            cfgChangeStr = TENEListUtils.getString(cfgChangeStr);
            cfgChangeStr = cfgChangeStr.replaceFirst("%s", modelStr);
            cfgChangeStr = cfgChangeStr.replaceFirst("%s", String.valueOf(userID));
        }
        TEAbNormalEvent userCFGChangeEvent = new TEAbNormalEvent();
        userCFGChangeEvent.eventID = 16;
        userCFGChangeEvent.eventName = TENEListUtils.getString(String.valueOf(userCFGChangeEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        userCFGChangeEvent.objStr = ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        userCFGChangeEvent.timeStr = startTime;
        userCFGChangeEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        userCFGChangeEvent.severityLevel = 4;
        userCFGChangeEvent.severityStr = TENEListUtils.getString(String.valueOf(userCFGChangeEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        userCFGChangeEvent.eventType = 1;
        userCFGChangeEvent.typeStr = TENEListUtils.getString("alarmType" + userCFGChangeEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        userCFGChangeEvent.nodeType = ne.getNEType();
        userCFGChangeEvent.comment = cfgChangeStr;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, userCFGChangeEvent);
    }

    private void interpretLoginPassWordEvent(int cmdKey, int neID, Operation operation) {
        if (GetTimeDiff.isOccurToFast(neID, cmdKey)) {
            return;
        }
        this.addAbNormalEvent(neID, 28447, TENEListUtils.getString("loginpassword"), TENEListUtils.getString("loginpassworddetail"));
    }

    private void interpretLoginWarningEvent(int cmdKey, int neID, Operation operation) {
        if (GetTimeDiff.isOccurToFast(neID, cmdKey)) {
            return;
        }
        this.addAbNormalEvent(neID, 28445, TENEListUtils.getString("loginwarning"), TENEListUtils.getString("loginwarningdetail"));
    }

    private void interpretPasswordExpiredEvent(int cmdKey, int neID, Operation operation) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String username = ne.getCurUser();
        String loginStr = TENEListUtils.getString("passwordexpireddetail");
        loginStr = loginStr.replaceFirst("%s", username);
        this.addAbNormalEvent(neID, 28445, TENEListUtils.getString("passwordexpired"), loginStr);
    }

    private void interpretPasswordNeedModifyEvent(int cmdKey, int neID, Operation operation) {
        String loginStr = TENEListUtils.getString("passwordneedmodifydetail");
        this.addAbNormalEvent(neID, 20578, TENEListUtils.getString("passwordneedmodify"), loginStr);
    }

    private void interpretAccountExpiredEvent(int cmdKey, int neID, Operation operation) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String username = ne.getCurUser();
        String loginStr = TENEListUtils.getString("accountexpireddetail");
        loginStr = loginStr.replaceFirst("%s", username);
        this.addAbNormalEvent(neID, 28445, TENEListUtils.getString("accountexpired"), loginStr);
    }

    private void interpretNEResumeResultEvent(int cmdKey, int neID, Operation operation) {
        String result = operation.getOutput(0).getFault(0).getCode();
        String resultKey = "confresume_result" + result;
        this.addAbNormalEvent(neID, 18534, TENEListUtils.getString("neresumeresult_eventname"), TENEListUtils.getString(resultKey));
    }

    private void addAbNormalEvent(int neID, int eventID, String eventName, String descriptionStr) {
        TEAbNormalEvent loginEvent = new TEAbNormalEvent();
        loginEvent.eventID = eventID;
        loginEvent.eventName = eventName;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        loginEvent.objStr = ne.getNEName();
        loginEvent.nodeType = ne.getNEType();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        loginEvent.timeStr = startTime;
        loginEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        loginEvent.severityLevel = 4;
        loginEvent.severityStr = TENEListUtils.getString(String.valueOf(loginEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        loginEvent.eventType = 5;
        loginEvent.typeStr = TENEListUtils.getString("alarmType" + loginEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        loginEvent.comment = descriptionStr;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, loginEvent);
    }

    private int getNeType(int neid) {
        int type = -1;
        int TIMEOUT = 10;
        String QX_DES_PATH = "conf" + File.separator + "qxdescrib.xml";
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            Operation operation = TECreateObjectFactory.getOperation(QX_DES_PATH, "NSCMD_CFG_GET_DEVICE_TYPE");
            operationList.add(operation.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, TIMEOUT);
            if (result.retCode == 0) {
                operation = (Operation)operationList.get(0);
                int len1 = operation.getOutputCount();
                for (int i = 0; i < len1; ++i) {
                    Output output = operation.getOutput()[i];
                    int len2 = output.getFaultCount();
                    for (int j = 0; j < len2; ++j) {
                        if (!output.getFault()[j].getCode().equals("0")) continue;
                        int len3 = output.getPartCount();
                        for (int k = 0; k < len3; ++k) {
                            Part part = output.getPart()[k];
                            if (!part.getName().equals("deviceType")) continue;
                            type = Integer.parseInt(part.getValue());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESecurityEventNoticeHandler.getNeType() fail!", (Throwable)e);
        }
        return type;
    }

    private void neEventHandler(int cmdKey, int neID, Operation operation) {
        int[] specialInfo = this.getSimpleEventSpInfo(cmdKey, operation);
        TEAbNormalEvent simpleEvent = new TEAbNormalEvent();
        simpleEvent.eventID = specialInfo[0];
        simpleEvent.eventName = TENEListUtils.getString("simpleEventName" + simpleEvent.eventID);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        simpleEvent.objStr = ne.getNEName();
        simpleEvent.nodeType = ne.getNEType();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        simpleEvent.timeStr = startTime;
        simpleEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        simpleEvent.severityLevel = specialInfo[1];
        simpleEvent.severityStr = TENEListUtils.getString(String.valueOf(simpleEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        simpleEvent.eventType = 5;
        simpleEvent.typeStr = TENEListUtils.getString("alarmType" + simpleEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        String des = this.getSpcialDes(cmdKey, neID, operation);
        simpleEvent.comment = des == null ? TENEListUtils.getString("simpleEventDes" + simpleEvent.eventID) : des;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, simpleEvent);
    }

    private int[] getSimpleEventSpInfo(int cmdKey, Operation operation) {
        int[] info = new int[2];
        switch (cmdKey) {
            case 28442: {
                info[0] = 23;
                info[1] = 2;
                break;
            }
            case 28444: {
                info[0] = 24;
                info[1] = 4;
                break;
            }
            case 20561: {
                info[0] = 25;
                info[1] = 1;
                break;
            }
            case 20562: {
                info[0] = 27;
                info[1] = 1;
                break;
            }
            case 20563: {
                info[0] = 28;
                info[1] = 1;
                break;
            }
            case 20567: {
                info[0] = 29;
                info[1] = 2;
                break;
            }
            case 20568: {
                info[0] = 30;
                info[1] = 2;
                break;
            }
            case 20571: {
                info[0] = 31;
                info[1] = 2;
                break;
            }
            case 20572: {
                info[0] = 32;
                info[1] = 4;
                break;
            }
            case 20573: {
                info[0] = 39;
                info[1] = 2;
                break;
            }
            case 20574: {
                int lockStatus = this.getConfigLockEventStatus(operation);
                info[0] = lockStatus == 0 ? 22 : 21;
                info[1] = 3;
                break;
            }
            case 20575: {
                info[0] = 41;
                info[1] = 1;
                break;
            }
            case 20576: {
                info[0] = 42;
                info[1] = 4;
                break;
            }
            case 20577: {
                info[0] = 43;
                info[1] = 4;
                break;
            }
        }
        return info;
    }

    private int getConfigLockEventStatus(Operation operation) {
        int lockStatus = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (!name.equalsIgnoreCase("lockFlg")) continue;
                lockStatus = Integer.parseInt(value);
            }
        }
        return lockStatus;
    }

    private String getSpcialDes(int cmdKey, int neID, Operation operation) {
        String resStr = null;
        switch (cmdKey) {
            case 28442: {
                resStr = TENEListUtils.getString("simpleEventDes23");
                resStr = resStr.replaceAll("%m", TENEListMgr.getInstance().getNE(neID).getCurUser());
                break;
            }
            case 20568: {
                resStr = TENEListUtils.getString("simpleEventDes30");
                resStr = resStr.replaceAll("%m", TENEListMgr.getInstance().getNE(neID).getCurUser());
                break;
            }
            case 20567: {
                resStr = TENEListUtils.getString("simpleEventDes29");
                resStr = resStr.replaceAll("%m", TENEListMgr.getInstance().getNE(neID).getCurUser());
                break;
            }
            case 20574: {
                resStr = this.constructDes_configLock(neID, operation);
                break;
            }
            case 20575: {
                resStr = TENEListUtils.getString("simpleEventDes41");
                resStr = resStr.replaceAll("%m", TENEListMgr.getInstance().getNE(neID).getNEName());
                break;
            }
            case 20576: {
                resStr = this.constructDes_lctLogin(neID, operation);
                break;
            }
            case 20577: {
                resStr = this.constructDes_lctLogout(neID, operation);
                break;
            }
        }
        return resStr;
    }

    private String constructDes_configLock(int neID, Operation oper) {
        String str = TENEListUtils.getString("confLockDes");
        Output output = oper.getOutput(0);
        String userLevel = output.getPartValue("userLevel");
        String lockFlg = output.getPartValue("lockFlg");
        str = str.replaceAll("%m", TENEListUtils.getString("userLevel" + userLevel));
        str = str.replaceAll("%n", TENEListUtils.getString("lockFlg" + lockFlg));
        return str;
    }

    private String constructDes_lctLogin(int neID, Operation oper) {
        String str = TENEListUtils.getString("lctLogin");
        Output output = oper.getOutput(0);
        String userName = IOStreamConvertor.replaceSpecialStr(output.getPartValue("userName")).trim();
        long address = Long.valueOf(output.getPartValue("address"));
        String addStr = IPAddressUtil.convertIPLongToStr(address);
        if (!IPAddressUtil.isValidIP(addStr)) {
            addStr = TEConvertUtil.convertNeIDLongToStr(neID);
        }
        str = str.replaceAll("%l", userName);
        str = str.replaceAll("%m", addStr);
        return str;
    }

    private String constructDes_lctLogout(int neID, Operation oper) {
        String str = TENEListUtils.getString("lctLogout");
        Output output = oper.getOutput(0);
        String userName = IOStreamConvertor.replaceSpecialStr(output.getPartValue("userName")).trim();
        String terminalType = output.getPartValue("terminalType");
        str = str.replaceAll("%l", userName);
        str = str.replaceAll("%n", TENEListUtils.getString("terminalType" + terminalType));
        return str;
    }
}

