/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TESNCPSwitchAbnormalEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 16413 || cmdKey == 16560) {
            this.eventinterpretEvent(cmdKey, neID, oper);
        }
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper) {
        int slotID = 0;
        int groupID = 0;
        int switchState = 0;
        int currentWorkLink = 0;
        int mainLinkState = 0;
        int backLinkState = 0;
        StringBuffer description = new StringBuffer(70);
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("slotID")) {
                    slotID = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("PortectGroupID")) {
                    groupID = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("SwitchRequest")) {
                    switchState = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("CurrentWorkLink")) {
                    currentWorkLink = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("MainLinkState")) {
                    mainLinkState = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("BackLinkState")) continue;
                backLinkState = Integer.parseInt(value);
            }
        }
        TEAbNormalEvent sncpSwitchEvent = new TEAbNormalEvent();
        sncpSwitchEvent.eventID = 15;
        sncpSwitchEvent.eventName = TENEListUtils.getString(String.valueOf(sncpSwitchEvent.eventID));
        description.append(slotID).append('-');
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        description.append(boardName);
        description.append(TENEListUtils.getString("TE_LOG_SEMICOLON"));
        description.append(TENEListUtils.getString("PROTECT_GROUP"));
        description.append(groupID);
        description.append(TENEListUtils.getString("TE_LOG_SEMICOLON"));
        description.append(TENEListUtils.getString("SNCP_Switch_State" + switchState));
        description.append(TENEListUtils.getString("DOT_FLAG"));
        description.append(TENEListUtils.getString("Current_Work_Link" + currentWorkLink));
        description.append(TENEListUtils.getString("DOT_FLAG"));
        description.append(TENEListUtils.getString("Main_Link_State" + mainLinkState));
        description.append(TENEListUtils.getString("DOT_FLAG"));
        description.append(TENEListUtils.getString("Back_Link_State" + backLinkState));
        sncpSwitchEvent.comment = description.toString();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        sncpSwitchEvent.timeStr = startTime;
        sncpSwitchEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        sncpSwitchEvent.objStr = ne.getNEName();
        sncpSwitchEvent.nodeType = ne.getNEType();
        sncpSwitchEvent.eventName = TENEListUtils.getString(String.valueOf(sncpSwitchEvent.eventID));
        sncpSwitchEvent.severityLevel = 1;
        sncpSwitchEvent.severityStr = TENEListUtils.getString(String.valueOf(sncpSwitchEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        sncpSwitchEvent.eventType = 1;
        sncpSwitchEvent.typeStr = TENEListUtils.getString("alarmType" + sncpSwitchEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, sncpSwitchEvent);
    }
}

