/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeMgr;
import com.huawei.nglct.nelist.lpara.TEAlmReturnParamParse;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEROMNAbNormalEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation operation) {
        switch (cmdKey) {
            case 28657: 
            case 28658: {
                this.interpretRMONFailEvent(cmdKey, neID, operation);
                break;
            }
            case 20882: 
            case 20883: {
                this.interpretLPRMONFailEvent(cmdKey, neID, operation);
                break;
            }
        }
    }

    private void interpretLPRMONFailEvent(int cmdKey, int neID, Operation operation) {
        int slotID = 0;
        int portNo = 0;
        int pathNo = 0;
        int perfID = 0;
        String peTime = "";
        double curPerfValue = 0.0;
        double defaultValue = 0.0;
        TEPfmMonObjID monObj = null;
        TEAlmObjTypeData almObjTypeObj = null;
        TEAlmObjTypeMgr almObjTypeMgr = new TEAlmObjTypeMgr(neID);
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                if (part.getName().equals("peid")) {
                    perfID = TEPfmUtility.qx5Eid2PfmEid(neID, slotID, Integer.parseInt(part.getValue()));
                    continue;
                }
                if (name.equalsIgnoreCase("peValue")) {
                    curPerfValue = IOStreamConvertor.readLong(IOStreamConvertor.getByteArrayFromString(part.getValue()), 0);
                    continue;
                }
                if (name.equalsIgnoreCase("lowValue")) {
                    defaultValue = IOStreamConvertor.readLong(IOStreamConvertor.getByteArrayFromString(part.getValue()), 0);
                    continue;
                }
                if (name.equalsIgnoreCase("upValue")) {
                    defaultValue = IOStreamConvertor.readLong(IOStreamConvertor.getByteArrayFromString(part.getValue()), 0);
                    continue;
                }
                if (name.equalsIgnoreCase("peTime")) {
                    peTime = part.getValue();
                    continue;
                }
                if (TEPfmUtility.validatePart(part, "objtype")) {
                    almObjTypeObj = almObjTypeMgr.getAlmObjTypeData(Integer.valueOf(part.getValue()));
                    continue;
                }
                if (!TEPfmUtility.validatePart(part, "objpara")) continue;
                byte[] objByte = part.getValue().getBytes();
                if (almObjTypeObj == null) continue;
                monObj = TEAlmReturnParamParse.getInstance().parseObjParam(objByte, almObjTypeObj);
            }
        }
        if (monObj != null) {
            slotID = monObj.getSlotID();
            portNo = monObj.getPortID();
            pathNo = monObj.getPathID();
        }
        this.setRMONFailEvent(cmdKey, neID, slotID, portNo, pathNo, perfID, curPerfValue, defaultValue, peTime);
    }

    private void interpretRMONFailEvent(int cmdKey, int neID, Operation operation) {
        int slotID = 0;
        int portNo = 0;
        int pathNo = 0;
        int perfID = 0;
        long curPerfValue = 0L;
        long defaultValue = 0L;
        String peTime = "";
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("slotID")) {
                    slotID = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("portNo")) {
                    portNo = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("pathID")) {
                    pathNo = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("perfID")) {
                    perfID = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("curPerfValue")) {
                    curPerfValue = Long.parseLong(value);
                    continue;
                }
                if (name.equalsIgnoreCase("upPerfValue")) {
                    defaultValue = Long.parseLong(value);
                    continue;
                }
                if (name.equalsIgnoreCase("dwPerfValue")) {
                    defaultValue = Long.parseLong(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("peTime")) continue;
                peTime = part.getValue();
            }
        }
        this.setRMONFailEvent(cmdKey, neID, slotID, portNo, pathNo, perfID, curPerfValue, defaultValue, peTime);
    }

    private void setRMONFailEvent(int cmdKey, int neID, int slotID, int portNo, int pathNo, int perfID, Object curPerfValue, Object defaultValue, String peTime) {
        TEAbNormalEvent adjustFailEvent = new TEAbNormalEvent();
        adjustFailEvent.eventID = cmdKey == 20882 || cmdKey == 28657 ? 101 : 102;
        adjustFailEvent.eventName = TENEListUtils.getString(String.valueOf(adjustFailEvent.eventID));
        StringBuilder description = new StringBuilder();
        if (slotID != 0 && slotID != -1) {
            String subrackName = TEBoardUtil.getSubrackNameFromSlot(neID, slotID);
            if (!"".equals(subrackName)) {
                description.append(subrackName + "-" + slotID).append("-");
            } else {
                description.append(slotID).append("-");
            }
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
            description.append(boardName);
            description.append("-");
            String portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, boardType, portNo);
            description.append(portName);
            description.append("-");
            if (boardType == 1067 && pathNo >= 32768) {
                description.append("VCTRUNK");
                description.append(pathNo - 32768);
            } else {
                description.append(pathNo);
            }
            description.append(TENEListUtils.getString("DOT_FLAG"));
        }
        String file = "nemgr" + File.separator + "necommon" + File.separator + "res" + File.separator + "rmon" + File.separator + "rmonres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
        TEResourceUtil res = TEResourceUtil.getInstance(file);
        description.append(res.getString("event" + perfID));
        description.append(TENEListUtils.getString("DOT_FLAG"));
        description.append(TENEListUtils.getString("RMON_CUR_PERFORM_VALUE"));
        description.append(TENEListUtils.getString("TE_LOG_SEMICOLON"));
        description.append(curPerfValue);
        description.append(TENEListUtils.getString("DOT_FLAG"));
        if (cmdKey == 20882 || cmdKey == 28657) {
            description.append(TENEListUtils.getString("RMON_PERFORM_DOWN_THRESHOLD"));
            description.append(TENEListUtils.getString("TE_LOG_SEMICOLON"));
            description.append(defaultValue);
        } else {
            description.append(TENEListUtils.getString("RMON_PERFORM_UP_THRESHOLD"));
            description.append(TENEListUtils.getString("TE_LOG_SEMICOLON"));
            description.append(defaultValue);
        }
        adjustFailEvent.comment = description.toString();
        Calendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        if (!peTime.equals("")) {
            startTime = TEDateUtils.byteStrToCalendar(peTime);
        }
        TimeZoneDateBean timeTool = TETimeTocalizationSwitchBean.getTimeZoneDateInstance(neID);
        adjustFailEvent.timeStr = startTime;
        adjustFailEvent.timeRiseStr = timeTool.calendarToTime((Calendar)startTime.clone());
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        adjustFailEvent.objStr = ne.getNEName();
        adjustFailEvent.nodeType = ne.getNEType();
        adjustFailEvent.severityLevel = 4;
        adjustFailEvent.severityStr = TENEListUtils.getString(String.valueOf(adjustFailEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        adjustFailEvent.eventType = 1;
        adjustFailEvent.typeStr = TENEListUtils.getString("alarmType" + adjustFailEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, adjustFailEvent);
    }
}

