/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEPwApsSwitchEventNoticeHandler
implements NoticeHandler {
    public void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 16677) {
            this.eventinterpretEvent(cmdKey, neID, oper, "PWAPS");
        } else if (cmdKey == 16452) {
            this.eventinterpretEvent(cmdKey, neID, oper, "APS");
        }
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper, String eventName) {
        TEAbNormalEvent pwApsEvent = null;
        Output output2 = null;
        StringBuilder des = new StringBuilder();
        for (Output output2 : oper.getOutput()) {
            pwApsEvent = new TEAbNormalEvent();
            pwApsEvent.eventID = cmdKey;
            des.append(TENEListUtils.getString(eventName + "apsid")).append(":");
            des.append(output2.getPartValue("groupid")).append(",");
            des.append(TENEListUtils.getString(eventName + "switchmode")).append(":");
            des.append(TENEListUtils.getString(eventName + "switchmode_" + output2.getPartValue("switchstate"))).append(",");
            des.append(TENEListUtils.getString(eventName + "protocolstatus")).append(":");
            des.append(TENEListUtils.getString(eventName + "protocolstatus_" + output2.getPartValue("protocolstate"))).append(",");
            des.append(TENEListUtils.getString(eventName + "workstatus")).append(":");
            des.append(TENEListUtils.getString(eventName + "status_" + output2.getPartValue("workstate"))).append(",");
            des.append(TENEListUtils.getString(eventName + "protectstatus")).append(":");
            des.append(TENEListUtils.getString(eventName + "status_" + output2.getPartValue("protectstate")));
            pwApsEvent.comment = des.toString();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            pwApsEvent.timeStr = startTime;
            pwApsEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            pwApsEvent.objStr = ne.getNEName();
            pwApsEvent.nodeType = ne.getNEType();
            pwApsEvent.eventName = TENEListUtils.getString(eventName + "_EVT_STATE");
            pwApsEvent.severityLevel = 2;
            pwApsEvent.severityStr = TENEListUtils.getString(String.valueOf(pwApsEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            pwApsEvent.eventType = 1;
            pwApsEvent.typeStr = TENEListUtils.getString("alarmType" + pwApsEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, pwApsEvent);
        }
    }
}

