/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEPortSwitchAbnormalEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 16403 || cmdKey == 18540) {
            this.interpretPortSwitchEvent(cmdKey, neID, oper);
        }
    }

    private void interpretPortSwitchEvent(int cmdKey, int neID, Operation oper) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int currentWorkPath = 0;
        int PortectGroupID = 0;
        int SwitchRequest = 0;
        int MainPathSTATE = 0;
        int BackPathSTATE = 0;
        int switchingStatus = -1;
        StringBuffer description = new StringBuffer(100);
        Output[] outputArry = oper.getOutput();
        int len = outputArry.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArry[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("PortectGroupID")) {
                    PortectGroupID = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("CurrentWorkPath")) {
                    currentWorkPath = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("SwitchRequest")) {
                    SwitchRequest = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("MainPathSTATE")) {
                    MainPathSTATE = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("ProtectPathSTATE")) {
                    BackPathSTATE = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("switchingStatus")) continue;
                switchingStatus = Integer.parseInt(value);
            }
        }
        TEAbNormalEvent portSwitchEvent = new TEAbNormalEvent();
        portSwitchEvent.eventID = 192;
        portSwitchEvent.eventName = TENEListUtils.getString(String.valueOf(portSwitchEvent.eventID));
        description.append(TENEListUtils.getString("PROTECT_GROUP"));
        description.append(ne.getNEName()).append('-').append(PortectGroupID);
        description.append(TENEListUtils.getString("TE_LOG_SEMICOLON"));
        description.append(TENEListUtils.getString("CURRENT_WORK_PATH" + currentWorkPath));
        description.append(TENEListUtils.getString("DOT_FLAG"));
        description.append(TENEListUtils.getString("SWITCH_REQUEST" + SwitchRequest));
        description.append(TENEListUtils.getString("DOT_FLAG"));
        description.append(TENEListUtils.getString("MAIN_PATH_STATE" + MainPathSTATE));
        description.append(TENEListUtils.getString("DOT_FLAG"));
        description.append(TENEListUtils.getString("BackPathSTATE" + BackPathSTATE));
        if (switchingStatus != -1) {
            description.append(TENEListUtils.getString("DOT_FLAG"));
            description.append(TENEListUtils.getString("switchingStatus" + switchingStatus));
        }
        portSwitchEvent.comment = description.toString();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        portSwitchEvent.timeStr = startTime;
        portSwitchEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        portSwitchEvent.objStr = ne.getNEName();
        portSwitchEvent.nodeType = ne.getNEType();
        portSwitchEvent.severityLevel = 1;
        portSwitchEvent.severityStr = TENEListUtils.getString(String.valueOf(portSwitchEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        portSwitchEvent.eventType = 1;
        portSwitchEvent.typeStr = TENEListUtils.getString("alarmType" + portSwitchEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        portSwitchEvent.eventName = TENEListUtils.getString(String.valueOf(portSwitchEvent.eventID));
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, portSwitchEvent);
    }
}

