/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.device.ne.TENEUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEPLAFoAbnEvtNoticeHandler
implements NoticeHandler {
    private static final int UNKNOWN_NEID = -1;

    public synchronized void handleNotice(int cmdKey, int neID, Operation operation) {
        if (cmdKey == 18532) {
            this.pLAEvent(cmdKey, neID, operation);
        }
    }

    private void pLAEvent(int cmdkey, int neID, Operation oper) {
        TEAbNormalEvent rtnPlaEvent = null;
        StringBuffer des = new StringBuffer();
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            rtnPlaEvent = new TEAbNormalEvent();
            rtnPlaEvent.eventID = cmdkey;
            this.getDes(des, outputArr[i]);
            rtnPlaEvent.comment = des.toString();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            rtnPlaEvent.timeStr = startTime;
            rtnPlaEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            rtnPlaEvent.objStr = ne.getNEName();
            rtnPlaEvent.nodeType = ne.getNEType();
            rtnPlaEvent.eventName = TENEListUtils.getString(String.valueOf(cmdkey));
            rtnPlaEvent.severityLevel = 4;
            rtnPlaEvent.severityStr = TENEListUtils.getString(String.valueOf(rtnPlaEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            rtnPlaEvent.eventType = 3;
            rtnPlaEvent.typeStr = TENEListUtils.getString("alarmType" + rtnPlaEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, rtnPlaEvent);
        }
    }

    private void getDes(StringBuffer des, Output output) {
        TENE slaveNE;
        TEBoard slaveboard;
        TENE mainNE;
        TEBoard mainboard;
        String unknownres = TENEListUtils.getString("plaunknownres");
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        String plagid = output.getPart("ggroupid").getValue();
        des.append(TENEListUtils.getString("plagid")).append(plagid).append(',');
        String mainlogicid = output.getPart("mainneid").getValue();
        int tempmainneid = -1;
        if (Long.parseLong(mainlogicid) != 0xFFFFFFFFL) {
            try {
                tempmainneid = Integer.parseInt(mainlogicid);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Parse neid in PLA error:", (Throwable)e);
            }
            if (-1 != tempmainneid) {
                mainlogicid = TENEUtils.formatNEID(tempmainneid);
            }
        }
        if (mainlogicid.equals("4294967295")) {
            mainlogicid = TENEListUtils.getString("plaunknownres");
        }
        des.append(TENEListUtils.getString("mainnelogicid")).append(mainlogicid).append(',');
        String mainneslotid = output.getPart("mainneslotid").getValue();
        String mainneportid = output.getPart("mainneportid").getValue();
        String mainslotname = unknownres;
        String mainportname = unknownres;
        if (-1 != tempmainneid && null != (mainboard = mgr.getBoard((mainNE = TENEListMgr.getInstance().getPhyNE(tempmainneid)).getNEID(), Integer.parseInt(mainneslotid)))) {
            mainslotname = mainboard.getBoardName();
            mainportname = mgr.getPortName(mainNE.getNEID(), Integer.parseInt(mainneslotid), mainboard.getBoardType(), Integer.parseInt(mainneportid));
        }
        StringBuffer sb = new StringBuffer();
        if (mainneslotid.equals("65535") && mainslotname.equals(unknownres) && mainportname.equals(unknownres)) {
            sb.append(unknownres);
        } else {
            sb.append(mainneslotid).append("-").append(mainslotname).append("-").append(mainportname);
        }
        des.append(TENEListUtils.getString("mainport")).append(sb.toString()).append(',');
        String mainneHDStatus = output.getPart("mainneHDStatus").getValue();
        des.append(TENEListUtils.getString("mainneHDStatus")).append(TENEListUtils.getString("plagstatus_" + mainneHDStatus)).append(',');
        String mainneLinkStatus = output.getPart("mainneLinkStatus").getValue();
        des.append(TENEListUtils.getString("mainneLinkStatus")).append(TENEListUtils.getString("plagstatus_" + mainneLinkStatus)).append(',');
        String mainneWorkStatus = output.getPart("mainneWorkStatus").getValue();
        des.append(TENEListUtils.getString("mainneWorkStatus")).append(TENEListUtils.getString("smartworkstatus_" + mainneWorkStatus)).append(',');
        String slaveportinfo = output.getPart("slaveneids").getValue();
        long slaveneid = Long.parseLong(slaveportinfo.substring(0, 8), 16);
        int slaveneslotid = Integer.parseInt(slaveportinfo.substring(8, 12), 16);
        int slaveneportid = Integer.parseInt(slaveportinfo.substring(14, 16), 16);
        int slaveneHardStatus = Integer.parseInt(slaveportinfo.substring(16, 18), 16);
        int slaveneLinkStatus = Integer.parseInt(slaveportinfo.substring(18, 20), 16);
        int slaveneWorkStatus = Integer.parseInt(slaveportinfo.substring(20, 22), 16);
        String slavelogicid = slaveneid + "";
        int tempslaveneid = -1;
        if (Long.parseLong(slavelogicid) != 0xFFFFFFFFL) {
            try {
                tempslaveneid = Integer.parseInt(slavelogicid);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Parse neid in PLA error:", (Throwable)e);
            }
            if (-1 != tempslaveneid) {
                slavelogicid = TENEUtils.formatNEID(tempslaveneid);
            }
        }
        des.append(TENEListUtils.getString("slavelogicid")).append(slavelogicid).append(',');
        String slaveslotname = unknownres;
        String slaveportname = unknownres;
        if (-1 != tempslaveneid && null != (slaveboard = mgr.getBoard((slaveNE = TENEListMgr.getInstance().getPhyNE(tempslaveneid)).getNEID(), slaveneslotid))) {
            slaveslotname = slaveboard.getBoardName();
            slaveportname = mgr.getPortName(slaveNE.getNEID(), slaveneslotid, slaveboard.getBoardType(), slaveneportid);
        }
        StringBuffer sbs = new StringBuffer();
        if (slaveneslotid == 65535 && mainslotname.equals(unknownres) && mainportname.equals(unknownres)) {
            sbs.append(unknownres);
        } else {
            sbs.append(slaveneslotid).append("-").append(slaveslotname).append("-").append(slaveportname);
        }
        des.append(TENEListUtils.getString("slaveport")).append(sbs.toString()).append(',');
        des.append(TENEListUtils.getString("slaveneHardStatus")).append(TENEListUtils.getString("plagstatus_" + slaveneHardStatus)).append(',');
        des.append(TENEListUtils.getString("slaveneLinkStatus")).append(TENEListUtils.getString("plagstatus_" + slaveneLinkStatus)).append(',');
        des.append(TENEListUtils.getString("slaveneWorkStatus")).append(TENEListUtils.getString("smartworkstatus_" + slaveneWorkStatus));
    }
}

