/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEPLAAbNormalEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation operation) {
        if (cmdKey == 18486) {
            this.pLAEvent(cmdKey, neID, operation);
        }
    }

    private void pLAEvent(int cmdkey, int neID, Operation oper) {
        TEAbNormalEvent plaEvent = null;
        StringBuffer des = new StringBuffer();
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            plaEvent = new TEAbNormalEvent();
            plaEvent.eventID = cmdkey;
            this.getDes(des, outputArr[i]);
            plaEvent.comment = des.toString();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            plaEvent.timeStr = startTime;
            plaEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            plaEvent.objStr = ne.getNEName();
            plaEvent.nodeType = ne.getNEType();
            plaEvent.eventName = TENEListUtils.getString(String.valueOf(cmdkey));
            plaEvent.severityLevel = 4;
            plaEvent.severityStr = TENEListUtils.getString(String.valueOf(plaEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            plaEvent.eventType = 3;
            plaEvent.typeStr = TENEListUtils.getString("alarmType" + plaEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, plaEvent);
        }
    }

    private void getDes(StringBuffer des, Output output) {
        String plagid = output.getPart("plagid").getValue();
        des.append(TENEListUtils.getString("plagid")).append(plagid).append(',');
        String mainslotid = output.getPart("mainslotid").getValue();
        des.append(TENEListUtils.getString("mainboard")).append(mainslotid).append(',');
        String mainportid = output.getPart("mainportid").getValue();
        des.append(TENEListUtils.getString("mainport")).append(mainportid).append(',');
        String mainporthardstatus = output.getPart("mainporthardstatus").getValue();
        des.append(TENEListUtils.getString("mainporthardstatus")).append(TENEListUtils.getString("plagstatus_" + mainporthardstatus)).append(',');
        String mainportlinkstatus = output.getPart("mainportlinkstatus").getValue();
        des.append(TENEListUtils.getString("mainportlagstatus")).append(TENEListUtils.getString("plagstatus_" + mainportlinkstatus)).append(',');
        String mainportworkstatus = output.getPart("mainportworkstatus").getValue();
        des.append(TENEListUtils.getString("mainportworkstatus")).append(TENEListUtils.getString("workstatus_" + mainportworkstatus)).append(',');
        String slaveportnum = output.getPart("slaveportnum").getValue();
        des.append(TENEListUtils.getString("slaveportnum")).append(slaveportnum).append(',');
        des.append(TENEListUtils.getString("slaveportattribute")).append(slaveportnum).append('(');
        String slaveportinfo = output.getPart("slaveportinfo").getValue();
        int slaveboard = Integer.parseInt(slaveportinfo.substring(0, 4), 16);
        des.append(TENEListUtils.getString("slaveboard")).append(slaveboard).append(',');
        int slaveport = Integer.parseInt(slaveportinfo.substring(6, 8), 16);
        des.append(TENEListUtils.getString("slaveport")).append(slaveport).append(',');
        int slaveporthardstatus = Integer.parseInt(slaveportinfo.substring(8, 10), 16);
        des.append(TENEListUtils.getString("slaveporthardstatus")).append(TENEListUtils.getString("plagstatus_" + slaveporthardstatus)).append(',');
        int slaveportlagstatus = Integer.parseInt(slaveportinfo.substring(10, 12), 16);
        des.append(TENEListUtils.getString("slaveportlagstatus")).append(TENEListUtils.getString("plagstatus_" + slaveportlagstatus)).append(',');
        int slaveportworkstatus = Integer.parseInt(slaveportinfo.substring(12, 14), 16);
        des.append(TENEListUtils.getString("slaveportworkstatus")).append(TENEListUtils.getString("workstatus_" + slaveportworkstatus)).append(')');
    }
}

