/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEODUkSwitchAbnormalEventNoticeHandler
implements NoticeHandler {
    private static final int PROTOCOL_NOT_START = 0;
    private static final int PROTOCOL_STARTING = 1;
    private static final int IDLE = 2;
    private static final int EAST_SWITCH = 3;
    private static final int WEST_SWITCH = 4;
    private static final int THROUGH = 5;
    private static final int APS_THROUGH = 6;
    private static final int LP = 22;
    private static final int SF_P = 21;
    private static final int SF_R = 19;
    private static final int SF_RP = 18;
    private static final int SF_RW = 17;
    private static final int SF_W = 16;
    private static final int FS_R = 14;
    private static final int SD_P = 13;
    private static final int SD_R = 11;
    private static final int SD_W = 10;
    private static final int MS_R = 8;
    private static final int WTR_R = 6;
    private static final int EXER_R = 3;
    private static final int NR = 0;
    private static final int NORMAL = 4;
    private static final int SF = 1;
    private static final int SD = 2;
    private static final int UNMONITOR = 5;
    private static final int FAR_INDICATION = 0;
    private static final int NEAR_INDICATION = 1;

    public void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 16429) {
            this.interpretODUkSwitchEvent(cmdKey, neID, oper);
        }
    }

    private void interpretODUkSwitchEvent(int cmdKey, int neID, Operation oper) {
        int groupId = 0;
        int pageStatus = 0;
        int westSwitchRequest = 0;
        int eastSwitchRequest = 0;
        int westWorkPathStatus = 0;
        int eastWorkPathStatus = 0;
        int westProtectionPathStatus = 0;
        int eastProtectionPathStatus = 0;
        int westFarAndNearIndication = 0;
        int eastFarAndNearIndication = 0;
        Output[] outputArry = oper.getOutput();
        int len = outputArry.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArry[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("groupId")) {
                    groupId = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("pageStatus")) {
                    pageStatus = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("westSwitchRequest")) {
                    westSwitchRequest = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("eastSwitchRequest")) {
                    eastSwitchRequest = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("westWorkPathStatus")) {
                    westWorkPathStatus = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("eastWorkPathStatus")) {
                    eastWorkPathStatus = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("westProtectionPathStatus")) {
                    westProtectionPathStatus = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("eastProtectionPathStatus")) {
                    eastProtectionPathStatus = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("westFarAndNearIndication")) {
                    westFarAndNearIndication = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("eastFarAndNearIndication")) continue;
                eastFarAndNearIndication = Integer.parseInt(value);
            }
        }
        TEAbNormalEvent odukSwitchEvent = new TEAbNormalEvent();
        odukSwitchEvent.eventID = 142;
        odukSwitchEvent.eventName = TENEListUtils.getString(String.valueOf(odukSwitchEvent.eventID));
        StringBuffer description = new StringBuffer();
        description.append(TENEListUtils.getString("protection_group_id"));
        description.append(groupId).append(',');
        description.append(TENEListUtils.getString("page_status")).append(this.getCurrentPageStatus(pageStatus)).append(',');
        String switchStatusStr = this.getSwitchStatus(westSwitchRequest);
        description.append(TENEListUtils.getString("west_path_switch_request")).append(switchStatusStr).append(',');
        switchStatusStr = this.getSwitchStatus(eastSwitchRequest);
        description.append(TENEListUtils.getString("east_path_switch_request")).append(switchStatusStr).append(',');
        String pathStatusStr = this.getPathStatus(westWorkPathStatus);
        description.append(TENEListUtils.getString("west_work_path_status")).append(pathStatusStr).append(',');
        pathStatusStr = this.getPathStatus(westProtectionPathStatus);
        description.append(TENEListUtils.getString("west_protection_path_status")).append(pathStatusStr).append(',');
        pathStatusStr = this.getPathStatus(eastWorkPathStatus);
        description.append(TENEListUtils.getString("east_work_path_status")).append(pathStatusStr).append(',');
        pathStatusStr = this.getPathStatus(eastProtectionPathStatus);
        description.append(TENEListUtils.getString("east_protection_path_status")).append(pathStatusStr).append(',');
        String farAndNearIndication = this.getFarAndNearIndication(westFarAndNearIndication);
        description.append(TENEListUtils.getString("west_farandnear_indication")).append(farAndNearIndication).append(',');
        farAndNearIndication = this.getFarAndNearIndication(eastFarAndNearIndication);
        description.append(TENEListUtils.getString("east_farandnear_indication")).append(farAndNearIndication);
        odukSwitchEvent.comment = description.toString();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        odukSwitchEvent.timeStr = startTime;
        odukSwitchEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        odukSwitchEvent.objStr = ne.getNEName();
        odukSwitchEvent.nodeType = ne.getNEType();
        odukSwitchEvent.severityLevel = 1;
        odukSwitchEvent.severityStr = TENEListUtils.getString(String.valueOf(odukSwitchEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        odukSwitchEvent.eventType = 1;
        odukSwitchEvent.typeStr = TENEListUtils.getString("alarmType" + odukSwitchEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        odukSwitchEvent.eventName = TENEListUtils.getString(String.valueOf(odukSwitchEvent.eventID));
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, odukSwitchEvent);
    }

    private String getCurrentPageStatus(int status) {
        String pageStatus = TENEListUtils.getString("unknown");
        switch (status) {
            case 0: {
                pageStatus = TENEListUtils.getString("protocol_notstart");
                break;
            }
            case 1: {
                pageStatus = TENEListUtils.getString("protocol_starting");
                break;
            }
            case 2: {
                pageStatus = TENEListUtils.getString("idle");
                break;
            }
            case 3: {
                pageStatus = TENEListUtils.getString("east_switch");
                break;
            }
            case 4: {
                pageStatus = TENEListUtils.getString("west_switch");
                break;
            }
            case 5: {
                pageStatus = TENEListUtils.getString("through");
                break;
            }
            case 6: {
                pageStatus = TENEListUtils.getString("aps_through");
                break;
            }
        }
        return pageStatus;
    }

    private String getPathStatus(int status) {
        String pathStatus = TENEListUtils.getString("unknown");
        switch (status) {
            case 4: {
                pathStatus = TENEListUtils.getString("normal");
                break;
            }
            case 2: {
                pathStatus = TENEListUtils.getString("sd");
                break;
            }
            case 1: {
                pathStatus = TENEListUtils.getString("sf");
                break;
            }
            case 5: {
                pathStatus = TENEListUtils.getString("unmonitor");
                break;
            }
        }
        return pathStatus;
    }

    private String getSwitchStatus(int status) {
        String switchStatus = TENEListUtils.getString("unknown");
        switch (status) {
            case 0: {
                switchStatus = TENEListUtils.getString("nr");
                break;
            }
            case 3: {
                switchStatus = TENEListUtils.getString("exer_r");
                break;
            }
            case 6: {
                switchStatus = TENEListUtils.getString("wtr_r");
                break;
            }
            case 8: {
                switchStatus = TENEListUtils.getString("ms_r");
                break;
            }
            case 10: {
                switchStatus = TENEListUtils.getString("sd_w");
                break;
            }
            case 11: {
                switchStatus = TENEListUtils.getString("sd_r");
                break;
            }
            case 13: {
                switchStatus = TENEListUtils.getString("sd_p");
                break;
            }
            case 14: {
                switchStatus = TENEListUtils.getString("fs_r");
                break;
            }
            case 16: {
                switchStatus = TENEListUtils.getString("sf_w");
                break;
            }
            case 17: {
                switchStatus = TENEListUtils.getString("sf_rw");
                break;
            }
            case 18: {
                switchStatus = TENEListUtils.getString("sf_rp");
                break;
            }
            case 19: {
                switchStatus = TENEListUtils.getString("sf_r");
                break;
            }
            case 21: {
                switchStatus = TENEListUtils.getString("sf_p");
                break;
            }
            case 22: {
                switchStatus = TENEListUtils.getString("lp");
                break;
            }
        }
        return switchStatus;
    }

    private String getFarAndNearIndication(int indication) {
        String farAndNear = TENEListUtils.getString("unknown");
        switch (indication) {
            case 0: {
                farAndNear = TENEListUtils.getString("far_indication");
                break;
            }
            case 1: {
                farAndNear = TENEListUtils.getString("near_indication");
                break;
            }
        }
        return farAndNear;
    }
}

