/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TENeighborInfoEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 18539) {
            this.eventinterpretEvent(cmdKey, neID, oper);
        }
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper) {
        StringBuffer des = new StringBuffer(50);
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            int slotID = Integer.parseInt(outputArr[i].getPart(0).getValue());
            int portID = Integer.parseInt(outputArr[i].getPart(2).getValue());
            byte eventType = Byte.parseByte(outputArr[i].getPart(3).getValue());
            long neighborID = Long.parseLong(outputArr[i].getPart(4).getValue());
            TEAbNormalEvent neighborEvent = new TEAbNormalEvent();
            neighborEvent.eventID = cmdKey;
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
            String portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, portID);
            des.append(slotID).append("-").append(boardName).append("-");
            des.append(portName).append(":");
            des.append(TENEListUtils.getString("neighbor_eventtype_" + eventType));
            des.append(neighborID);
            neighborEvent.comment = des.toString();
            neighborEvent.eventName = TENEListUtils.getString("neighbor_eventname");
            neighborEvent.severityLevel = 4;
            neighborEvent.severityStr = TENEListUtils.getString(String.valueOf(neighborEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            neighborEvent.objStr = ne.getNEName();
            neighborEvent.nodeType = ne.getNEType();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            neighborEvent.timeStr = startTime;
            neighborEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            neighborEvent.eventType = 1;
            neighborEvent.typeStr = TENEListUtils.getString("alarmType" + neighborEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, neighborEvent);
        }
    }
}

