/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEMpNProtectionSwitchEventNoticeHandler
implements NoticeHandler {
    public void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 18528) {
            this.interpretMpNSwitchEvent(cmdKey, neID, oper);
        }
    }

    private void interpretMpNSwitchEvent(int cmdKey, int neID, Operation oper) {
        int groupID = 0;
        int srcSlotID = 0;
        int dstSlotID = 0;
        int len = oper.getOutput().length;
        for (int i = 0; i < len; ++i) {
            for (Part part : oper.getOutput()[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("groupID")) {
                    groupID = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("srcSlotID")) {
                    srcSlotID = Integer.parseInt(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("dstSlotID")) continue;
                dstSlotID = Integer.parseInt(value);
            }
        }
        TEAbNormalEvent mpnSwitchEvent = new TEAbNormalEvent();
        mpnSwitchEvent.eventID = cmdKey;
        mpnSwitchEvent.eventName = TENEListUtils.getString("mpnswitch");
        StringBuffer description = new StringBuffer();
        description.append(TENEListUtils.getString("protection_group_id"));
        description.append(groupID).append(',');
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neID, srcSlotID);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, bdtype);
        description.append(TENEListUtils.getString("srcBoard")).append(TEBoardUtil.getSlotIDFromSlot(neID, srcSlotID)).append("-").append(boardname).append(',');
        bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neID, dstSlotID);
        boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, bdtype);
        description.append(TENEListUtils.getString("dstBoard")).append(TEBoardUtil.getSlotIDFromSlot(neID, dstSlotID)).append("-").append(boardname);
        mpnSwitchEvent.comment = description.toString();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        mpnSwitchEvent.timeStr = startTime;
        mpnSwitchEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        mpnSwitchEvent.objStr = ne.getNEName();
        mpnSwitchEvent.nodeType = ne.getNEType();
        mpnSwitchEvent.severityLevel = 2;
        mpnSwitchEvent.severityStr = TENEListUtils.getString(String.valueOf(mpnSwitchEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        mpnSwitchEvent.eventType = 1;
        mpnSwitchEvent.typeStr = TENEListUtils.getString("alarmType" + mpnSwitchEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, mpnSwitchEvent);
    }
}

