/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEMSSPRSwitchEventNoticeHandler
implements NoticeHandler {
    private static final int NSEVT_MSSP_SW = 16388;
    private static final int NSEVT_CFG_MSSPR_EXTREQ_UNEXE_02 = 16387;

    public synchronized void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 16388) {
            this.eventinterpretEvent(cmdKey, neID, oper);
        } else if (cmdKey == 16387) {
            this.eventinterpretEventEXTREQUNEXE2(cmdKey, neID, oper);
        }
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper) {
        int groupID = 0;
        StringBuffer des = new StringBuffer(50);
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            groupID = Integer.parseInt(outputArr[i].getPart(0).getValue());
            int wStatus = Integer.parseInt(outputArr[i].getPart(2).getValue());
            int wFlag = Integer.parseInt(outputArr[i].getPart(3).getValue());
            int eStatus = Integer.parseInt(outputArr[i].getPart(5).getValue());
            int eFlag = Integer.parseInt(outputArr[i].getPart(6).getValue());
            TEAbNormalEvent msspSwitchEvent = new TEAbNormalEvent();
            msspSwitchEvent.eventID = cmdKey;
            String DOT_FLAG = TENEListUtils.getString("DOT_FLAG");
            des.append(TENEListUtils.getString("mssp_group_id"));
            des.append(groupID).append(DOT_FLAG);
            des.append(TENEListUtils.getString("mssp_west_status"));
            des.append(TENEListUtils.getString("mssp_status_" + wStatus)).append(DOT_FLAG);
            des.append(TENEListUtils.getString("mssp_east_status"));
            des.append(TENEListUtils.getString("mssp_status_" + eStatus)).append(DOT_FLAG);
            des.append(TENEListUtils.getString("mssp_west_flag"));
            des.append(TENEListUtils.getString("mssp_flag_" + wFlag)).append(DOT_FLAG);
            des.append(TENEListUtils.getString("mssp_east_flag"));
            des.append(TENEListUtils.getString("mssp_flag_" + eFlag));
            msspSwitchEvent.comment = des.toString();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            msspSwitchEvent.timeStr = startTime;
            msspSwitchEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            msspSwitchEvent.objStr = ne.getNEName();
            msspSwitchEvent.nodeType = ne.getNEType();
            msspSwitchEvent.eventName = TENEListUtils.getString("mssp_name");
            msspSwitchEvent.severityLevel = 2;
            msspSwitchEvent.severityStr = TENEListUtils.getString(String.valueOf(msspSwitchEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            msspSwitchEvent.eventType = 1;
            msspSwitchEvent.typeStr = TENEListUtils.getString("alarmType" + msspSwitchEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, msspSwitchEvent);
        }
    }

    private void eventinterpretEventEXTREQUNEXE2(int cmdKey, int neID, Operation oper) {
        int groupID = 0;
        int swdir = 0;
        int swreq = 0;
        StringBuffer des = new StringBuffer(50);
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            groupID = Integer.parseInt(outputArr[i].getPart(0).getValue());
            swdir = Integer.parseInt(outputArr[i].getPart(1).getValue());
            swreq = Integer.parseInt(outputArr[i].getPart(2).getValue());
            TEAbNormalEvent msspSwitchEvent = new TEAbNormalEvent();
            msspSwitchEvent.eventID = cmdKey;
            String DOT_FLAG = TENEListUtils.getString("DOT_FLAG");
            des.append(TENEListUtils.getString("mssp_group_id"));
            des.append(groupID).append(DOT_FLAG);
            des.append(TENEListUtils.getString("mssp_extreq_dir"));
            des.append(TENEListUtils.getString("mssp_extreq_dir_" + swdir)).append(DOT_FLAG);
            des.append(TENEListUtils.getString("mssp_extreq_type"));
            des.append(TENEListUtils.getString("mssp_extreq_" + swreq));
            msspSwitchEvent.comment = des.toString();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            msspSwitchEvent.timeStr = startTime;
            msspSwitchEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            msspSwitchEvent.objStr = ne.getNEName();
            msspSwitchEvent.nodeType = ne.getNEType();
            msspSwitchEvent.eventName = TENEListUtils.getString("mssp_extreq");
            msspSwitchEvent.severityLevel = 2;
            msspSwitchEvent.severityStr = TENEListUtils.getString(String.valueOf(msspSwitchEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            msspSwitchEvent.eventType = 1;
            msspSwitchEvent.typeStr = TENEListUtils.getString("alarmType" + msspSwitchEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, msspSwitchEvent);
        }
    }
}

