/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.ip.TEEthBindXc;
import com.huawei.nglct.nelist.model.ip.TEIPDescription;
import com.huawei.nglct.nelist.model.ip.TEIpModel;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class TELCASEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation oper) {
        this.eventinterpretEvent(cmdKey, neID, oper);
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper) {
        int slotid = 0;
        int boardtype = 0;
        int vctrunkID = 0;
        int direction = 0;
        int level = 0;
        List pathList = null;
        String boardName = "";
        int portid = 0;
        TEAbNormalEvent lcasEvent = null;
        StringBuffer des = new StringBuffer(30);
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            slotid = Integer.parseInt(outputArr[i].getPart(0).getValue());
            vctrunkID = Integer.parseInt(outputArr[i].getPart(1).getValue());
            direction = Integer.parseInt(outputArr[i].getPart(2).getValue());
            level = Integer.parseInt(outputArr[i].getPart(3).getValue());
            lcasEvent = new TEAbNormalEvent();
            lcasEvent.eventID = cmdKey;
            boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotid);
            boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardtype);
            portid = vctrunkID - 32768;
            des.append("VCTRUNCK").append(portid).append(TENEListUtils.getString("DOT_FLAG"));
            des.append(TENEListUtils.getString("DIRECTION_" + direction)).append(TENEListUtils.getString("DOT_FLAG"));
            pathList = this.handlePathList(outputArr[i].getPart(5).getValue());
            des.append(this.getVCLevelStr(neID, slotid, level, pathList));
            lcasEvent.comment = des.toString();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            lcasEvent.timeStr = startTime;
            lcasEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            lcasEvent.objStr = ne.getNEName() + "-" + slotid + "-" + boardName;
            lcasEvent.nodeType = ne.getNEType();
            lcasEvent.eventName = TENEListUtils.getString("LCAS_EVENT_" + cmdKey);
            lcasEvent.severityLevel = 4;
            lcasEvent.severityStr = TENEListUtils.getString(String.valueOf(lcasEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            lcasEvent.eventType = 1;
            lcasEvent.typeStr = TENEListUtils.getString("alarmType" + lcasEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, lcasEvent);
        }
    }

    private List handlePathList(String pathListStr) {
        ArrayList<Integer> pathList = new ArrayList<Integer>();
        byte[] pathListBytes = IOStreamConvertor.getByteArrayFromString(pathListStr);
        for (int pathIndex = 0; pathIndex < pathListBytes.length; pathIndex += 2) {
            byte[] pathBytes = new byte[2];
            System.arraycopy(pathListBytes, pathIndex, pathBytes, 0, 2);
            pathList.add(IOStreamConvertor.readUnsignedShort(pathBytes, 0));
        }
        return pathList;
    }

    private List createBindXcList(int neid, int slotID) {
        ArrayList bindXcList = null;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        TEBoard boardObj = null;
        TEIpModel getIpModel = null;
        if (null != neObj && slotID >= 1 && null != (boardObj = neObj.getBoard(slotID)) && null != (getIpModel = TEIPDescription.getInstance().getIPModel(boardObj.getBoardType())) && null != getIpModel.getEthVctrunkRes() && null != getIpModel.getEthVctrunkRes().getBindXcList()) {
            bindXcList = getIpModel.getEthVctrunkRes().getBindXcList();
        }
        return bindXcList;
    }

    private String getVCLevelStr(int neid, int slotid, int level, List pathList) {
        List bindXcList = this.createBindXcList(neid, slotid);
        TEEthBindXc bindXc = null;
        StringBuffer vcLevelStr = new StringBuffer();
        if (null != bindXcList) {
            int len = bindXcList.size();
            for (int i = 0; i < len; ++i) {
                bindXc = (TEEthBindXc)bindXcList.get(i);
                int serverNolen = bindXc.getBindXcServerNO().size();
                if (level != bindXc.getVcLever()) continue;
                if (1 == serverNolen) {
                    vcLevelStr.append("VC4-").append(bindXc.getBindXcServerNO().get(0)).append('-').append(bindXc.getBindXcname()).append(this.getPathListStr(pathList));
                    break;
                }
                int maxPerTrunk = bindXc.getMaxPerTrunk() / serverNolen;
                for (int j = 0; j < serverNolen; ++j) {
                    int maxTrunkServeNo = maxPerTrunk * j + maxPerTrunk;
                    ArrayList rowPaths = new ArrayList();
                    for (int m = pathList.size() - 1; m >= 0 && (Integer)pathList.get(m) <= maxTrunkServeNo; --m) {
                        rowPaths.add(pathList.remove(m));
                    }
                    if (rowPaths.isEmpty()) continue;
                    if (vcLevelStr.length() != 0) {
                        vcLevelStr.append(TENEListUtils.getString("DOT_FLAG"));
                    }
                    vcLevelStr.append("VC4-").append(bindXc.getBindXcServerNO().get(0)).append('-').append(bindXc.getBindXcname()).append(this.getPathListStr(rowPaths));
                }
                break;
            }
        }
        return vcLevelStr.toString();
    }

    private String getPathListStr(List pathList) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = pathList.size() - 1; i >= 0; --i) {
            buf.append(((Integer)pathList.get(i)).toString());
            if (i == 0) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }
}

