/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEIPAEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation operation) {
        switch (cmdKey) {
            case 28550: {
                this.interpretQx5APREvent(cmdKey, neID, operation);
                break;
            }
        }
    }

    private void interpretQx5APREvent(int cmdKey, int neID, Operation operation) {
        int aprEventNo = -1;
        int aprIndex = -1;
        int detectionBoardNo = -1;
        int detectionPortNo = -1;
        int implementationBoardNo = -1;
        int implementationPortNo = -1;
        int interruptReasonType = -1;
        StringBuffer description = new StringBuffer();
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("aprEventNo")) {
                    aprEventNo = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("aprIndex")) {
                    aprIndex = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("detectionBoardNo")) {
                    detectionBoardNo = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("detectionPortNo")) {
                    detectionPortNo = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("implementationBoardNo")) {
                    implementationBoardNo = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("implementationPortNo")) {
                    implementationPortNo = Integer.parseInt(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("interruptReasonType")) continue;
                interruptReasonType = Integer.parseInt(value);
            }
        }
        TEAbNormalEvent ipaPerformEvent = new TEAbNormalEvent();
        ipaPerformEvent.eventID = 55;
        ipaPerformEvent.eventName = TENEListUtils.getString(String.valueOf(ipaPerformEvent.eventID));
        String pairInfo = TENEListUtils.getString("APR_PAIR_INFO");
        pairInfo = pairInfo.replaceFirst("%s", String.valueOf(aprIndex));
        pairInfo = pairInfo.replaceFirst("%s", String.valueOf(detectionBoardNo));
        pairInfo = pairInfo.replaceFirst("%s", String.valueOf(detectionPortNo));
        pairInfo = pairInfo.replaceFirst("%s", String.valueOf(implementationBoardNo));
        ipaPerformEvent.objStr = pairInfo = pairInfo.replaceFirst("%s", String.valueOf(implementationPortNo));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        ipaPerformEvent.nodeType = ne.getNEType();
        description.append(pairInfo);
        String aprStateStr = "APR_STATE";
        aprStateStr = aprStateStr + aprEventNo;
        aprStateStr = TENEListUtils.getString(aprStateStr);
        description.append(TENEListUtils.getString(aprStateStr));
        String reasonStr = "ARP_ABNORMAL";
        reasonStr = reasonStr + interruptReasonType;
        description.append(TENEListUtils.getString(reasonStr));
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        ipaPerformEvent.timeStr = startTime;
        ipaPerformEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        ipaPerformEvent.severityLevel = 2;
        ipaPerformEvent.severityStr = TENEListUtils.getString(String.valueOf(ipaPerformEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        ipaPerformEvent.eventType = 1;
        ipaPerformEvent.typeStr = TENEListUtils.getString("alarmType" + ipaPerformEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        ipaPerformEvent.comment = description.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, ipaPerformEvent);
    }
}

