/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.eventinterpret.TEEventDataConstants;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEEthWorkModeChangeEvent {
    private static final TEEthWorkModeChangeEvent INSTANCE = new TEEthWorkModeChangeEvent();
    private Operation oper = null;
    private TEEthWorkModeChangeNoticeHandler handler = new TEEthWorkModeChangeNoticeHandler();

    private TEEthWorkModeChangeEvent() {
    }

    public void register() {
        this.oper = TECreateObjectFactory.getOperation(TEEventDataConstants.QX_DES_PATH_MAIN, "NSEVT_CFG_ITG_ETHWORKMODE_CHANGE");
        TENECommMgr.getInstance().registerListener(this.oper, (NoticeHandler)this.handler);
    }

    public void unregister() {
        this.oper = TECreateObjectFactory.getOperation(TEEventDataConstants.QX_DES_PATH_MAIN, "NSEVT_CFG_ITG_ETHWORKMODE_CHANGE");
        TENECommMgr.getInstance().unregisterListener(this.oper, (NoticeHandler)this.handler);
    }

    public static TEEthWorkModeChangeEvent getInstance() {
        return INSTANCE;
    }

    public void eventinterpretEvent(int cmdKey, int neID, Operation operation) {
        int slotid = -1;
        int portid = -1;
        int pathid = -1;
        int workMode = -1;
        StringBuffer des = new StringBuffer();
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if ("slotid".equalsIgnoreCase(name)) {
                    slotid = Integer.parseInt(value);
                }
                if ("portid".equalsIgnoreCase(name)) {
                    portid = Integer.parseInt(value);
                }
                if ("pathid".equalsIgnoreCase(name)) {
                    pathid = Integer.parseInt(value);
                }
                if (!"workMode".equalsIgnoreCase(name)) continue;
                workMode = Integer.parseInt(value);
            }
        }
        String boardName = TEConfigurationDataMgr.getInstance().getBoard(neID, slotid).getBoardName();
        des.append(slotid).append('-').append(boardName).append('-').append(portid).append('-').append(pathid).append(',');
        des.append(TENEListUtils.getString("workMode"));
        des.append(TENEListUtils.getString("workMode_" + workMode));
        TEAbNormalEvent portChangeEvent = new TEAbNormalEvent();
        if (cmdKey == 16590) {
            portChangeEvent.eventID = cmdKey;
            portChangeEvent.eventName = TENEListUtils.getString(String.valueOf(portChangeEvent.eventID));
        }
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        portChangeEvent.timeStr = startTime;
        portChangeEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        portChangeEvent.objStr = ne.getNEName();
        portChangeEvent.nodeType = ne.getNEType();
        portChangeEvent.severityLevel = 1;
        portChangeEvent.severityStr = TENEListUtils.getString(String.valueOf(portChangeEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        portChangeEvent.eventType = 3;
        portChangeEvent.typeStr = TENEListUtils.getString("alarmType" + portChangeEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        portChangeEvent.comment = des.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, portChangeEvent);
    }

    private class TEEthWorkModeChangeNoticeHandler
    implements NoticeHandler {
        private TEEthWorkModeChangeNoticeHandler() {
        }

        public void handleNotice(int cmdKey, int neID, Operation oper) {
            if (cmdKey == 16590) {
                TEEthWorkModeChangeEvent.this.eventinterpretEvent(cmdKey, neID, oper);
            }
        }
    }
}

