/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.eventinterpret.TEEthOAMEventUtils;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEEthServiceOAMAbnormalEventNoticeHandler
implements NoticeHandler {
    private static final int DOUBLE = 0;
    private static final int INGRESS = 1;
    private static final int EGRESS = 2;
    private static final int MP_LEVEL_0 = 0;
    private static final int MP_LEVEL_1 = 1;
    private static final int MP_LEVEL_2 = 2;
    private static final int MP_LEVEL_3 = 3;
    private static final int MP_LEVEL_4 = 4;
    private static final int MP_LEVEL_5 = 5;
    private static final int MP_LEVEL_6 = 6;
    private static final int MP_LEVEL_7 = 7;
    private static final int VCTRUNK_BASE_NUM = 32768;

    public void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 16400 || cmdKey == 16552) {
            this.interpretOAMCCLostEvent(cmdKey, neID, oper);
        }
        if (cmdKey == 16401 || cmdKey == 16553) {
            this.interpretOAMMpConflictEvent(cmdKey, neID, oper);
        }
        if (cmdKey == 16450 || cmdKey == 16515 || cmdKey == 16622) {
            this.interpretOAMServiceLoopEvent(cmdKey, neID, oper);
        }
    }

    private void interpretOAMCCLostEvent(int cmdKey, int neID, Operation oper) {
        int slotid = 0;
        int portid = 0;
        String srcmpid = "";
        int vlanid = 0;
        int level = 0;
        int direction = 0;
        String snkmpid = "";
        Output[] outputArry = oper.getOutput();
        int len = outputArry.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArry[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("slotid")) {
                    slotid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("port")) {
                    portid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("srcmpid")) {
                    srcmpid = value;
                }
                if (name.equalsIgnoreCase("vlanid")) {
                    vlanid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("level")) {
                    level = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("direction")) {
                    direction = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("snkmpid")) continue;
                snkmpid = value;
            }
        }
        if (!TEEthOAMEventUtils.getInstance().isStandardOAM(neID, slotid, srcmpid)) {
            level = 7 - level;
        }
        TEAbNormalEvent ccLostEvent = new TEAbNormalEvent();
        ccLostEvent.eventID = 10771;
        ccLostEvent.eventName = TENEListUtils.getString(String.valueOf(ccLostEvent.eventID));
        StringBuffer description = new StringBuffer();
        description.append(TENEListUtils.getString("node")).append(':');
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int boardType = mgr.getBoardType(neID, slotid);
        String boardName = mgr.getBoardTypeName(neID, boardType);
        String portName = mgr.getPortName(neID, slotid, boardType, portid);
        description.append(slotid).append('-').append(boardName).append('-').append(portName).append(',');
        description.append(TENEListUtils.getString("srcmpid")).append(this.refactorMPID(srcmpid)).append(',');
        if (vlanid == 65535) {
            description.append(TENEListUtils.getString("vlanid")).append("/,");
        } else {
            description.append(TENEListUtils.getString("vlanid")).append(vlanid).append(',');
        }
        description.append(TENEListUtils.getString("level"));
        String levelStr = "";
        switch (level) {
            case 0: {
                levelStr = TENEListUtils.getString("level0");
                break;
            }
            case 1: {
                levelStr = TENEListUtils.getString("level1");
                break;
            }
            case 2: {
                levelStr = TENEListUtils.getString("level2");
                break;
            }
            case 3: {
                levelStr = TENEListUtils.getString("level3");
                break;
            }
            case 4: {
                levelStr = TENEListUtils.getString("level4");
                break;
            }
            case 5: {
                levelStr = TENEListUtils.getString("level5");
                break;
            }
            case 6: {
                levelStr = TENEListUtils.getString("level6");
                break;
            }
            case 7: {
                levelStr = TENEListUtils.getString("level7");
                break;
            }
        }
        description.append(levelStr).append(',');
        description.append(TENEListUtils.getString("direction")).append(':');
        if (0 == direction) {
            description.append(TENEListUtils.getString("doubledirection")).append(',');
        } else if (1 == direction) {
            if (portid < 32768) {
                description.append(TENEListUtils.getString("wdmdirection")).append(',');
            } else {
                description.append(TENEListUtils.getString("ipdirection")).append(',');
            }
        } else if (2 == direction) {
            if (portid < 32768) {
                description.append(TENEListUtils.getString("ipdirection")).append(',');
            } else {
                description.append(TENEListUtils.getString("wdmdirection")).append(',');
            }
        }
        description.append(TENEListUtils.getString("snkmpid")).append(this.refactorMPID(snkmpid)).append(',');
        ccLostEvent.comment = description.toString();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        ccLostEvent.timeStr = startTime;
        ccLostEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        ccLostEvent.objStr = ne.getNEName();
        ccLostEvent.nodeType = ne.getNEType();
        ccLostEvent.severityLevel = 1;
        ccLostEvent.severityStr = TENEListUtils.getString(String.valueOf(ccLostEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        ccLostEvent.eventType = 3;
        ccLostEvent.typeStr = TENEListUtils.getString("alarmType" + ccLostEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        ccLostEvent.eventName = TENEListUtils.getString(String.valueOf(ccLostEvent.eventID));
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, ccLostEvent);
    }

    private void interpretOAMMpConflictEvent(int cmdKey, int neID, Operation oper) {
        int slotid = 0;
        int portid = 0;
        String mpid = "";
        int vlanid = 0;
        int level = 0;
        int direction = 0;
        Output[] outputArry = oper.getOutput();
        String name = null;
        String value = null;
        Part part2 = null;
        int len = outputArry.length;
        for (int i = 0; i < len; ++i) {
            for (Part part2 : outputArry[i].getPart()) {
                name = part2.getName();
                value = part2.getValue();
                if (name.equalsIgnoreCase("slotid")) {
                    slotid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("port")) {
                    portid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("mpid")) {
                    mpid = value;
                }
                if (name.equalsIgnoreCase("vlanid")) {
                    vlanid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("level")) {
                    level = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("direction")) continue;
                direction = Integer.parseInt(value);
            }
        }
        if (!TEEthOAMEventUtils.getInstance().isStandardOAM(neID, slotid, mpid)) {
            level = 7 - level;
        }
        TEAbNormalEvent ccLostEvent = new TEAbNormalEvent();
        ccLostEvent.eventID = 10772;
        ccLostEvent.eventName = TENEListUtils.getString(String.valueOf(ccLostEvent.eventID));
        StringBuffer description = new StringBuffer();
        description.append(TENEListUtils.getString("node")).append(':');
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int boardType = mgr.getBoardType(neID, slotid);
        String boardName = mgr.getBoardTypeName(neID, boardType);
        String portName = mgr.getPortName(neID, slotid, boardType, portid);
        description.append(slotid).append('-').append(boardName).append('-').append(portName).append(',');
        description.append(TENEListUtils.getString("mpid")).append(this.refactorMPID(mpid)).append(',');
        if (vlanid == 65535) {
            description.append(TENEListUtils.getString("vlanid")).append("/,");
        } else {
            description.append(TENEListUtils.getString("vlanid")).append(vlanid).append(',');
        }
        description.append(TENEListUtils.getString("level"));
        String levelStr = "";
        switch (level) {
            case 0: {
                levelStr = TENEListUtils.getString("level0");
                break;
            }
            case 1: {
                levelStr = TENEListUtils.getString("level1");
                break;
            }
            case 2: {
                levelStr = TENEListUtils.getString("level2");
                break;
            }
            case 3: {
                levelStr = TENEListUtils.getString("level3");
                break;
            }
            case 4: {
                levelStr = TENEListUtils.getString("level4");
                break;
            }
            case 5: {
                levelStr = TENEListUtils.getString("level5");
                break;
            }
            case 6: {
                levelStr = TENEListUtils.getString("level6");
                break;
            }
            case 7: {
                levelStr = TENEListUtils.getString("level7");
                break;
            }
        }
        description.append(levelStr).append(',');
        description.append(TENEListUtils.getString("direction")).append(':');
        if (0 == direction) {
            description.append(TENEListUtils.getString("doubledirection")).append(',');
        } else if (1 == direction) {
            if (portid < 32768) {
                description.append(TENEListUtils.getString("wdmdirection")).append(',');
            } else {
                description.append(TENEListUtils.getString("ipdirection")).append(',');
            }
        } else if (2 == direction) {
            if (portid < 32768) {
                description.append(TENEListUtils.getString("ipdirection")).append(',');
            } else {
                description.append(TENEListUtils.getString("wdmdirection")).append(',');
            }
        }
        ccLostEvent.comment = description.toString();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        ccLostEvent.timeStr = startTime;
        ccLostEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        ccLostEvent.objStr = ne.getNEName();
        ccLostEvent.nodeType = ne.getNEType();
        ccLostEvent.severityLevel = 1;
        ccLostEvent.severityStr = TENEListUtils.getString(String.valueOf(ccLostEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        ccLostEvent.eventType = 3;
        ccLostEvent.typeStr = TENEListUtils.getString("alarmType" + ccLostEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        ccLostEvent.eventName = TENEListUtils.getString(String.valueOf(ccLostEvent.eventID));
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, ccLostEvent);
    }

    private void interpretOAMServiceLoopEvent(int cmdKey, int neID, Operation oper) {
        int slotid = 0;
        int portid = 0;
        String mpid = "";
        int vlanid = 0;
        int level = 0;
        int direction = 0;
        Output[] outputArry = oper.getOutput();
        int len = outputArry.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArry[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("slotid")) {
                    slotid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("portid")) {
                    portid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("mpid")) {
                    mpid = value;
                }
                if (name.equalsIgnoreCase("vlanid")) {
                    vlanid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("level")) {
                    level = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("direction")) continue;
                direction = Integer.parseInt(value);
            }
        }
        if (!TEEthOAMEventUtils.getInstance().isStandardOAM(neID, slotid, mpid)) {
            level = 7 - level;
        }
        TEAbNormalEvent ccLostEvent = new TEAbNormalEvent();
        ccLostEvent.eventID = 16450;
        ccLostEvent.eventName = TENEListUtils.getString(String.valueOf(ccLostEvent.eventID));
        StringBuffer descriptionLoop = new StringBuffer();
        descriptionLoop.append(TENEListUtils.getString("node")).append(':');
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int boardType = mgr.getBoardType(neID, slotid);
        String boardName = mgr.getBoardTypeName(neID, boardType);
        String portName = mgr.getPortName(neID, slotid, boardType, portid);
        descriptionLoop.append(slotid).append('-').append(boardName).append('-').append(portName).append(',');
        descriptionLoop.append(TENEListUtils.getString("mpid")).append(this.refactorMPID(mpid)).append(',');
        if (vlanid == 65535) {
            descriptionLoop.append(TENEListUtils.getString("vlanid")).append("/,");
        } else {
            descriptionLoop.append(TENEListUtils.getString("vlanid")).append(vlanid).append(',');
        }
        descriptionLoop.append(TENEListUtils.getString("level"));
        String levelLoopStr = "";
        switch (level) {
            case 0: {
                levelLoopStr = TENEListUtils.getString("level0");
                break;
            }
            case 1: {
                levelLoopStr = TENEListUtils.getString("level1");
                break;
            }
            case 2: {
                levelLoopStr = TENEListUtils.getString("level2");
                break;
            }
            case 3: {
                levelLoopStr = TENEListUtils.getString("level3");
                break;
            }
            case 4: {
                levelLoopStr = TENEListUtils.getString("level4");
                break;
            }
            case 5: {
                levelLoopStr = TENEListUtils.getString("level5");
                break;
            }
            case 6: {
                levelLoopStr = TENEListUtils.getString("level6");
                break;
            }
            case 7: {
                levelLoopStr = TENEListUtils.getString("level7");
                break;
            }
        }
        descriptionLoop.append(levelLoopStr).append(',');
        descriptionLoop.append(TENEListUtils.getString("direction")).append(':');
        if (0 == direction) {
            descriptionLoop.append(TENEListUtils.getString("doubledirection")).append(',');
        } else if (1 == direction) {
            if (portid < 32768) {
                descriptionLoop.append(TENEListUtils.getString("wdmdirection")).append(',');
            } else {
                descriptionLoop.append(TENEListUtils.getString("ipdirection")).append(',');
            }
        } else if (2 == direction) {
            if (portid < 32768) {
                descriptionLoop.append(TENEListUtils.getString("ipdirection")).append(',');
            } else {
                descriptionLoop.append(TENEListUtils.getString("wdmdirection")).append(',');
            }
        }
        ccLostEvent.comment = descriptionLoop.toString();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        ccLostEvent.timeStr = startTime;
        ccLostEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        ccLostEvent.objStr = ne.getNEName();
        ccLostEvent.nodeType = ne.getNEType();
        ccLostEvent.severityLevel = 1;
        ccLostEvent.severityStr = TENEListUtils.getString(String.valueOf(ccLostEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        ccLostEvent.eventType = 3;
        ccLostEvent.typeStr = TENEListUtils.getString("alarmType" + ccLostEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        ccLostEvent.eventName = TENEListUtils.getString(String.valueOf(ccLostEvent.eventID));
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, ccLostEvent);
    }

    private String refactorMPID(String mpid) {
        StringBuffer sb = new StringBuffer(15);
        sb.append(mpid.substring(0, 2)).append('-').append(mpid.substring(2, 4)).append('-').append(mpid.substring(4));
        return sb.toString();
    }
}

