/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEELPSPortStaCHGEventNoticeHandler
implements NoticeHandler {
    public void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 18523 || cmdKey == 39732) {
            this.eventinterpretEvent(cmdKey, neID, oper);
        }
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper) {
        StringBuffer des = new StringBuffer(100);
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            String groupstatus = outputArr[i].getPartValue("groupstatus");
            String switchstatus = outputArr[i].getPartValue("switchstatus");
            String wstatus = outputArr[i].getPartValue("wstatus");
            String pstatus = outputArr[i].getPartValue("pstatus");
            if (null != outputArr[i].getPart("slotid")) {
                des.append(TENEListUtils.getString("solt")).append(':');
                int slotid = Integer.parseInt(outputArr[i].getPartValue("slotid"));
                des.append(TEBoardUtil.getSubrackNameFromSlot(neID, slotid)).append("-");
                des.append(TEBoardUtil.getSlotIDFromSlot(neID, slotid)).append("-");
                des.append(TEConfigurationDataMgr.getInstance().getBoardName(neID, slotid));
                des.append(',');
            }
            des.append(TENEListUtils.getString("ELPS_ID")).append(':');
            des.append(outputArr[i].getPartValue("groupid")).append(',');
            des.append(TENEListUtils.getString("ELPS_GROUP_STATUS")).append(':');
            des.append(TENEListUtils.getString("ELPS_GROUP_STATUS_" + groupstatus)).append(',');
            des.append(TENEListUtils.getString("ELPS_SWITCH_STATUS")).append(':');
            des.append(TENEListUtils.getString("ELPS_SWITCH_STATUS_" + switchstatus)).append(',');
            des.append(TENEListUtils.getString("WORK_STATUS")).append(':');
            des.append(TENEListUtils.getString("ELPS_UNIT_STATUS_" + wstatus)).append(',');
            des.append(TENEListUtils.getString("PROTECT_STATUS")).append(':');
            des.append(TENEListUtils.getString("ELPS_UNIT_STATUS_" + pstatus)).append(',');
            this.appendEventToList(cmdKey, neID, des.toString());
        }
    }

    private void appendEventToList(int cmdKey, int neID, String comment) {
        TEAbNormalEvent elpsStateChangeEvent = new TEAbNormalEvent();
        elpsStateChangeEvent.eventID = cmdKey;
        elpsStateChangeEvent.comment = comment;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        elpsStateChangeEvent.timeStr = startTime;
        elpsStateChangeEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        elpsStateChangeEvent.objStr = ne.getNEName();
        elpsStateChangeEvent.nodeType = ne.getNEType();
        elpsStateChangeEvent.eventName = TENEListUtils.getString("EVENT_18523");
        elpsStateChangeEvent.severityLevel = 2;
        elpsStateChangeEvent.severityStr = TENEListUtils.getString(String.valueOf(elpsStateChangeEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        elpsStateChangeEvent.eventType = 3;
        elpsStateChangeEvent.typeStr = TENEListUtils.getString("alarmType" + elpsStateChangeEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, elpsStateChangeEvent);
    }
}

