/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEDLAGEventNoticeHandler
implements NoticeHandler {
    public static final int VCTRUNK = 32768;

    public void handleNotice(int cmdKey, int neID, Operation oper) {
        if (cmdKey == 16404 || cmdKey == 16563) {
            this.eventinterpretEvent(cmdKey, neID, oper);
        }
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation oper) {
        int dlagid = 0;
        int wslotId = 0;
        String wboardName = "";
        int wportId = 0;
        String wportName = "";
        int pslotId = 0;
        String pboardName = "";
        int pportId = 0;
        String pportName = "";
        TEAbNormalEvent dlagEvent = null;
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        StringBuffer des = new StringBuffer(50);
        Output[] outputArr = oper.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            dlagid = Integer.parseInt(outputArr[i].getPart("dlagid").getValue());
            wslotId = Integer.parseInt(outputArr[i].getPart("wslotid").getValue());
            wboardName = mgr.getBoardTypeName(neID, mgr.getBoardType(neID, wslotId));
            wportId = Integer.parseInt(outputArr[i].getPart("wportid").getValue());
            wportName = this.getPortName(wportId);
            pslotId = Integer.parseInt(outputArr[i].getPart("pslotid").getValue());
            pboardName = mgr.getBoardTypeName(neID, mgr.getBoardType(neID, pslotId));
            pportId = Integer.parseInt(outputArr[i].getPart("pportid").getValue());
            pportName = this.getPortName(pportId);
            dlagEvent = new TEAbNormalEvent();
            dlagEvent.eventID = 16404;
            des.append(TENEListUtils.getString("DLAGID")).append(':');
            des.append(dlagid);
            des.append(',').append(TENEListUtils.getString("WORK_PORT")).append(':');
            des.append(wslotId).append('-').append(wboardName);
            des.append('-').append(wportName);
            des.append(',').append(TENEListUtils.getString("BACK_PORT")).append(':');
            des.append(pslotId).append('-').append(pboardName);
            des.append('-').append(pportName);
            dlagEvent.comment = des.toString();
            GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            dlagEvent.timeStr = startTime;
            dlagEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dlagEvent.objStr = ne.getNEName();
            dlagEvent.nodeType = ne.getNEType();
            dlagEvent.eventName = TENEListUtils.getString("DLAG_EVENT_" + cmdKey);
            dlagEvent.severityLevel = 1;
            dlagEvent.severityStr = TENEListUtils.getString(String.valueOf(dlagEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
            dlagEvent.eventType = 3;
            dlagEvent.typeStr = TENEListUtils.getString("alarmType" + dlagEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
            TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, dlagEvent);
        }
    }

    private String getPortName(int portId) {
        if (portId < 32768) {
            return TEConfigurationDataMgr.getMACName(portId);
        }
        return TEConfigurationDataMgr.getVCTrunkName(portId);
    }
}

