/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEDBMSAbNormalEventNoticeHandler
implements NoticeHandler {
    private TENE ne = null;

    public void handleNotice(int cmdKey, int neID, Operation operation) {
        switch (cmdKey) {
            case 28451: {
                this.interpretDBDelEvent(cmdKey, neID, operation);
                break;
            }
            case 28449: {
                this.interpretDBProtectEvent(cmdKey, neID, operation);
                break;
            }
            case 28450: {
                this.interpretDBFailEvent(cmdKey, neID, operation);
                break;
            }
        }
    }

    private void interpretDBDelEvent(int cmdKey, int neID, Operation operation) {
        int eventID = 38;
        StringBuffer descriptionStr = new StringBuffer();
        String dbDelStr = TENEListUtils.getString("DB_DEL_DESCRIPTION");
        descriptionStr.append(dbDelStr);
        TEAbNormalEvent dbDelEvent = new TEAbNormalEvent();
        dbDelEvent.eventID = eventID;
        dbDelEvent.eventName = TENEListUtils.getString(String.valueOf(dbDelEvent.eventID));
        this.ne = TENEListMgr.getInstance().getNE(neID);
        dbDelEvent.objStr = this.ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        dbDelEvent.timeStr = startTime;
        dbDelEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        dbDelEvent.severityLevel = 1;
        dbDelEvent.severityStr = TENEListUtils.getString(String.valueOf(dbDelEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        dbDelEvent.eventType = 1;
        dbDelEvent.typeStr = TENEListUtils.getString("alarmType" + dbDelEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        dbDelEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, dbDelEvent);
    }

    private void interpretDBProtectEvent(int cmdKey, int neID, Operation operation) {
        int eventID = 37;
        StringBuffer descriptionStr = new StringBuffer();
        String dbProtectStr = TENEListUtils.getString("DB_PROTECT_DESCRIPTION");
        descriptionStr.append(dbProtectStr);
        TEAbNormalEvent dbProtectEvent = new TEAbNormalEvent();
        dbProtectEvent.eventID = eventID;
        dbProtectEvent.eventName = TENEListUtils.getString(String.valueOf(dbProtectEvent.eventID));
        this.ne = TENEListMgr.getInstance().getNE(neID);
        dbProtectEvent.objStr = this.ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        dbProtectEvent.timeStr = startTime;
        dbProtectEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        dbProtectEvent.severityLevel = 1;
        dbProtectEvent.severityStr = TENEListUtils.getString(String.valueOf(dbProtectEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        dbProtectEvent.eventType = 1;
        dbProtectEvent.typeStr = TENEListUtils.getString("alarmType" + dbProtectEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        dbProtectEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, dbProtectEvent);
    }

    private void interpretDBFailEvent(int cmdKey, int neID, Operation operation) {
        int eventID = 36;
        StringBuffer descriptionStr = new StringBuffer();
        String dbFailStr = TENEListUtils.getString("DB_FAIL_DESCRIPTION");
        descriptionStr.append(dbFailStr);
        TEAbNormalEvent dbFailEvent = new TEAbNormalEvent();
        dbFailEvent.eventID = eventID;
        dbFailEvent.eventName = TENEListUtils.getString(String.valueOf(dbFailEvent.eventID));
        this.ne = TENEListMgr.getInstance().getNE(neID);
        dbFailEvent.objStr = this.ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        dbFailEvent.timeStr = startTime;
        dbFailEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        dbFailEvent.severityLevel = 1;
        dbFailEvent.severityStr = TENEListUtils.getString(String.valueOf(dbFailEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        dbFailEvent.eventType = 1;
        dbFailEvent.typeStr = TENEListUtils.getString("alarmType" + dbFailEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        dbFailEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, dbFailEvent);
    }
}

