/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.eventinterpret.TEEventDataConstants;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TECreditEvent {
    private static final TECreditEvent INSTANCE = new TECreditEvent();
    private Operation oper = null;
    private TECreditNoticeHandler handler = new TECreditNoticeHandler();

    private TECreditEvent() {
    }

    public void register() {
        this.oper = TECreateObjectFactory.getOperation(TEEventDataConstants.QX_DES_PATH_MAIN, "NSEVT_CFG_FCCREDIT_EXHAUST");
        TENECommMgr.getInstance().registerListener(this.oper, (NoticeHandler)this.handler);
    }

    public void unregister() {
        this.oper = TECreateObjectFactory.getOperation(TEEventDataConstants.QX_DES_PATH_MAIN, "NSEVT_CFG_FCCREDIT_EXHAUST");
        TENECommMgr.getInstance().unregisterListener(this.oper, (NoticeHandler)this.handler);
    }

    public static TECreditEvent getInstance() {
        return INSTANCE;
    }

    private void eventinterpretEvent(int cmdKey, int neID, Operation operation) {
        int slotid = -1;
        int portid = -1;
        int pathid = -1;
        StringBuffer des = new StringBuffer();
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("slotid")) {
                    slotid = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("portid")) {
                    portid = Integer.parseInt(value);
                }
                if (!name.equalsIgnoreCase("pathid")) continue;
                pathid = Integer.parseInt(value);
            }
        }
        String boardName = TEConfigurationDataMgr.getInstance().getBoard(neID, slotid).getBoardName();
        des.append(slotid).append('-').append(boardName).append(',');
        des.append(TENEListUtils.getString("portid"));
        des.append(String.valueOf(portid)).append(',');
        des.append(TENEListUtils.getString("pathid"));
        des.append(String.valueOf(pathid)).append(',');
        TEAbNormalEvent creditEvent = new TEAbNormalEvent();
        if (cmdKey == 16520) {
            creditEvent.eventID = cmdKey;
            creditEvent.eventName = TENEListUtils.getString(String.valueOf(creditEvent.eventID));
        }
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        creditEvent.timeStr = startTime;
        creditEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        creditEvent.objStr = ne.getNEName();
        creditEvent.nodeType = ne.getNEType();
        creditEvent.severityLevel = 1;
        creditEvent.severityStr = TENEListUtils.getString(String.valueOf(creditEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        creditEvent.comment = des.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, creditEvent);
    }

    private class TECreditNoticeHandler
    implements NoticeHandler {
        private TECreditNoticeHandler() {
        }

        public void handleNotice(int cmdKey, int neID, Operation oper) {
            if (cmdKey == 16520) {
                TECreditEvent.this.eventinterpretEvent(cmdKey, neID, oper);
            }
        }
    }
}

