/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeMgr;
import com.huawei.nglct.nelist.lpara.TEAlmReturnParamParse;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.performance.TEPfmBsEvent;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.Calendar;

public class TECSESAbNormalEventNoticeHandler
implements NoticeHandler {
    public void handleNotice(int cmdKey, int neID, Operation operation) {
        switch (cmdKey) {
            case 28516: {
                break;
            }
            case 28524: {
                this.interpretLongParamCSESEvent(cmdKey, neID, operation);
                break;
            }
        }
    }

    private void interpretLongParamCSESEvent(int cmdKey, int neID, Operation operation) {
        int slotID = 0;
        int portNo = 0;
        int pathNo = 0;
        int perfID = 0;
        String peTime = "";
        int duration = 0;
        TEPfmMonObjID monObj = null;
        TEAlmObjTypeData almObjTypeObj = null;
        TEAlmObjTypeMgr almObjTypeMgr = new TEAlmObjTypeMgr(neID);
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            perfID = TEPfmUtility.qx5Eid2PfmEid(neID, slotID, Integer.parseInt(outputArr[i].getPartValue("eventid")));
            peTime = outputArr[i].getPartValue("starttime");
            duration = Integer.parseInt(outputArr[i].getPartValue("duration"));
            almObjTypeObj = almObjTypeMgr.getAlmObjTypeData(Integer.valueOf(outputArr[i].getPartValue("objtype")));
            byte[] objByte = outputArr[i].getPartValue("objpara").getBytes();
            if (almObjTypeObj == null) continue;
            monObj = TEAlmReturnParamParse.getInstance().parseObjParam(objByte, almObjTypeObj);
        }
        if (monObj != null) {
            slotID = monObj.getSlotID();
            portNo = monObj.getPortID();
            pathNo = monObj.getPathID();
        }
        this.setCSESEvent(cmdKey, neID, slotID, portNo, pathNo, perfID, peTime, duration);
    }

    private void interpretShortParamCSESEvent(int cmdKey, int neID, Operation operation) {
        int slotID = 0;
        int portNo = 0;
        int pathNo = 0;
        int perfID = 0;
        String peTime = "";
        int duration = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            Part[] partArr = outputArr[i].getPart();
            int len2 = partArr.length;
            for (int j = 0; j < len2; ++j) {
                slotID = Integer.parseInt(outputArr[i].getPartValue("slotid"));
                portNo = Integer.parseInt(outputArr[i].getPartValue("port"));
                pathNo = Integer.parseInt(outputArr[i].getPartValue("pathid"));
                perfID = Integer.parseInt(outputArr[i].getPartValue("eventid"));
                peTime = outputArr[i].getPartValue("starttime");
                duration = Integer.parseInt(outputArr[i].getPartValue("duration"));
            }
        }
        this.setCSESEvent(cmdKey, neID, slotID, portNo, pathNo, perfID, peTime, duration);
    }

    private void setCSESEvent(int cmdKey, int neID, int slotID, int portNo, int pathNo, int perfID, String peTime, int duration) {
        TEAbNormalEvent csesEvent = new TEAbNormalEvent();
        csesEvent.eventID = perfID;
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neID, slotID, perfID);
        csesEvent.eventName = event == null ? TENEListUtils.getString(String.valueOf(csesEvent.eventID)) : event.getPeName();
        StringBuilder description = new StringBuilder();
        String file = "res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
        TEResourceUtil res = TEResourceUtil.getInstance(file);
        if (event == null) {
            description.append(res.getString(String.valueOf(perfID)));
        } else {
            description.append(event.getPeName());
        }
        description.append(TENEListUtils.getString("DOT_FLAG"));
        Calendar startTime = TEDateUtils.byteStrToCalendar(peTime);
        TimeZoneDateBean timeTool = TETimeTocalizationSwitchBean.getTimeZoneDateInstance(neID);
        csesEvent.timeStr = startTime;
        csesEvent.timeRiseStr = timeTool.calendarToTime((Calendar)startTime.clone());
        description.append(TENEListUtils.getString("duration"));
        description.append(TENEListUtils.getString("TE_LOG_SEMICOLON"));
        description.append(duration);
        description.append(TENEListUtils.getString("second"));
        csesEvent.comment = description.toString();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        StringBuilder objstr = new StringBuilder();
        objstr.append(ne.getNEName()).append('-');
        objstr.append(slotID).append("-");
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        objstr.append(boardName);
        objstr.append("-");
        String portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, boardType, portNo);
        objstr.append(portName);
        csesEvent.objStr = objstr.toString();
        csesEvent.nodeType = ne.getNEType();
        csesEvent.severityLevel = 4;
        csesEvent.severityStr = TENEListUtils.getString(String.valueOf(csesEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        csesEvent.eventType = 1;
        csesEvent.typeStr = TENEListUtils.getString("alarmType" + csesEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, csesEvent);
    }
}

