/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEAutoClearEventNoticeHandler
implements NoticeHandler {
    public synchronized void handleNotice(int cmdKey, int neID, Operation operation) {
        switch (cmdKey) {
            case 16635: 
            case 28538: {
                this.interpretAutoClearEvent(cmdKey, neID, operation, cmdKey);
                break;
            }
        }
    }

    private void interpretAutoClearEvent(int cmdkey, int neID, Operation operation, int cmdKey) {
        String boardRes = TENEListUtils.getString("NE_AUTO_RELEASE_boardRes");
        String portRes = TENEListUtils.getString("NE_AUTO_RELEASE_portRes");
        String pathRes = TENEListUtils.getString("NE_AUTO_RELEASE_pathRes");
        int operType = 0;
        int slotID = 0;
        int portID = 0;
        int pathID = 0;
        int boardType = 0;
        StringBuffer description = new StringBuffer();
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("operType")) {
                    operType = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("slotID")) {
                    slotID = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("portID")) {
                    portID = Integer.parseInt(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("pathID")) continue;
                pathID = Integer.parseInt(value);
            }
        }
        TEAbNormalEvent autoClearEvent = new TEAbNormalEvent();
        autoClearEvent.eventID = 53;
        autoClearEvent.eventName = TENEListUtils.getString(String.valueOf(autoClearEvent.eventID));
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        autoClearEvent.objStr = ne.getNEName();
        autoClearEvent.nodeType = ne.getNEType();
        String autoID = "";
        autoID = (autoClearEvent.nodeType == 54 || autoClearEvent.nodeType == 55 || autoClearEvent.nodeType == 60) && operType == 2 ? "NE_AUTO_RELEASE_RTN_ID" + operType : "NE_AUTO_RELEASE_ID" + operType;
        description.append(TENEListUtils.getString(autoID));
        if (slotID > 0) {
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
            boardName = slotID + "-" + boardName;
            description.append(boardRes.replaceFirst("%s", boardName));
            if (portID > 0) {
                String portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, boardType, portID);
                description.append(portRes.replaceFirst("%s", portName));
            }
            if (pathID > 0) {
                description.append(pathRes.replaceFirst("%s", String.valueOf(pathID)));
            }
        }
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        autoClearEvent.timeStr = startTime;
        autoClearEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        autoClearEvent.severityLevel = 3;
        autoClearEvent.severityStr = TENEListUtils.getString(String.valueOf(autoClearEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        autoClearEvent.eventType = 1;
        autoClearEvent.typeStr = TENEListUtils.getString("alarmType" + autoClearEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        int len2 = description.length();
        autoClearEvent.comment = description.toString().substring(0, len2 - 1);
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, autoClearEvent);
    }
}

