/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.eventinterpret;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TEAPEAbNormalEventNoticeHandler
implements NoticeHandler {
    private TENE ne = null;

    public synchronized void handleNotice(int cmdKey, int neID, Operation operation) {
        switch (cmdKey) {
            case 28573: {
                this.interpretUnbalanceEvent(cmdKey, neID, operation);
                break;
            }
            case 28574: {
                this.interpretAddDropWaveEvent(cmdKey, neID, operation);
                break;
            }
            case 28575: {
                this.interpretAdjustFinishEvent(cmdKey, neID, operation);
                break;
            }
            case 28576: {
                this.interpretAdjustFailEvent(cmdKey, neID, operation);
                break;
            }
        }
    }

    private void interpretUnbalanceEvent(int cmdkey, int neID, Operation operation) {
        int apeIndex = 0;
        int pathNo = 0;
        int gnewaveNo = 0;
        StringBuffer descriptionStr = new StringBuffer(50);
        descriptionStr.append(TENEListUtils.getString("APE_EVENT_UNBALANCE")).append(neID);
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("apeIndex")) {
                    apeIndex = Integer.parseInt(value);
                }
                if (!"pathNo".equals(name)) continue;
                pathNo = Integer.parseInt(value);
            }
            gnewaveNo = this.getGneWaveNo(neID, pathNo);
        }
        descriptionStr.append(TENEListUtils.getString("APE_EVENT_APEPAIR")).append(apeIndex);
        descriptionStr.append(TENEListUtils.getString("APE_EVENT_WAVEID")).append(gnewaveNo);
        descriptionStr.append("APE_EVENT_ATTENTION");
        TEAbNormalEvent unbalanceEvent = new TEAbNormalEvent();
        unbalanceEvent.eventID = 68;
        this.ne = TENEListMgr.getInstance().getNE(neID);
        unbalanceEvent.objStr = this.ne.getNEName();
        unbalanceEvent.nodeType = this.ne.getNEType();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        unbalanceEvent.timeStr = startTime;
        unbalanceEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        unbalanceEvent.severityLevel = 2;
        unbalanceEvent.severityStr = TENEListUtils.getString(String.valueOf(unbalanceEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        unbalanceEvent.eventType = 1;
        unbalanceEvent.typeStr = TENEListUtils.getString(String.valueOf(unbalanceEvent.eventType), TENEListUtils.ALARM_SOURCE_FILE);
        unbalanceEvent.comment = descriptionStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, unbalanceEvent);
    }

    private void interpretAddDropWaveEvent(int cmdkey, int neID, Operation operation) {
        int apeIndex = 0;
        int pathNo = 0;
        int gnewaveNo = 0;
        int addDropFlag = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("apeIndex")) {
                    apeIndex = Integer.parseInt(value);
                }
                if ("pathNo".equals(name)) {
                    pathNo = Integer.parseInt(value);
                }
                if (!"addDropFlag".equals(name)) continue;
                addDropFlag = Integer.parseInt(value);
            }
            gnewaveNo = this.getGneWaveNo(neID, pathNo);
        }
        this.ne = TENEListMgr.getInstance().getNE(neID);
        StringBuffer addDropWaveStr = new StringBuffer("APE_ADDDROP");
        addDropWaveStr.append(addDropFlag);
        addDropWaveStr.append(TENEListUtils.getString(addDropWaveStr.toString()));
        addDropWaveStr.append(' ');
        addDropWaveStr.append(TENEListUtils.getString("APE_EVENT_ADDDROP_WAVE"));
        addDropWaveStr.append(this.ne.getNEName());
        addDropWaveStr.append(TENEListUtils.getString("APE_EVENT_APEPAIR"));
        addDropWaveStr.append(apeIndex);
        addDropWaveStr.append(TENEListUtils.getString("APE_EVENT_WAVEID"));
        addDropWaveStr.append(gnewaveNo);
        addDropWaveStr.append(TENEListUtils.getString("APE_EVENT_ATTENTION"));
        TEAbNormalEvent addDropWaveEvent = new TEAbNormalEvent();
        addDropWaveEvent.eventID = 69;
        addDropWaveEvent.objStr = this.ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        addDropWaveEvent.timeStr = startTime;
        addDropWaveEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        addDropWaveEvent.severityLevel = 2;
        addDropWaveEvent.severityStr = TENEListUtils.getString(String.valueOf(addDropWaveEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        addDropWaveEvent.eventType = 1;
        addDropWaveEvent.typeStr = TENEListUtils.getString("alarmType" + addDropWaveEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        addDropWaveEvent.comment = addDropWaveStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, addDropWaveEvent);
    }

    private void interpretAdjustFinishEvent(int cmdkey, int neID, Operation operation) {
        int apeIndex = 0;
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (!name.equalsIgnoreCase("apeIndex")) continue;
                apeIndex = Integer.parseInt(value);
            }
        }
        String adjustFinishStr = TENEListUtils.getString("APE_EVENT_ADJUST_FINISH");
        adjustFinishStr = adjustFinishStr + this.ne.getNEName();
        adjustFinishStr = adjustFinishStr + TENEListUtils.getString("APE_EVENT_APEPAIR");
        adjustFinishStr = adjustFinishStr + apeIndex;
        adjustFinishStr = adjustFinishStr + TENEListUtils.getString("APE_EVENT_ATTENTION");
        TEAbNormalEvent adjustFinishEvent = new TEAbNormalEvent();
        adjustFinishEvent.eventID = 70;
        this.ne = TENEListMgr.getInstance().getNE(neID);
        adjustFinishEvent.objStr = this.ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        adjustFinishEvent.timeStr = startTime;
        adjustFinishEvent.severityLevel = 4;
        adjustFinishEvent.severityStr = TENEListUtils.getString(String.valueOf(adjustFinishEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        adjustFinishEvent.eventType = 1;
        adjustFinishEvent.typeStr = TENEListUtils.getString("alarmType" + adjustFinishEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        adjustFinishEvent.comment = adjustFinishStr;
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, adjustFinishEvent);
    }

    private void interpretAdjustFailEvent(int cmdkey, int neID, Operation operation) {
        int apeIndex = 0;
        int adjustFailType = 0;
        int failReason1 = 0;
        int failReason2 = 0;
        int failReason3 = 0;
        StringBuffer reasonStr = new StringBuffer();
        this.ne = TENEListMgr.getInstance().getNE(neID);
        Output[] outputArr = operation.getOutput();
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            for (Part part : outputArr[i].getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("apeIndex")) {
                    apeIndex = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("adjustFailType")) {
                    adjustFailType = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("failReason1")) {
                    failReason1 = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("failReason2")) {
                    failReason2 = Integer.parseInt(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("failReason3")) continue;
                failReason3 = Integer.parseInt(value);
            }
            reasonStr.append(adjustFailType);
            reasonStr.append(failReason1);
            reasonStr.append(failReason2);
            reasonStr.append(failReason3);
        }
        String adjustFailStr = TENEListUtils.getString("APE_EVENT_ADJUST_FAIL");
        adjustFailStr = adjustFailStr + this.ne.getNEName();
        adjustFailStr = adjustFailStr + TENEListUtils.getString("APE_EVENT_APEPAIR");
        adjustFailStr = adjustFailStr + apeIndex;
        adjustFailStr = adjustFailStr + TENEListUtils.getString("APE_EVENT_ATTENTION");
        TEAbNormalEvent adjustFailEvent = new TEAbNormalEvent();
        adjustFailEvent.eventID = 71;
        adjustFailEvent.objStr = this.ne.getNEName();
        GregorianCalendar startTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        adjustFailEvent.timeStr = startTime;
        adjustFailEvent.timeRiseStr = TEDateUtils.calendarToStr(startTime);
        adjustFailEvent.severityLevel = 1;
        adjustFailEvent.severityStr = TENEListUtils.getString(String.valueOf(adjustFailEvent.severityLevel), TENEListUtils.ALARM_SOURCE_FILE);
        adjustFailEvent.eventType = 1;
        adjustFailEvent.typeStr = TENEListUtils.getString("alarmType" + adjustFailEvent.eventType, TENEListUtils.ALARM_SOURCE_FILE);
        adjustFailEvent.comment = adjustFailStr = adjustFailStr + reasonStr.toString();
        TEEventBrowseMgr.getInstance().addAbNormalEvent(neID, adjustFailEvent);
    }

    private int getGneWaveNo(int neID, int pathNo) {
        return 0;
    }
}

