/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.datamgr;

import com.huawei.nglct.nelist.model.TEWaveLengthInfo;
import java.util.ArrayList;
import java.util.HashMap;

public class TEWaveConfigurationDataMgr {
    private static TEWaveConfigurationDataMgr instance;
    private HashMap waveLengthInfoData = new HashMap();
    private int waveLengthMaxNo = 0;

    private TEWaveConfigurationDataMgr() {
    }

    public static synchronized TEWaveConfigurationDataMgr getInstance() {
        if (instance == null) {
            instance = new TEWaveConfigurationDataMgr();
        }
        return instance;
    }

    public void fillWaveLengthInfo(ArrayList waveLenUnitList) {
        if (waveLenUnitList == null || waveLenUnitList.size() == 0) {
            return;
        }
        try {
            int size = waveLenUnitList.size();
            for (int i = 0; i < size; ++i) {
                TEWaveLengthInfo waveLenUnit = (TEWaveLengthInfo)waveLenUnitList.get(i);
                int waveNo = waveLenUnit.getWaveNo();
                if (waveNo > this.waveLengthMaxNo) {
                    this.waveLengthMaxNo = waveNo;
                }
                String strWaveLength = "";
                String strFrequency = "";
                String strCustomizeNo = String.valueOf(waveLenUnit.getcustomizeNo());
                if (new Integer(waveLenUnit.getWavenLength()) > 0) {
                    String waveLengthStr = waveLenUnit.getWavenLength();
                    strWaveLength = waveLengthStr.length() > 4 ? waveLengthStr.substring(0, 4) + "." + waveLengthStr.substring(4) : waveLengthStr;
                }
                if (new Integer(waveLenUnit.getFrequency()) > 0) {
                    String frequencyStr = waveLenUnit.getFrequency();
                    strFrequency = frequencyStr.length() > 3 ? frequencyStr.substring(0, 3) + "." + frequencyStr.substring(3) : frequencyStr;
                }
                TEWaveLengthInfo waveLengthInfo = new TEWaveLengthInfo(waveNo, strWaveLength, strFrequency, strCustomizeNo);
                this.waveLengthInfoData.put(waveNo, waveLengthInfo);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public String getWaveLengthInfo(int iwaveNo) {
        TEWaveLengthInfo waveLengthInfo = (TEWaveLengthInfo)this.waveLengthInfoData.get(iwaveNo);
        if (waveLengthInfo == null) {
            return null;
        }
        return waveLengthInfo.getWavenLength();
    }

    public String getFrequency(int iwaveNo) {
        TEWaveLengthInfo waveLengthInfo = (TEWaveLengthInfo)this.waveLengthInfoData.get(iwaveNo);
        if (waveLengthInfo == null) {
            return null;
        }
        return waveLengthInfo.getFrequency();
    }

    public String getCustomizeWaveNo(int iwaveNo) {
        TEWaveLengthInfo waveLengthInfo = (TEWaveLengthInfo)this.waveLengthInfoData.get(iwaveNo);
        if (waveLengthInfo == null) {
            return null;
        }
        return waveLengthInfo.getcustomizeNo();
    }

    public String getNumberWaveLengthFrequency(int iwaveNo) {
        TEWaveLengthInfo waveLengthInfo = (TEWaveLengthInfo)this.waveLengthInfoData.get(iwaveNo);
        if (waveLengthInfo == null) {
            return null;
        }
        return waveLengthInfo.getcustomizeNo() + "/" + waveLengthInfo.getWavenLength() + "/" + waveLengthInfo.getFrequency();
    }
}

