/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.datamgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.mo.CfgDataMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFunBlockID;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEFunctionBlock;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.TEPortFBModel;
import com.huawei.nglct.nelist.model.TEReadServiceTypeUtil;
import com.huawei.nglct.nelist.model.TESpecialBoardData;
import com.huawei.nglct.nelist.model.TEStaticFBCount;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.util.device.board.TEQueryBoardInfoBean;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class TEServiceConfigurationDataMgr {
    private static TEServiceConfigurationDataMgr instance;
    private Hashtable<String, TEAIDAndTypeList> supportTL1PayloadType = new Hashtable();
    private Hashtable<String, ArrayList<Integer>> supportPayloadTye = new Hashtable();

    private TEServiceConfigurationDataMgr() {
    }

    public static synchronized TEServiceConfigurationDataMgr getInstance() {
        if (instance == null) {
            instance = new TEServiceConfigurationDataMgr();
        }
        return instance;
    }

    public ArrayList getSupportTLlXCLevelList(int neID, int boardType, int portID, int slotID) {
        ArrayList supxcLevelList;
        if (boardType == 1573) {
            ArrayList<Integer> xcLevelList = new ArrayList<Integer>();
            if (3 <= portID && portID <= 10) {
                int[] xcLevelArr = new int[]{257, 260, 513, 769, 770, 771, 1025, 1026, 1027, 1282, 1283, 1537, 1538, 1793, 2049, 2050, 2305, 2561};
                int size = xcLevelArr.length;
                for (int i = 0; i < size; ++i) {
                    xcLevelList.add(xcLevelArr[i]);
                }
                return xcLevelList;
            }
            return this.getTL1PayLoadTypeList(neID, slotID, portID);
        }
        ArrayList xcLevelList = new ArrayList();
        TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(boardType, portID);
        if (portParaRecord == null) {
            return null;
        }
        String inName = portParaRecord.inName;
        String outName = portParaRecord.outName;
        if ((inName != null || outName != null) && (supxcLevelList = portParaRecord.supTl1XCLevelList).size() > 0) {
            xcLevelList.addAll(supxcLevelList);
        }
        if (xcLevelList.size() == 0) {
            xcLevelList.addAll(this.getSupportXCLevelList(neID, boardType, portID));
        }
        return xcLevelList;
    }

    public ArrayList getTL1PayLoadTypeList(int neid, int slotid, int portid) {
        String key = neid + "-" + slotid;
        TEAIDAndTypeList typeListAID = this.supportTL1PayloadType.get(key);
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        if (typeListAID == null) {
            return tempList;
        }
        ArrayList payLoadList = typeListAID.getPortPayloadMod2(neid, slotid, portid);
        String value = "";
        int size = payLoadList.size();
        for (int i = 0; i < size; ++i) {
            String payload = (String)payLoadList.get(i);
            if (payload.equals("GETH")) {
                payload = "GE";
            } else if (payload.equals("FETH")) {
                payload = "FE";
            } else if (payload.equals("FICONEXP")) {
                payload = "FICONEXPESS";
            }
            payload = "XC_LEVEL_" + payload;
            value = i > 0 ? value + "," + payload : payload;
        }
        TIntArrayList iList = new TIntArrayList();
        SDXMLInterpreterMgr.getInstance().parseIntList(value, iList);
        CfgDataMgr dataMgr = CfgDataMgr.getInstance();
        int size2 = iList.size();
        for (int i = 0; i < size2; ++i) {
            int nmServiceType = iList.get(i);
            int neServiceType = dataMgr.getNESerTypeByNM(nmServiceType);
            tempList.add(neServiceType);
        }
        return tempList;
    }

    public ArrayList getSupportXCLevelList(int neID, int boardType, int portID, int boardMode, int slotID, int path) {
        ArrayList supxcLevelList;
        if (boardType == 1573) {
            String key;
            if (path == -1) {
                path = 1;
            }
            if (this.supportPayloadTye.containsKey(key = neID + "-" + slotID + "-" + portID + "-" + path)) {
                return this.supportPayloadTye.get(key);
            }
            new ArrayList();
        }
        ArrayList xcLevelList = new ArrayList();
        boolean checkBoardMode = false;
        TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(boardType, portID);
        if (portParaRecord == null) {
            return null;
        }
        String inName = portParaRecord.inName;
        String outName = portParaRecord.outName;
        if (portParaRecord.boardModeList == null || portParaRecord.boardModeList.contains(boardMode)) {
            checkBoardMode = true;
        }
        if (this.isActuallyNoBoardModeBoard(boardType)) {
            String tipStr = "The board is actually no board mode. ";
            tipStr = tipStr + String.format("neID:%d, slotID:%d, boardType:%d", neID, slotID, boardType);
            TELogFactory.getNormalLogger().info(tipStr);
            checkBoardMode = true;
        }
        if (boardType == 1620 && portID == 51 && boardMode != 20) {
            checkBoardMode = false;
        }
        if ((inName != null || outName != null) && checkBoardMode && (supxcLevelList = portParaRecord.supXCLevelList).size() > 0) {
            xcLevelList.addAll(supxcLevelList);
        }
        return xcLevelList;
    }

    private boolean isActuallyNoBoardModeBoard(int boardType) {
        ArrayList<Integer> actuallyNoModeBdList = new ArrayList<Integer>();
        actuallyNoModeBdList.add(2109);
        actuallyNoModeBdList.add(2110);
        return actuallyNoModeBdList.contains(boardType);
    }

    public ArrayList getSupportXCLevelList(int neID, int boardType, int portID) {
        ArrayList xcLevelList = new ArrayList();
        TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(boardType, portID);
        if (portParaRecord == null) {
            return null;
        }
        TENE ne = TENEListUtils.getNEObj(neID);
        String inName = portParaRecord.inName;
        String outName = portParaRecord.outName;
        if (inName != null || outName != null) {
            ArrayList supxcLevelList = new ArrayList();
            if (ne.getIsTL1OrQX() == 1) {
                supxcLevelList = portParaRecord.supTl1XCLevelList;
            }
            if (supxcLevelList.size() == 0) {
                supxcLevelList = portParaRecord.supXCLevelList;
            }
            if (supxcLevelList.size() > 0) {
                xcLevelList.addAll(supxcLevelList);
            }
        }
        return xcLevelList;
    }

    public ArrayList getXCLevelList(int neID, int boardType, int portID, int slotID, int path) {
        if (boardType == 1573) {
            if (path == -1) {
                path = 1;
            }
            TENE tene = TEConfigurationDataMgr.getInstance().getNE(neID);
            List<TEPortFBModel> fbList = TESpecialBoardData.getInstance().getFBList(neID, slotID);
            if (fbList == null) {
                ArrayList<Integer> tmpL = new ArrayList<Integer>();
                tmpL.add(slotID);
                TEQueryBoardInfoBean.queryBoardInfo(neID, tmpL);
                fbList = TESpecialBoardData.getInstance().getFBList(neID, slotID);
            }
            ArrayList<Integer> xcLevelList = new ArrayList<Integer>();
            if (3 <= portID && portID <= 10) {
                int[] xcLevelArr = new int[]{65535, 257, 260, 513, 769, 770, 771, 1025, 1026, 1027, 1282, 1283, 1537, 1538, 1793, 2049, 2050, 2305, 2561};
                int size = xcLevelArr.length;
                for (int i = 0; i < size; ++i) {
                    xcLevelList.add(xcLevelArr[i]);
                }
                return xcLevelList;
            }
            if (null != fbList) {
                int size = fbList.size();
                for (int i = 0; i < size; ++i) {
                    int[] array = this.getTEPortFBModel(fbList.get(i), tene);
                    if (array[0] != portID || array[1] != path) continue;
                    ArrayList<Integer> payloadTyes = this.supportPayloadTye.get("" + neID + "-" + slotID + "-" + portID + "-" + path);
                    if (array[2] == 65535 && null != payloadTyes) {
                        xcLevelList.addAll(payloadTyes);
                        continue;
                    }
                    xcLevelList.add(array[2]);
                }
            }
            return xcLevelList;
        }
        ArrayList xcLevelList = new ArrayList();
        TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(boardType, portID);
        if (portParaRecord != null) {
            ArrayList supxcLevelList;
            String inName = portParaRecord.inName;
            String outName = portParaRecord.outName;
            if ((null != inName || null != outName) && (supxcLevelList = portParaRecord.supXCLevelList).size() > 0) {
                xcLevelList.addAll(supxcLevelList);
            }
        }
        return xcLevelList;
    }

    public int[] getTEPortFBModel(Object obj, TENE ne) {
        int[] array = new int[3];
        TEPortFBModel fbModel = (TEPortFBModel)obj;
        array[0] = fbModel.getPortId();
        array[1] = fbModel.getPath();
        array[2] = fbModel.getPathType();
        return array;
    }

    public void addddPayloadTypeList(int neid, int slotid, int portId, int path, ArrayList<Integer> payloadTypeList) {
        String key = "" + neid + "-" + slotid + "-" + portId + "-" + path;
        this.supportPayloadTye.put(key, payloadTypeList);
    }

    public void removePayloadTypeList(int neid, int slotid, int portid, int path) {
        if (path == -1) {
            path = 1;
        }
        String key = "" + neid + "-" + slotid + "-" + portid + "-" + path;
        this.supportPayloadTye.remove(key);
    }

    public void addTL1PayloadTypeList(int neid, int slotid, TEAIDAndTypeList aidTypeList) {
        if (aidTypeList != null) {
            String key = neid + "-" + slotid;
            this.supportTL1PayloadType.put(key, aidTypeList);
        }
    }

    public TEAIDAndTypeList getTL1AIDTypeList(int neid, int slotid) {
        String key = neid + "-" + slotid;
        return this.supportTL1PayloadType.get(key);
    }

    public TEAIDAndTypeList removeTL1AIDTypeList(int neid, int slotid) {
        String key = neid + "-" + slotid;
        return this.supportTL1PayloadType.remove(key);
    }

    public String getFunBlockName(TEFunctionBlock funblock) {
        return TopoUtility.getInstance().getNEBoardPortFunBlockName(funblock.getNEID(), funblock.getSlotID(), funblock.getBoardType(), funblock.getFunctionBlockType(), funblock.getPortID(), funblock.getFunctionBlockID(), funblock.getOffsetID(), funblock.getFunBlockID4(), funblock.getFunBlockID5(), funblock.getFunBlockID6());
    }

    public String getPortFunBlockName(int neID, int slotID, int iFunblockType, int iLocation1, int iLocation2, int iLocation3, int iLocation4, int iLocation5, int iLocation6) {
        int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        return TopoUtility.getInstance().getNEBoardPortFunBlockName(neID, slotID, boardType, iFunblockType, iLocation1, iLocation2, iLocation3, iLocation4, iLocation5, iLocation6);
    }

    public String getFunBlockTypeName(int iFunblockType) {
        return TEFuncBlockDescription.getInstance().getFBTypeName(iFunblockType);
    }

    public boolean isBIFBType(int fb) {
        return TEFuncBlockDescription.getInstance().isBiFBType(fb);
    }

    public TIntHashSet getFBTypeByBiType(int biType) {
        TIntHashSet fbs = new TIntHashSet();
        TEFuncBlockDescription.getInstance().getFBTypeByBiType(biType, fbs);
        return fbs;
    }

    public int getBidirFBType(int fbType) {
        return TEFuncBlockDescription.getInstance().getBidirFBType(fbType);
    }

    public List getFunBlockList(int neID, int slotID, int iBoardType) {
        ArrayList<TEFunctionBlock> result = new ArrayList<TEFunctionBlock>();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        List<TEFunBlockProperty> boardFunPropertyList = cpDesc.getCPFunBlockList(iBoardType);
        if (boardFunPropertyList != null && boardFunPropertyList.size() > 0) {
            int size = boardFunPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEFunBlockProperty fbproperty = boardFunPropertyList.get(i);
                ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                if (fbNoList == null || fbNoList.size() <= 0) continue;
                int length = fbNoList.size();
                for (int j = 0; j < length; ++j) {
                    TEFunBlockID funblockID = (TEFunBlockID)fbNoList.get(j);
                    result.add(new TEFunctionBlock(neID, slotID, iBoardType, funblockID.getTTPID1(), funblockID.getTTPID2(), fbproperty.getFuctionBlockType(), funblockID.getTTPID3(), funblockID.getTTPID4(), funblockID.getTTPID5()));
                }
            }
        }
        int portID = 0;
        TEStaticFBCount fbcount = null;
        TEInstallCPPortRecord portRecord = null;
        List<TEInstallCPPortRecord> portRecordList = cpDesc.getInstallCPPort(iBoardType);
        int m = portRecordList.size();
        for (int i = 0; i < m; ++i) {
            portRecord = portRecordList.get(i);
            List tmpFBList = this.getStaticFBCountList(portRecord.portType, portRecord.interfaceLevel, TEPortDescription.getInstance().getPortFBList(portRecord.portType, portRecord.interfaceLevel, true));
            int n = portRecord.portIDList.size();
            for (int j = 0; j < n; ++j) {
                portID = (Integer)portRecord.portIDList.get(j);
                int mn = tmpFBList.size();
                for (int k = 0; k < mn; ++k) {
                    fbcount = (TEStaticFBCount)tmpFBList.get(k);
                    int t = fbcount.getFunBlockTypeCount();
                    for (int s = 0; s < t; ++s) {
                        TEFunBlockID tmpfunID = new TEFunBlockID(s + 1, 0);
                        result.add(new TEFunctionBlock(neID, slotID, iBoardType, portRecord.portType, portID, fbcount.getFuctionBlockType(), tmpfunID.getTTPID1(), tmpfunID.getTTPID2(), tmpfunID.getTTPID3(), tmpfunID.getTTPID4(), tmpfunID.getTTPID5()));
                    }
                }
            }
        }
        return result;
    }

    private List getStaticFBCountList(int portType, int level, List fbList) {
        int fbType = 0;
        int biFbType = 0;
        TEStaticFBCount fbCount = null;
        ArrayList<TEStaticFBCount> portFBList = new ArrayList<TEStaticFBCount>();
        TEPortDescription portDesc = TEPortDescription.getInstance();
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        int m = fbList.size();
        for (int i = 0; i < m; ++i) {
            fbType = (Integer)fbList.get(i);
            biFbType = fbDesc.getBidirFBType(fbType);
            fbCount = new TEStaticFBCount(biFbType, portDesc.getPortContainMONumByType(portType, level, fbType));
            if (portFBList.contains(fbCount)) continue;
            portFBList.add(fbCount);
        }
        return portFBList;
    }

    public List getFunBlockFromID(int iNEID, int iSlotID, int iPortID) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        if (board == null) {
            return result;
        }
        TEStaticFBCount fbcount = null;
        TEInstallCPPortRecord portRecord = null;
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(board.getBoardType());
        int m = portRecordList.size();
        for (int i = 0; i < m; ++i) {
            portRecord = portRecordList.get(i);
            if (!portRecord.portIDList.contains(iPortID)) continue;
            List tmpFBList = this.getStaticFBCountList(portRecord.portType, portRecord.interfaceLevel, TEPortDescription.getInstance().getPortFBList(portRecord.portType, portRecord.interfaceLevel, true));
            int mn = tmpFBList.size();
            for (int k = 0; k < mn; ++k) {
                fbcount = (TEStaticFBCount)tmpFBList.get(k);
                result.add(fbcount.getFuctionBlockType());
            }
        }
        return result;
    }

    public int getFunBlockNumber(int neID, int slotID, int fbType) {
        int fbNumber = 0;
        List fbList = this.getFunBlockList(neID, slotID);
        int size = fbList.size();
        for (int fbIndex = 0; fbIndex < size; ++fbIndex) {
            TEFunctionBlock fb = (TEFunctionBlock)fbList.get(fbIndex);
            if (fb.getFunctionBlockType() != fbType) continue;
            ++fbNumber;
        }
        return fbNumber;
    }

    public List getBoardFunBlockList(int cpType) {
        return TECircuitPackDescription.getInstance().getCPFunBlockList(cpType);
    }

    public List getBoardSupportFBTypeList(int neID, int iBoardType) {
        return TECircuitPackDescription.getInstance().getCPContainFBList(iBoardType, true);
    }

    public List getFunBlockList(int iNEID, int iSlotID) {
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        return this.getFunBlockList(board);
    }

    public List getFunBlockList(TEBoard board) {
        return this.getFunBlockList(board.getNEID(), board.getSlotID(), board.getBoardType());
    }

    public ArrayList getBoardFromFB(int neID, int fbType) {
        ArrayList<TEBoard> avaliableBoardlist = new ArrayList<TEBoard>();
        TENE neObj = TENEListMgr.getInstance().getNE(neID);
        if (null != neObj) {
            Vector boardList = neObj.getBoardList();
            int size = boardList.size();
            for (int i = 0; i < size; ++i) {
                TEBoard board = (TEBoard)boardList.get(i);
                int boardType = board.getBoardType();
                ArrayList fbTypeList = (ArrayList)this.getBoardSupportFBTypeList(neID, boardType);
                if (!fbTypeList.contains(fbType)) continue;
                avaliableBoardlist.add(board);
            }
        }
        return avaliableBoardlist;
    }

    public static final int getVC4Number(int STMLevel) {
        int num = -1;
        num = STMLevel - 20482 + 2;
        if (num > 0) {
            return num;
        }
        num = STMLevel - 6401 + 1;
        if (num > 0) {
            return num;
        }
        num = STMLevel - 4864;
        if (num > 0) {
            return num;
        }
        if (num == 0) {
            return 1;
        }
        return num;
    }

    public ArrayList getSupportServiceType(int neID, int boardType, int portID, int ver) {
        ArrayList supServiceTypeList;
        ArrayList serviceTypeList = new ArrayList();
        TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(boardType, portID);
        if (portParaRecord == null) {
            return null;
        }
        String inName = portParaRecord.inName;
        String outName = portParaRecord.outName;
        if ((inName != null || outName != null) && (supServiceTypeList = TEReadServiceTypeUtil.getInstance().getServiceTypeList(neID, boardType, portID, ver)).size() > 0) {
            serviceTypeList.addAll(supServiceTypeList);
        }
        return serviceTypeList;
    }
}

