/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.datamgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.TEPortIndex;
import com.huawei.nglct.nelist.model.TEQueryLogicPortForDataMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.TETL1AIDKey;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallSubCPRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nelist.model.datamgr.NEIDAndSlotIDKey;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.nemanager.TEState;
import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBufferByLoadTimes;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.device.port.TEPortUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEPortModelConfigurationDataMgr {
    public static final String VCTRUNK_PREFIX = "VCTRUNK";
    public static final int VCTRUNKFLG = 32768;
    public static final int VCTRUNKFLG_END = 33024;
    public static final String UNKNOWN_POSTFIX = "(UNKNOWN)";
    private static final int NULL_DOMAIN_TYPE = -1;
    private static TEPortModelConfigurationDataMgr instance;
    public String PORT_RES = "";
    private Hashtable modifiedPortNameData = new Hashtable(50);
    private Hashtable<Integer, Hashtable<String, List<TEPort>>> dynBoardPortData = new Hashtable();
    private Hashtable portIndexData = new Hashtable();
    private Map<TETL1AIDKey, TEState> portState = new HashMap<TETL1AIDKey, TEState>();
    private TETimeBufferByLoadTimes<NEIDAndSlotIDKey, List<Integer>> logicPortBuffer = new TETimeBufferByLoadTimes();
    private Hashtable modifiedPortNameMap = new Hashtable(50);

    private TEPortModelConfigurationDataMgr() {
        this.logicPortBuffer.setBufferCapacity(1000);
        this.logicPortBuffer.setPeriodTime(10000L);
        this.logicPortBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            @Override
            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof NEIDAndSlotIDKey) {
                    NEIDAndSlotIDKey idkey = (NEIDAndSlotIDKey)key;
                    return TEPortModelConfigurationDataMgr.this.getLogicPortListOnInter(idkey.neid, idkey.slotid);
                }
                return null;
            }
        });
    }

    public static synchronized TEPortModelConfigurationDataMgr getInstance() {
        if (instance == null) {
            instance = new TEPortModelConfigurationDataMgr();
            String resFilePath = "res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
            TEPortModelConfigurationDataMgr.instance.PORT_RES = TEResourceUtil.getInstance(resFilePath).getString("portname");
        }
        return instance;
    }

    public String getPortName(int neID, int slotID, int iBoardType, int portID) {
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (ne == null) {
            TELogFactory.getNormalLogger().info("ne is null.");
            return portID + UNKNOWN_POSTFIX;
        }
        if (TENEConfigurationDataMgr.getInstance().isPTNDevice(ne) && !TENEConfigurationDataMgr.getInstance().isRTNDomainNE(neID)) {
            String resFilePath = "res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
            String portName = TEResourceUtil.getInstance(resFilePath).getString("portname");
            return portID + "(" + portName + "-" + portID + ")";
        }
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            TELogFactory.getNormalLogger().info("board is not exist.");
            return portID + UNKNOWN_POSTFIX;
        }
        StringBuffer strPortName = new StringBuffer();
        String name = "";
        if (4096 <= portID && 6144 > portID) {
            strPortName.append(portID - 4096).append('(').append("MP-").append(portID - 4096).append(')');
            return strPortName.toString();
        }
        if (6144 <= portID && 8192 > portID) {
            strPortName.append(portID - 6144).append('(').append("Serial-").append(portID - 6144).append(')');
            return strPortName.toString();
        }
        if (TEConfigurationDataMgr.getInstance().getPortType(neID, iBoardType, portID) == 61005) {
            strPortName.append("VCTRUNK:");
            strPortName.append(portID - 32768);
            return strPortName.toString();
        }
        name = this.getDyncPortName(neID, slotID, iBoardType, portID);
        if (null != name && !"".equalsIgnoreCase(name)) {
            if (this.isVCTrunckPort(neID, slotID, portID)) {
                strPortName.append(portID - 32768).append('(');
            } else {
                strPortName.append(portID).append('(');
            }
            strPortName.append(name);
            strPortName.append(')');
            return strPortName.toString();
        }
        if (TEVirtualPortUtil.isVirtualPort(iBoardType, portID, 0)) {
            return TEVirtualPortUtil.getVirtualPortName(portID);
        }
        if (TEBoardConfigurationDataMgr.getInstance().isWDMBoardType(neID, iBoardType)) {
            TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(iBoardType, portID);
            if (null == portParaRecord) {
                if (this.isVCTrunckPort(neID, slotID, portID)) {
                    strPortName.append(VCTRUNK_PREFIX);
                    strPortName.append(portID - 32768);
                    return strPortName.toString();
                }
                return portID + UNKNOWN_POSTFIX;
            }
            int portType = portParaRecord.portType;
            String inName = portParaRecord.inName;
            String outName = portParaRecord.outName;
            if (inName != null && portType == 61005) {
                strPortName.append(VCTRUNK_PREFIX);
                strPortName.append(portID - 32768);
                return strPortName.toString();
            }
            if (outName != null && portType == 61005) {
                strPortName.append(VCTRUNK_PREFIX);
                strPortName.append(portID - 32768);
                return strPortName.toString();
            }
            if (inName != null && outName == null && portType != 61005) {
                strPortName.append(portID);
                strPortName.append('(');
                if (!"".equalsIgnoreCase(inName)) {
                    strPortName.append(inName);
                }
                strPortName.append(')');
            }
            if (inName == null && outName != null && portType != 61005) {
                strPortName.append(portID);
                strPortName.append('(');
                if (!"".equalsIgnoreCase(outName)) {
                    strPortName.append(outName);
                }
                strPortName.append(')');
            }
            if (inName != null && outName != null && portType != 61005) {
                strPortName.append(portID);
                strPortName.append('(');
                if (!"".equalsIgnoreCase(inName)) {
                    strPortName.append(inName);
                }
                if (!"".equalsIgnoreCase(inName) && !"".equalsIgnoreCase(outName)) {
                    strPortName.append('/');
                }
                if (!"".equalsIgnoreCase(outName)) {
                    strPortName.append(outName);
                }
                strPortName.append(')');
            }
            if (strPortName.length() == 0) {
                TELogFactory.getNormalLogger().info("stringName is null.");
                return portID + UNKNOWN_POSTFIX;
            }
            return strPortName.toString();
        }
        return this.getPortNameFromType(neID, slotID, iBoardType, portID, -1);
    }

    public String getPortNameForPTN(int neID, int slotID, int iBoardType, int portID) {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (configurDataMgr.isIFboard(iBoardType) && configurDataMgr.isPTNDevice(ne)) {
            return configurDataMgr.getPortNameByPortType(neID, slotID, iBoardType, portID, 1802);
        }
        int portType = this.getPortType(neID, iBoardType, portID);
        int portDomainType = 255;
        if (portType != -1) {
            portDomainType = this.getDomainType(portType);
        }
        if (portDomainType == 255) {
            portDomainType = TEQueryPortForDataMgr.getCNEMgrDomainType(neID);
        }
        return this.getPortNameForPTN(neID, slotID, iBoardType, portID, portDomainType);
    }

    public String getPortNameForPTN(int neID, int slotID, int iBoardType, int portID, int portDomainType) {
        String specialName;
        TEPort port;
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (ne == null) {
            TELogFactory.getNormalLogger().info("ne is null.");
            return portID + UNKNOWN_POSTFIX;
        }
        StringBuffer stringName = new StringBuffer();
        String name = "";
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            String specialName2 = this.getPtnSpecialPortName(portID, "");
            if (null != specialName2 && !"".equals(specialName2)) {
                return specialName2;
            }
            TELogFactory.getNormalLogger().info("board is not exist.");
            return portID + UNKNOWN_POSTFIX;
        }
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            port = new TEPort(neID, slotID, iBoardType, portID);
            name = (String)this.modifiedPortNameMap.get(port);
            if ((name == null || "".equals(name)) && TEVirtualPortUtil.isVirtualPort(iBoardType, portID, 0)) {
                return TEVirtualPortUtil.getVirtualPortName(portID);
            }
        } else {
            port = TEQueryPortForDataMgr.getPortOnInter(neID, slotID, iBoardType, portID, portDomainType);
            if (null != port) {
                name = port.getPortName();
            }
        }
        if (null != (specialName = this.getPtnSpecialPortName(portID, name)) && !"".equals(specialName)) {
            return specialName;
        }
        if (null != name && !"".equalsIgnoreCase(name)) {
            if (this.isVCTrunckPort(neID, slotID, portID)) {
                stringName.append(portID - 32768).append('(');
            } else {
                stringName.append(portID).append('(');
            }
            stringName.append(name);
            stringName.append(')');
            return stringName.toString();
        }
        String portName = "";
        if (TEBoardConfigurationDataMgr.getInstance().isSupportSubCard(iBoardType)) {
            return this.getSubCardPortName(neID, slotID, portID);
        }
        portName = this.getPortNamePtnEth(neID, slotID, iBoardType, portID);
        portName = "".equals(portName) ? this.PORT_RES + '-' + String.valueOf(portID) : portName;
        return String.valueOf(portID) + '(' + portName + ')';
    }

    private String getPortNamePtnEth(int neID, int slotID, int iBoardType, int portID) {
        String portName = "";
        portName = TEBoardConfigurationDataMgr.getInstance().isIFboard(iBoardType) ? this.getPortNameFromType(neID, slotID, iBoardType, portID, 1802) : this.getPortNameFromType(neID, slotID, iBoardType, portID, 1799);
        return portName;
    }

    private String getPtnSpecialPortName(int portID, String name) {
        StringBuffer stringName = new StringBuffer();
        if (4096 <= portID && 6144 > portID) {
            name = String.valueOf(portID - 4096);
            stringName.append(portID - 4096).append("(MP-").append(name).append(')');
            return stringName.toString();
        }
        if (10240 <= portID && 12288 > portID) {
            name = String.valueOf(portID - 10240);
            stringName.append(portID - 10240).append("(VEther-").append(name).append(')');
            return stringName.toString();
        }
        if (6144 <= portID && 8192 > portID) {
            stringName.append(portID - 6144).append("(Serial-").append(null == name || "".equals(name) ? Integer.valueOf(portID - 6144) : name).append(')');
            return stringName.toString();
        }
        if (8192 < portID && 10240 > portID) {
            stringName.append(portID - 8192).append("(Trunk-").append(null == name || "".equals(name) ? Integer.valueOf(portID - 8192) : name).append(')');
            return stringName.toString();
        }
        return stringName.toString();
    }

    public String getPortNameForSDH(int neID, int slotID, int iBoardType, int portID) {
        TEPort port;
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (ne == null) {
            TELogFactory.getNormalLogger().info("ne is null.");
            return portID + UNKNOWN_POSTFIX;
        }
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            TELogFactory.getNormalLogger().info("board is not exist.");
            return portID + UNKNOWN_POSTFIX;
        }
        StringBuffer stringName = new StringBuffer();
        String name = null;
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            port = new TEPort(neID, slotID, iBoardType, portID);
            name = (String)this.modifiedPortNameMap.get(port);
        } else {
            port = TEQueryPortForDataMgr.getPortOnInter(neID, slotID, iBoardType, portID);
            if (null != port) {
                name = port.getPortName();
            }
        }
        String specialName = this.getPtnSpecialPortName(portID, name);
        if (null != specialName && !"".equals(specialName)) {
            return specialName;
        }
        if (null != name && !"".equalsIgnoreCase(name)) {
            if (this.isVCTrunckPort(neID, slotID, portID)) {
                stringName.append(portID - 32768).append('(');
            } else {
                stringName.append(portID).append('(');
            }
            stringName.append(name);
            stringName.append(')');
            return stringName.toString();
        }
        return portID + "(SDH_TU-" + portID + ")";
    }

    public String getPortNameByPortType(int neID, int slotID, int iBoardType, int portID, int portType) {
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (ne == null) {
            TELogFactory.getNormalLogger().info("ne is null.");
            return portID + UNKNOWN_POSTFIX;
        }
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            TELogFactory.getNormalLogger().info("board is not exist.");
            return portID + UNKNOWN_POSTFIX;
        }
        StringBuffer stringName = new StringBuffer();
        String name = "";
        name = this.getDyncPortNameForType(neID, slotID, iBoardType, portID, portType);
        if (null != name && !"".equalsIgnoreCase(name)) {
            if (this.isVCTrunckPort(neID, slotID, portID)) {
                stringName.append(portID - 32768).append('(');
            } else {
                stringName.append(portID).append('(');
            }
            stringName.append(name);
            stringName.append(')');
            return stringName.toString();
        }
        if (TEBoardConfigurationDataMgr.getInstance().isWDMBoardType(neID, iBoardType)) {
            TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(iBoardType, portID);
            if (null == portParaRecord) {
                return portID + UNKNOWN_POSTFIX;
            }
            String inName = portParaRecord.inName;
            String outName = portParaRecord.outName;
            if (inName != null && portType == 61005) {
                stringName.append(VCTRUNK_PREFIX);
                stringName.append(portID - 32768);
                return stringName.toString();
            }
            if (outName != null && portType == 61005) {
                stringName.append(VCTRUNK_PREFIX);
                stringName.append(portID - 32768);
                return stringName.toString();
            }
            if (inName != null && outName == null && portType != 61005) {
                stringName.append(portID);
                stringName.append('(');
                if (!"".equalsIgnoreCase(inName)) {
                    stringName.append(inName);
                }
                stringName.append(')');
            }
            if (inName == null && outName != null && portType != 61005) {
                stringName.append(portID);
                stringName.append('(');
                if (!"".equalsIgnoreCase(outName)) {
                    stringName.append(outName);
                }
                stringName.append(')');
            }
            if (inName != null && outName != null && portType != 61005) {
                stringName.append(portID);
                stringName.append('(');
                if (!"".equalsIgnoreCase(inName)) {
                    stringName.append(inName);
                }
                if (!"".equalsIgnoreCase(inName) && !"".equalsIgnoreCase(outName)) {
                    stringName.append('/');
                }
                if (!"".equalsIgnoreCase(outName)) {
                    stringName.append(outName);
                }
                stringName.append(')');
            }
            if (stringName.length() == 0) {
                TELogFactory.getNormalLogger().info("stringName is null.");
                return portID + UNKNOWN_POSTFIX;
            }
            return stringName.toString();
        }
        if (!this.isExistPortType(neID, iBoardType, portID, portType)) {
            portType = this.getPortType(neID, iBoardType, portID);
        }
        if (portType == 61005) {
            stringName.append("VCTRUNK-");
            stringName.append(portID - 32768);
        } else if (portType == 1025) {
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append("(PORT-");
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append(')');
        } else if (portType == 2817) {
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append("(IF-");
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append(')');
        } else if (portType == 1802) {
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append("(RTNIF-");
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append(')');
        } else if (portType == 1803) {
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append("(RTNRF-");
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append(')');
        } else if (portType == 1799) {
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append("(PORT-");
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append(')');
        } else {
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append("(SDH");
            if (TEBoardConfigurationDataMgr.getInstance().isBranchBoardBybdType(neID, iBoardType)) {
                stringName.append("_TU");
            }
            stringName.append('-');
            stringName.append(TEPortUtil.getPortNo(portID));
            stringName.append(')');
        }
        return stringName.toString();
    }

    public String getDyncPortNameForType(int neID, int slotID, int iBoardType, int portID, int portType) {
        String portName = null;
        if (!this.isVCTrunckPort(neID, slotID, portID)) {
            if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                TEPort port = new TEPort(neID, slotID, iBoardType, portID);
                portName = (String)this.modifiedPortNameMap.get(port);
            } else {
                TEPort port = TEQueryPortForDataMgr.getPortOnInterForType(neID, slotID, iBoardType, portID, portType);
                if (null != port) {
                    portName = port.getPortName();
                }
            }
        }
        if (null != portName) {
            portName = portName.trim();
        }
        return portName;
    }

    public String getDyncPortName(int neID, int slotID, int iBoardType, int portID) {
        String portName = null;
        if (!this.isVCTrunckPort(neID, slotID, portID)) {
            if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                TEPort port = new TEPort(neID, slotID, iBoardType, portID);
                portName = (String)this.modifiedPortNameMap.get(port);
            } else {
                TEPort port = TEQueryPortForDataMgr.getPortOnInter(neID, slotID, iBoardType, portID);
                if (null != port) {
                    portName = port.getPortName();
                }
            }
        }
        if (null != portName) {
            portName = portName.trim();
        }
        return portName;
    }

    public boolean isVCTrunckPort(int neID, int slotID, int portID) {
        return portID > 32768 && portID < 33024;
    }

    public String getDyncPortName(int neID, int slotID, int iBoardType, int portID, int domainType) {
        String portName = null;
        if (!this.isVCTrunckPort(neID, slotID, portID)) {
            if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                TEPort port = new TEPort(neID, slotID, iBoardType, portID);
                portName = (String)this.modifiedPortNameMap.get(port);
            } else {
                TEPort port = TEQueryPortForDataMgr.getPortOnInter(neID, slotID, iBoardType, portID, domainType);
                if (null != port) {
                    portName = port.getPortName();
                }
            }
        }
        return portName;
    }

    public List getBoardPortPropertyList(int neID, int slotID, int iBoardType) {
        ArrayList<TEPortProperty> allPortPropertyList = new ArrayList<TEPortProperty>();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        TEPortProperty portProperty = null;
        TEInstallCPPortRecord installCPPortRecord = null;
        List<TEInstallCPPortRecord> portRecordList = cpDesc.getInstallCPPort(iBoardType);
        if (TEBoardConfigurationDataMgr.getInstance().isSupportSubCard(iBoardType)) {
            portRecordList.addAll(this.getInstallSubCPPort(neID, slotID, iBoardType));
        }
        int m = portRecordList.size();
        for (int i = 0; i < m; ++i) {
            installCPPortRecord = portRecordList.get(i);
            int mn = installCPPortRecord.portIDList.size();
            for (int k = 0; k < mn; ++k) {
                portProperty = new TEPortProperty(installCPPortRecord.signalType, installCPPortRecord.portType, installCPPortRecord.interfaceLevel, (Integer)installCPPortRecord.portIDList.get(k));
                portProperty.setPortUsage(installCPPortRecord.portUsage);
                ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, true);
                portProperty.setFunBlockPropertyList(TEBoardConfigurationDataMgr.getInstance().getStaticFBCountList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, portFBList));
                allPortPropertyList.add(portProperty);
            }
        }
        return allPortPropertyList;
    }

    public void fillModifyPortName(int neID, int slotID, int boardType, int portID, String name) {
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (null == ne) {
            return;
        }
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            return;
        }
        TEPort port = new TEPort(neID, slotID, board.getBoardType(), portID);
        this.modifiedPortNameMap.put(port, name);
    }

    public void fillModifyPortName(int neID, int slotID, int boardType) {
        this.modifiedPortNameMap.putAll(TENEListUtils.getPortMap(neID, slotID, boardType));
    }

    public void deletePortName(int neID, int slotID, int portID) {
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (null == ne) {
            return;
        }
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            return;
        }
        TEPort port = new TEPort(neID, slotID, board.getBoardType(), portID);
        this.modifiedPortNameMap.remove(port);
    }

    public String getModifiedPortName(TEPort port) {
        if (port == null) {
            return "UNKNOWN";
        }
        return (String)this.modifiedPortNameData.get(port);
    }

    public boolean isNameUpdable(int portType) {
        return TEPortDescription.getInstance().isNameUpdable(portType);
    }

    public void fillModifiedPortData(TEPort port) {
        if (port == null) {
            return;
        }
        this.modifiedPortNameData.put(port, port.getPortName());
    }

    public TEPort getPort(int iNEID, int iSlotID, int iPortID) {
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        if (board == null) {
            return null;
        }
        int boardType = board.getBoardType();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        if (cpDesc.isMutativeBoardType(boardType)) {
            List<TEPort> portList = this.queryBoardPortList(board);
            int size = portList.size();
            for (int i = 0; i < size; ++i) {
                TEPort tmpport = portList.get(i);
                if (tmpport.getPortNo() != iPortID) continue;
                return tmpport;
            }
            return null;
        }
        return this.buildTEPort(iNEID, iSlotID, iPortID);
    }

    public TEPort buildTEPort(int iNEID, int iSlotID, int iPortID) {
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        if (board == null) {
            return null;
        }
        int boardType = board.getBoardType();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        List<TEInstallCPPortRecord> portPropertyList = cpDesc.getInstallCPPort(boardType);
        if (portPropertyList != null && !portPropertyList.isEmpty()) {
            TEInstallCPPortRecord installCPPortRecord = null;
            int size = portPropertyList.size();
            for (int i = 0; i < size; ++i) {
                installCPPortRecord = portPropertyList.get(i);
                if (!installCPPortRecord.getPortIDList().contains(iPortID)) continue;
                TEPort resultport = new TEPort(iNEID, iSlotID, boardType, iPortID, installCPPortRecord.portType, installCPPortRecord.interfaceLevel);
                resultport.setPortAddibleType(installCPPortRecord.portDynType);
                return resultport;
            }
        }
        return null;
    }

    public TEPort buildTEPort(int iNEID, int iSlotID, int iPortID, int portType) {
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        if (board == null) {
            return null;
        }
        int boardType = board.getBoardType();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        List<TEInstallCPPortRecord> portPropertyList = cpDesc.getInstallCPPort(boardType);
        if (TEBoardConfigurationDataMgr.getInstance().isSupportSubCard(boardType)) {
            portPropertyList.addAll(this.getInstallSubCPPort(iNEID, iSlotID, boardType));
        }
        if (portPropertyList != null && !portPropertyList.isEmpty()) {
            TEInstallCPPortRecord installCPPortRecord = null;
            int size = portPropertyList.size();
            for (int i = 0; i < size; ++i) {
                installCPPortRecord = portPropertyList.get(i);
                if (!installCPPortRecord.getPortIDList().contains(iPortID) || portType != installCPPortRecord.portType) continue;
                TEPort resultport = new TEPort(iNEID, iSlotID, boardType, iPortID, installCPPortRecord.portType, installCPPortRecord.interfaceLevel);
                resultport.setPortAddibleType(installCPPortRecord.portDynType);
                return resultport;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletLogicPortByNe(int iNEID) {
        Integer NEID = iNEID;
        Hashtable<Integer, Hashtable<String, List<TEPort>>> hashtable = this.dynBoardPortData;
        synchronized (hashtable) {
            if (this.dynBoardPortData.containsKey(NEID)) {
                this.dynBoardPortData.remove(NEID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletLogicPortBySlot(int iNEID, int iSlotID, int iBoardType) {
        Integer NEID = iNEID;
        Hashtable<String, List<TEPort>> boardPortData = null;
        Hashtable<Integer, Hashtable<String, List<TEPort>>> hashtable = this.dynBoardPortData;
        synchronized (hashtable) {
            if (this.dynBoardPortData.containsKey(NEID)) {
                String boardKey = String.valueOf(iSlotID) + iBoardType;
                boardPortData = this.dynBoardPortData.get(NEID);
                if (boardPortData.containsKey(boardKey)) {
                    boardPortData.remove(boardKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delLogicPort(int iNEID, int iSlotID, int iPortNo) {
        Integer NEID = iNEID;
        Integer PortNo = iPortNo;
        int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(iNEID, iSlotID);
        String BoardKey = String.valueOf(iSlotID) + boardType;
        Hashtable<String, List<TEPort>> boardPortData = null;
        List<TEPort> portdyndataList = null;
        Hashtable<Integer, Hashtable<String, List<TEPort>>> hashtable = this.dynBoardPortData;
        synchronized (hashtable) {
            if (!this.dynBoardPortData.containsKey(NEID)) {
                return;
            }
            boardPortData = this.dynBoardPortData.get(NEID);
            if (!boardPortData.containsKey(BoardKey)) {
                return;
            }
            portdyndataList = boardPortData.get(BoardKey);
            Iterator<TEPort> iter = portdyndataList.iterator();
            while (iter.hasNext()) {
                TEPort tempPort = iter.next();
                if (PortNo.intValue() != tempPort.getPortNo() || tempPort.getSlotID() != iSlotID || tempPort.getNEID() != iNEID) continue;
                iter.remove();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogicPort(int iNEID, int iSlotID, int iPortNo, int portType, int portLevel) {
        int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(iNEID, iSlotID);
        String BoardKey = String.valueOf(iSlotID) + boardType;
        Hashtable<Object, Object> boardPortData = null;
        List<TEPort> portdyndataList = null;
        Hashtable<Integer, Hashtable<String, List<TEPort>>> hashtable = this.dynBoardPortData;
        synchronized (hashtable) {
            if (this.dynBoardPortData.containsKey(iNEID)) {
                boardPortData = this.dynBoardPortData.get(iNEID);
            } else {
                boardPortData = new Hashtable();
                this.dynBoardPortData.put(iNEID, boardPortData);
            }
            if (boardPortData.containsKey(BoardKey)) {
                portdyndataList = (List)boardPortData.get(BoardKey);
            } else {
                portdyndataList = new ArrayList();
                boardPortData.put(BoardKey, portdyndataList);
            }
            TEPort portObj = new TEPort(iNEID, iSlotID, iPortNo, portType, portLevel);
            Iterator teportIter = portdyndataList.iterator();
            while (teportIter.hasNext()) {
                TEPort tempPort = (TEPort)teportIter.next();
                if (tempPort.getNEID() != iNEID || tempPort.getSlotID() != iSlotID || tempPort.getPortNo() != iPortNo) continue;
                teportIter.remove();
            }
            portdyndataList.add(portObj);
            return;
        }
    }

    public List getPortListFromPortType(int neID, int iBoardType, int iPortType) {
        ArrayList list = new ArrayList();
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        if (portRecordList == null || portRecordList.isEmpty()) {
            return list;
        }
        TEInstallCPPortRecord portRecord = null;
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            if (portRecord.portType != iPortType || null == portRecord.getPortIDList()) continue;
            list.addAll(portRecord.getPortIDList());
        }
        return list;
    }

    public int getSubBoardPortType(int boardType, int subType, int subSlotID, int portID) {
        List<TEInstallCPPortRecord> subPortRecordList = TECircuitPackDescription.getInstance().getInstallSubCPPort(boardType, subType, subSlotID);
        return this.getPortTypeFromRecordList(subPortRecordList, portID);
    }

    public int getPortType(int neID, int boardType, int portID) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        return this.getPortTypeFromRecordList(portRecordList, portID);
    }

    private int getPortTypeFromRecordList(List<TEInstallCPPortRecord> portRecordList, int portID) {
        if (portRecordList == null || portRecordList.isEmpty()) {
            return -1;
        }
        TEInstallCPPortRecord portRecord = null;
        ArrayList portNOList = null;
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            portNOList = portRecord.getPortIDList();
            int jsize = portNOList.size();
            for (int j = 0; j < jsize; ++j) {
                int portNo = (Integer)portNOList.get(j);
                if (portNo != portID) continue;
                return portRecord.portType;
            }
        }
        return -1;
    }

    public boolean isIFPort(int neID, int boardType, int portID) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        if (portRecordList == null || portRecordList.size() <= 0) {
            return false;
        }
        TEInstallCPPortRecord portRecord = null;
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            ArrayList portNOList = portRecord.getPortIDList();
            int jsize = portNOList.size();
            for (int j = 0; j < jsize; ++j) {
                int portNo = (Integer)portNOList.get(j);
                if (portNo != portID || 1802 != portRecord.portType && 2817 != portRecord.portType) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExistPortType(int neID, int boardType, int portID, int portType) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        if (portRecordList == null || portRecordList.size() <= 0) {
            return false;
        }
        TEInstallCPPortRecord portRecord = null;
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            ArrayList portNOList = portRecord.getPortIDList();
            int jsize = portNOList.size();
            for (int j = 0; j < jsize; ++j) {
                int portNo = (Integer)portNOList.get(j);
                if (portNo != portID || portType != portRecord.portType) continue;
                return true;
            }
        }
        return false;
    }

    public List getPortTypeList(int neID, int boardType, int portID) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        if (portRecordList == null || portRecordList.isEmpty()) {
            return null;
        }
        ArrayList<Integer> portTypeList = new ArrayList<Integer>();
        TEInstallCPPortRecord portRecord = null;
        ArrayList portNOList = null;
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            portNOList = portRecord.getPortIDList();
            int jsize = portNOList.size();
            for (int j = 0; j < jsize; ++j) {
                int portNo = (Integer)portNOList.get(j);
                if (portNo != portID) continue;
                portTypeList.add(portRecord.portType);
            }
        }
        return portTypeList;
    }

    public int getPortType(int neID, int boardType, int portID, int boardMode) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        if (portRecordList == null || portRecordList.isEmpty()) {
            return -1;
        }
        TEInstallCPPortRecord portRecord = null;
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            if (portRecord.cpMode != 0 && boardMode != portRecord.cpMode) continue;
            ArrayList portNOList = portRecord.getPortIDList();
            int jsize = portNOList.size();
            for (int j = 0; j < jsize; ++j) {
                int portNo = (Integer)portNOList.get(j);
                if (portNo != portID) continue;
                return portRecord.portType;
            }
        }
        return -1;
    }

    public String getPortNameForNARTN(int neID, int slotID, int iBoardType, int portID) {
        if (TEPortModelConfigurationDataMgr.isNaRTN(neID)) {
            return TEConfigurationDataMgr.getInstance().getPortNameForPTN(neID, slotID, iBoardType, portID);
        }
        return TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portID);
    }

    public static boolean isNaRTN(int neID) {
        TENE temNE = TENEListMgr.getInstance().getNE(neID);
        return temNE.getNEType() == 89 || temNE.getNEType() == 90;
    }

    public static List<Integer> getLogicalPorts(int neid, int slotid, String operName) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        try {
            Operation oper = TECreateObjectFactory.getOperation(neid, operName);
            Input input = oper.getInput();
            input.getPart(0).setValue(String.valueOf(slotid));
            input.getPart(input.getPartCount() - 1).setValue("0");
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)20).retCode;
            if (resualt == 0 && oper.getOutput()[0].getFault()[0].getCode().equals(String.valueOf(0))) {
                int len = oper.getOutputCount();
                for (int i = 0; i < len; ++i) {
                    Output output = oper.getOutput(i);
                    if (!output.getFault()[0].getCode().equals(String.valueOf(0))) continue;
                    ports.add(Integer.valueOf(output.getPart(2).getValue()));
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get ports error", (Throwable)e);
        }
        return ports;
    }

    public int getLogicalPortSpeed(int neid, int slotid, int portNo) {
        try {
            Operation oper = TECreateObjectFactory.getOperation(neid, "NSCMD_CFG_GET_PORT");
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotid));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portNo));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)10).retCode;
            if (resualt == 0 && oper.getOutput()[0].getFault()[0].getCode().equals(String.valueOf(0))) {
                return Integer.parseInt(oper.getOutput()[0].getPartValue("speedLevel"));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        return -1;
    }

    public String getLogicPortName(int phyPortID, String portName) {
        String fullPortName = "";
        String portValue = "";
        if (4096 <= phyPortID && 6144 > phyPortID) {
            portValue = String.valueOf(phyPortID - 4096);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + "(MP-" + portName + ")";
        } else if (phyPortID >= 6144 && phyPortID < 8191) {
            portValue = "" + (phyPortID - 6144);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + "(Serial-" + portName + ")";
        } else if (phyPortID >= 10240 && phyPortID < 12288) {
            portValue = "" + (phyPortID - 10240);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + "(VEther-" + portName + ")";
        } else if (phyPortID >= 14336) {
            portValue = "" + (phyPortID - 14336 + 2048);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + "(VEther-" + portName + ")";
        }
        return fullPortName;
    }

    public String getPTNPortName(int neid, int slotid, int subslotid, int port) {
        String portName = "";
        portName = slotid == 255 || slotid == 65535 ? this.getLogicPortName(port, "") : this.getSimplePortName(neid, slotid, subslotid, port);
        return portName;
    }

    public String getSimplePortName(int neID, int slotID, int subslotid, int portID) {
        String portString = "";
        int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        int subboardType = TEBoardConfigurationDataMgr.getInstance().getSubboardType(neID, slotID, subslotid);
        String boardTypeName = TEBoardConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        String subboardTypeName = TEBoardConfigurationDataMgr.getInstance().getBoardTypeName(neID, subboardType);
        String portName = "";
        if (subslotid != 0 && subslotid != 255) {
            portName = this.getPortName(neID, slotID, subboardType, portID);
            portString = TEBoardUtil.getSlotIDFromSlot(neID, slotID) + "-" + boardTypeName + "-" + subslotid + "-" + subboardTypeName + "-" + portName;
        } else {
            portName = this.getPortName(neID, slotID, boardType, portID);
            portString = TEBoardUtil.getSlotIDFromSlot(neID, slotID) + "-" + boardTypeName + "-" + portName;
        }
        return portString;
    }

    public TEPortParaRecord getExcPortParaRecord(int neID, int iBoardType, int portID, Integer level) {
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        TESDCircuitPackRecord record = cpDesc.getCPRecord(iBoardType);
        if (TEBoardConfigurationDataMgr.getInstance().isWDMBoardType(neID, iBoardType)) {
            ArrayList portParaList = record.getPortExcLevel();
            int size = portParaList.size();
            for (int i = 0; i < size; ++i) {
                TEPortParaRecord portParaRecord = (TEPortParaRecord)portParaList.get(i);
                String inName = portParaRecord.inName;
                String outName = portParaRecord.outName;
                ArrayList supportLevelList = portParaRecord.supXCLevelList;
                if (null == inName && null == outName || !supportLevelList.contains(level)) continue;
                return portParaRecord;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePortState(int neid, int nmSlotID) {
        Map<TETL1AIDKey, TEState> map = this.portState;
        synchronized (map) {
            Iterator<TETL1AIDKey> it = this.portState.keySet().iterator();
            while (it.hasNext()) {
                TETL1AIDKey key = it.next();
                if (key.getNeID() != neid || key.getNMSlot() != nmSlotID) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEState getPortState(TETL1AIDKey aidKey) {
        Map<TETL1AIDKey, TEState> map = this.portState;
        synchronized (map) {
            TEState state = this.portState.get(aidKey);
            if (state == null) {
                state = new TEState();
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortState(TETL1AIDKey aidKey, TEState teState) {
        Map<TETL1AIDKey, TEState> map = this.portState;
        synchronized (map) {
            this.portState.put(aidKey, teState);
        }
    }

    public int getPTN1900PortNum(int neID, int slotID, int boardType) {
        int ETFC = 1133;
        int ETMC = 2222;
        ArrayList boardPortList = TEBoardConfigurationDataMgr.getInstance().getBoardPortList(neID, boardType);
        int portNum = boardPortList.size();
        if (3 == slotID && (ETFC == boardType || ETMC == boardType)) {
            portNum -= 5;
        }
        return portNum;
    }

    public String getPortDefaultName(int portType, int portID, int cptype) {
        String defaultName = "";
        TECircuitPackDescription pCPD = TECircuitPackDescription.getInstance();
        String inName = pCPD.getCPPortINName(cptype, portID);
        String outName = pCPD.getCPPortOUTName(cptype, portID);
        if (!"".equals(inName) && !"".equals(outName)) {
            defaultName = inName + "/" + outName;
        } else if (!"".equals(inName)) {
            defaultName = inName;
        } else if (!"".equals(outName)) {
            defaultName = outName;
        }
        if ("".equals(defaultName)) {
            defaultName = portType == 61005 ? "VCTRUNK-" + (portID - 32768) : (portType == 1025 ? "PORT-" + TEPortUtil.getPortNo(portID) : (TEBoardConfigurationDataMgr.getInstance().isBranchBoardBybdType(0, cptype) ? "SDH_TU-" + TEPortUtil.getPortNo(portID) : "SDH-" + TEPortUtil.getPortNo(portID)));
        }
        return defaultName;
    }

    public void addPortIndex(int neid, long index, TEPortIndex portIndex) {
        Hashtable portData = null;
        if (this.portIndexData.containsKey(neid)) {
            portData = (Hashtable)this.portIndexData.get(neid);
            portData.put(index, portIndex);
        } else {
            portData = new Hashtable();
            portData.put(index, portIndex);
            this.portIndexData.put(neid, portData);
        }
    }

    public void removePortIndex(int neid) {
        this.portIndexData.remove(neid);
    }

    public TEPortIndex getPortIndex(int neid, long index) {
        Hashtable portData = null;
        if (this.portIndexData.containsKey(neid) && (portData = (Hashtable)this.portIndexData.get(neid)).containsKey(index)) {
            return (TEPortIndex)portData.get(index);
        }
        return null;
    }

    public int getBoardPortSpeed(int neID, int iBoardType, int iPortType) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        if (portRecordList == null || portRecordList.isEmpty()) {
            return -1;
        }
        TEInstallCPPortRecord portRecord = null;
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            if (iPortType != portRecord.portType) continue;
            return portRecord.interfaceLevel;
        }
        return -1;
    }

    public int getBoardPortSpeed(int neID, int iBoardType) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        if (portRecordList == null || portRecordList.isEmpty()) {
            return -1;
        }
        TEInstallCPPortRecord portRecord = portRecordList.get(0);
        int portSpeed = portRecord.interfaceLevel;
        int size = portRecordList.size();
        for (int i = 1; i < size; ++i) {
            if (portSpeed == portRecordList.get((int)i).interfaceLevel) continue;
            return -1;
        }
        return portSpeed;
    }

    public ArrayList getSupportedDynPortList(int neID, int iBoardType) {
        ArrayList<Integer> portList = new ArrayList<Integer>();
        int neVersion = TEConvertUtil.convertVerStrToInt(TENEConfigurationDataMgr.getInstance().getNE(neID).getHostVersion());
        TECPAddiblePortRecord addiblePortRecord = null;
        List<TECPAddiblePortRecord> dynPortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(iBoardType);
        if (null != dynPortRecordList && !dynPortRecordList.isEmpty()) {
            int m = dynPortRecordList.size();
            for (int i = 0; i < m; ++i) {
                addiblePortRecord = dynPortRecordList.get(i);
                if (!addiblePortRecord.isWithInRange(neVersion)) continue;
                portList.add(addiblePortRecord.portID);
            }
        }
        return portList;
    }

    public String getPortName(int neID, int slotID, int iBoardType, int portID, int iportType) {
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (ne == null) {
            TELogFactory.getNormalLogger().info("ne is null.");
            return portID + UNKNOWN_POSTFIX;
        }
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            TELogFactory.getNormalLogger().info("board is not exist.");
            return portID + UNKNOWN_POSTFIX;
        }
        int domainType = this.getDomainType(iportType);
        StringBuffer stringName = new StringBuffer();
        String name = "";
        name = 255 == domainType ? this.getDyncPortName(neID, slotID, iBoardType, portID) : this.getDyncPortName(neID, slotID, iBoardType, portID, domainType);
        if (null != name && !"".equalsIgnoreCase(name) && iportType != 61009) {
            return name;
        }
        if (TEVirtualPortUtil.isVirtualPort(iBoardType, portID, 0)) {
            return TEVirtualPortUtil.getVirtualPortNameWithoutPortid(portID);
        }
        if (TEBoardConfigurationDataMgr.getInstance().isWDMBoardType(neID, iBoardType) && 1 == this.getPortTypeList(neID, iBoardType, portID).size()) {
            TEPortParaRecord portParaRecord = TECircuitPackDescription.getInstance().getCPPortPara(iBoardType, portID);
            if (null == portParaRecord) {
                return portID + UNKNOWN_POSTFIX;
            }
            int portType = portParaRecord.portType;
            String inName = portParaRecord.inName;
            String outName = portParaRecord.outName;
            if (inName != null && portType == 61005) {
                stringName.append(VCTRUNK_PREFIX);
                stringName.append(portID - 32768);
                return stringName.toString();
            }
            if (outName != null && portType == 61005) {
                stringName.append(VCTRUNK_PREFIX);
                stringName.append(portID - 32768);
                return stringName.toString();
            }
            if (inName != null && outName == null && portType != 61005 && !"".equalsIgnoreCase(inName)) {
                stringName.append(inName);
            }
            if (inName == null && outName != null && portType != 61005 && !"".equalsIgnoreCase(outName)) {
                stringName.append(outName);
            }
            if (inName != null && outName != null && portType != 61005) {
                if (!"".equalsIgnoreCase(inName)) {
                    stringName.append(inName);
                }
                if (!"".equalsIgnoreCase(inName) && !"".equalsIgnoreCase(outName)) {
                    stringName.append('/');
                }
                if (!"".equalsIgnoreCase(outName)) {
                    stringName.append(outName);
                }
            }
            if (stringName.length() == 0) {
                TELogFactory.getNormalLogger().info("stringName is null.");
                return portID + UNKNOWN_POSTFIX;
            }
            return stringName.toString();
        }
        return this.getPortNameFromType(neID, slotID, iBoardType, portID, iportType);
    }

    private String getPortNameFromType(int neID, int slotID, int boardType, int portID, int iportType) {
        String portName;
        List portList = this.getBoardPortPropertyList(neID, slotID, boardType);
        ArrayList<Integer> portTypeList = new ArrayList<Integer>();
        int portTypeValue = iportType;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            TEPortProperty portProperty = (TEPortProperty)portList.get(i);
            int portNo = portProperty.getPortNo();
            if (portNo != portID) continue;
            int portType = portProperty.getPortType();
            if (portType == iportType) {
                portTypeList.clear();
                break;
            }
            portTypeList.add(portType);
        }
        if (!portTypeList.isEmpty()) {
            if (iportType != -1 && portTypeList.size() > 1) {
                return "";
            }
            portTypeValue = (Integer)portTypeList.get(0);
        }
        if (!"".equals(portName = this.getPortNameUtil(neID, boardType, portID, portTypeValue)) && iportType == -1) {
            if (portID > 36864) {
                portName = portID - 36864 + "(" + portName + ")";
            } else if (portID < 32768) {
                portName = portID + "(" + portName + ")";
            }
        }
        return portName;
    }

    public String getSubCardPortName(int neID, int slotID, int portID) {
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(neID, slotID);
        if (null != board && !board.getSubBoardList().isEmpty()) {
            TESubBoard subboard = null;
            int len = board.getSubBoardList().size();
            for (int i = 0; i < len; ++i) {
                subboard = (TESubBoard)board.getSubBoardList().get(i);
                int portType = this.getSubBoardPortType(board.getBoardType(), subboard.getSubBoardType(), subboard.getSubSlotID(), portID);
                if (-1 == portType) continue;
                TEInstallSubCPRecord subCPRecord = TECircuitPackDescription.getInstance().getInstallSubCPType(board.getBoardType(), subboard.getSubSlotID());
                int port = portID - subCPRecord.startPortID;
                String portName = this.getPortNameUtil(neID, subboard.getSubBoardType(), port, portType);
                portName = "".equals(portName) ? this.PORT_RES + "-" + port : portName;
                String subBoardname = TEBoardConfigurationDataMgr.getInstance().getBoardTypeName(neID, subboard.getSubBoardType());
                return subboard.getSubSlotID() + "-" + subBoardname + "-" + port + "(" + portName + ")";
            }
        }
        return "";
    }

    public TESubBoard getSubCardFromPortID(int neID, int slotID, int portID) {
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(neID, slotID);
        if (null != board && !board.getSubBoardList().isEmpty()) {
            TESubBoard subboard = null;
            ArrayList portList = null;
            int len = board.getSubBoardList().size();
            for (int i = 0; i < len; ++i) {
                subboard = (TESubBoard)board.getSubBoardList().get(i);
                portList = TECircuitPackDescription.getInstance().getSubCPPort(board.getBoardType(), subboard.getSubBoardType(), subboard.getSubSlotID());
                if (!portList.contains(portID)) continue;
                return subboard;
            }
        }
        return null;
    }

    public int getSubSlotIDFromPortID(int neID, int slotID, int portID) {
        int slotid = -1;
        TESubBoard subBoard = this.getSubCardFromPortID(neID, slotID, portID);
        if (null != subBoard) {
            slotid = subBoard.getSubSlotID();
        }
        return slotid;
    }

    public int resumeSubCPPort(int cpType, int subSlot, int portID) {
        return TECircuitPackDescription.getInstance().resumeSubCPPort(cpType, subSlot, portID);
    }

    private String getEthPorName(int portID) {
        String portName = "";
        portName = portID > 36864 ? "IFUP-" + (portID - 36864) : (portID > 32768 ? VCTRUNK_PREFIX + (portID - 32768) : this.PORT_RES + "-" + TEPortUtil.getPortNo(portID));
        return portName;
    }

    private String getPortNameUtil(int neID, int boardType, int portID, int portType) {
        String portName = "";
        switch (portType) {
            case 61005: {
                portName = VCTRUNK_PREFIX + (portID - 32768);
                break;
            }
            case 1025: 
            case 1798: 
            case 1799: 
            case 1803: {
                portName = this.getEthPorName(portID);
                break;
            }
            case 1797: {
                portName = "PORT-" + portID;
                break;
            }
            case 2817: {
                portName = "IF-" + portID;
                break;
            }
            case 1802: {
                portName = "RTNIF-" + portID;
                break;
            }
            case 256: 
            case 259: 
            case 61001: 
            case 61002: 
            case 61003: 
            case 61009: {
                portName = "SDH";
                if (TEBoardConfigurationDataMgr.getInstance().isBranchBoardBybdType(neID, boardType)) {
                    portName = portName + "_TU";
                }
                portName = portName + "-" + portID;
                break;
            }
            case 63213: {
                portName = portID > 40000 ? "V_ETH-" + (portID - 40000) : String.valueOf(portID);
                break;
            }
            case 63210: {
                portName = portID > 50 ? "V_SDH-" + (portID - 50) : String.valueOf(portID);
                break;
            }
            case -1: {
                portName = this.PORT_RES + "-" + portID;
                break;
            }
            default: {
                portName = this.PORT_RES;
                if (TEBoardConfigurationDataMgr.getInstance().isBranchBoardBybdType(neID, boardType)) {
                    portName = portName + "_TU";
                }
                portName = portName + "-" + portID;
            }
        }
        return portName;
    }

    public boolean isLinePort(TEPort port) {
        return port.getPortType() == 256 || port.getPortType() == 512;
    }

    public boolean isIdlePort(int neID, int iBoardType, int portType, int portNo) {
        if (portType == 61005) {
            return false;
        }
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            TEInstallCPPortRecord portRecord = portRecordList.get(i);
            int portUsage = portRecord.portUsage;
            ArrayList portNoList = portRecord.portIDList;
            boolean boolPort = false;
            if (portNoList == null || portNoList.isEmpty()) {
                return boolPort;
            }
            int jSize = portNoList.size();
            for (int j = 0; j < jSize; ++j) {
                int portNoTmp = (Integer)portNoList.get(j);
                if (portNoTmp != portNo) continue;
                boolPort = true;
                break;
            }
            if (!boolPort || portRecord.portType != portType || portUsage != 0 && portUsage != 2 && portUsage != 3) continue;
            return true;
        }
        return false;
    }

    public int getPortUsage(int neID, int iBoardType, int portType, int portNo) {
        if (portType == 61005) {
            return 1;
        }
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            TEInstallCPPortRecord portRecord = portRecordList.get(i);
            if (portRecord.portType != portType) continue;
            int portUsage = portRecord.portUsage;
            ArrayList portNoList = portRecord.getPortIDList();
            if (portNoList == null || portNoList.isEmpty()) {
                return 1;
            }
            if (!portNoList.contains(portNo)) continue;
            return portUsage;
        }
        return 1;
    }

    public ArrayList getETHVCTrunkPort(int neID, int slotID, int iBoardType) {
        int subrackType = TEGetNEDomainVersion.getInstance().getDevType(TEBoardUtil.getSubrackType(neID, TENEConfigurationDataMgr.getInstance().getNE(neID).getNEType(), slotID));
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        ArrayList vcTrunkPortList = this.getETHVCTrunkPort(neID, iBoardType);
        int portId = -1;
        TEPortParaRecord portParaRecord = null;
        Iterator iter = vcTrunkPortList.iterator();
        while (iter.hasNext()) {
            portId = (Integer)iter.next();
            portParaRecord = cpDesc.getCPPortPara(iBoardType, portId);
            if (null == portParaRecord || null == portParaRecord.boardModeList || portParaRecord.boardModeList.contains(subrackType)) continue;
            iter.remove();
        }
        return vcTrunkPortList;
    }

    public ArrayList getETHVCTrunkPort(int neID, int iBoardType) {
        ArrayList vcTrunkPortList = new ArrayList();
        TEInstallCPPortRecord portRecord = null;
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            if (portRecord.portType != 61005 || null == portRecord.getPortIDList()) continue;
            vcTrunkPortList.addAll(portRecord.getPortIDList());
        }
        return vcTrunkPortList;
    }

    public ArrayList getETHMACPort(int neID, int iBoardType) {
        ArrayList vcTrunkPortList = new ArrayList();
        TEInstallCPPortRecord portRecord = null;
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            if (portRecord.portType != 1025) continue;
            vcTrunkPortList.addAll(portRecord.getPortIDList());
        }
        Collections.sort(vcTrunkPortList);
        return vcTrunkPortList;
    }

    public ArrayList getETHMACPort(int neID, int iBoardType, int boardMode) {
        ArrayList vcTrunkPortList = new ArrayList();
        TEInstallCPPortRecord portRecord = null;
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            if (portRecord.cpMode != 0 && boardMode != portRecord.cpMode || portRecord.portType != 1025) continue;
            vcTrunkPortList.addAll(portRecord.getPortIDList());
        }
        Collections.sort(vcTrunkPortList);
        return vcTrunkPortList;
    }

    public static final String getVCTrunkName(int vcTrunkID) {
        StringBuffer vcTurnkStr = new StringBuffer(VCTRUNK_PREFIX);
        vcTurnkStr.append(vcTrunkID);
        return vcTurnkStr.toString();
    }

    public static final String getMACName(int portID) {
        StringBuffer portStr = new StringBuffer("PORT");
        portStr.append(portID);
        return portStr.toString();
    }

    public Hashtable<String, List<TEPort>> getDynBoardPortData(int neid) {
        return this.dynBoardPortData.get(neid);
    }

    public List<TEPort> queryBoardPortList(TEBoard board) {
        List<TEPort> result = new ArrayList<TEPort>();
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            String boardKey;
            List<TEPort> portdyndataList;
            Hashtable<String, List<TEPort>> boardPortData = this.dynBoardPortData.get(board.getNEID());
            if (null != boardPortData && null != (portdyndataList = boardPortData.get(boardKey = String.valueOf(board.getSlotID()) + board.getBoardType()))) {
                for (int i = 0; i < portdyndataList.size(); ++i) {
                    result.add(this.buildTEPort(board.getNEID(), board.getSlotID(), portdyndataList.get(i).getPortNo()));
                }
            }
        } else {
            int neID = board.getNEID();
            int slotID = board.getSlotID();
            int boardType = board.getBoardType();
            List<TECPAddiblePortRecord> addiblePortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType);
            int neVersion = TEConvertUtil.convertVerStrToInt(TENEListMgr.getInstance().getNE(neID).getHostVersion());
            HashMap<Integer, Integer> porttypes = new HashMap<Integer, Integer>();
            TECPAddiblePortRecord addiblePortRecord = null;
            int m = addiblePortRecordList.size();
            for (int i = 0; i < m; ++i) {
                addiblePortRecord = addiblePortRecordList.get(i);
                if (!addiblePortRecord.isWithInRange(neVersion)) continue;
                porttypes.put(addiblePortRecord.portID, addiblePortRecord.portType);
            }
            result = TEQueryPortForDataMgr.getPortListOnInter(neID, slotID, boardType, porttypes);
        }
        return result;
    }

    public List<TEInstallCPPortRecord> getInstallSubCPPort(int iNEID, int iSlotID, int boardType) {
        ArrayList<TEInstallCPPortRecord> portList = new ArrayList<TEInstallCPPortRecord>();
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        if (!board.getSubBoardList().isEmpty()) {
            int len = board.getSubBoardList().size();
            for (int i = 0; i < len; ++i) {
                TESubBoard subbd = (TESubBoard)board.getSubBoardList().get(i);
                portList.addAll(TECircuitPackDescription.getInstance().getInstallSubCPPort(boardType, subbd.getSubBoardType(), subbd.getSubSlotID()));
            }
        }
        return portList;
    }

    public List<TEPortProperty> getSubCPDynPropertyList(int iNEID, int iSlotID, int boardType) {
        ArrayList<TEPortProperty> portList = new ArrayList<TEPortProperty>();
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        if (!board.getSubBoardList().isEmpty()) {
            int len = board.getSubBoardList().size();
            for (int i = 0; i < len; ++i) {
                TESubBoard subbd = (TESubBoard)board.getSubBoardList().get(i);
                portList.addAll(TEBoardConfigurationDataMgr.getInstance().getSubCPDynPropertyList(iNEID, boardType, subbd.getSubBoardType(), subbd.getSubSlotID()));
            }
        }
        return portList;
    }

    private ArrayList getLogicPortListOnSingle(int iNEID, int iSlotID) {
        ArrayList<Integer> logicPortList = new ArrayList<Integer>();
        String key = "" + iNEID + "-" + iSlotID;
        HashMap<Integer, List<Integer>> existPortMap = TEBoardConfigurationDataMgr.getInstance().getBoardExistPortData().get(key);
        int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(iNEID, iSlotID);
        if (boardType == 1573 && existPortMap != null) {
            Iterator<Integer> it = existPortMap.keySet().iterator();
            while (it.hasNext()) {
                logicPortList.add(it.next());
            }
        }
        try {
            List<TEInstallCPPortRecord> portRecordList = this.getInstallCPPort(iNEID, iSlotID, boardType);
            int size = portRecordList.size();
            for (int i = 0; i < size; ++i) {
                TEInstallCPPortRecord portRecord = portRecordList.get(i);
                ArrayList portList = portRecord.getPortIDList();
                if (logicPortList.containsAll(portList)) continue;
                logicPortList.addAll(portList);
            }
            if (TEBoardConfigurationDataMgr.getInstance().isDynPortBoardType(iNEID, boardType)) {
                String boardKey;
                ArrayList<Integer> portsExist = new ArrayList<Integer>();
                Hashtable<String, List<TEPort>> boardPortData = null;
                List<TEPort> portdyndataList = null;
                boardPortData = this.dynBoardPortData.get(iNEID);
                if (null != boardPortData && null != (portdyndataList = boardPortData.get(boardKey = String.valueOf(iSlotID) + boardType))) {
                    int size2 = portdyndataList.size();
                    for (int i = 0; i < size2; ++i) {
                        portsExist.add(portdyndataList.get(i).getPortNo());
                    }
                }
                List<TEPortProperty> addiblePortList = this.getDynPropertyList(iNEID, iSlotID, boardType);
                TEPortProperty tmpPrty2 = null;
                for (TEPortProperty tmpPrty2 : addiblePortList) {
                    if (portsExist.contains(tmpPrty2.getPortNo())) continue;
                    logicPortList.remove((Object)tmpPrty2.getPortNo());
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getLogicPortList(neid = " + iNEID + " , slotID = " + iSlotID + ") fail!" + e);
        }
        return logicPortList;
    }

    private List<TEInstallCPPortRecord> getInstallCPPort(int neid, int slotid, int boardType) {
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        if (TEBoardConfigurationDataMgr.getInstance().isSupportSubCard(boardType)) {
            portRecordList.addAll(this.getInstallSubCPPort(neid, slotid, boardType));
        }
        return portRecordList;
    }

    private List<TEPortProperty> getDynPropertyList(int neid, int slotid, int boardType) {
        ArrayList addiblePortList = TEBoardConfigurationDataMgr.getInstance().getDynPropertyList(neid, boardType);
        if (TEBoardConfigurationDataMgr.getInstance().isSupportSubCard(boardType)) {
            addiblePortList.addAll(this.getSubCPDynPropertyList(neid, slotid, boardType));
        }
        return addiblePortList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getLogicPortList(int iNEID, int iSlotID) {
        ArrayList logicPortList = null;
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            logicPortList = this.getLogicPortListOnSingle(iNEID, iSlotID);
        } else {
            TETimeBufferByLoadTimes<NEIDAndSlotIDKey, List<Integer>> tETimeBufferByLoadTimes = this.logicPortBuffer;
            synchronized (tETimeBufferByLoadTimes) {
                try {
                    logicPortList = (ArrayList)this.logicPortBuffer.get(new NEIDAndSlotIDKey(iNEID, iSlotID));
                    if (logicPortList == null) {
                        logicPortList = (ArrayList)this.getLogicPortListOnInter(iNEID, iSlotID);
                        this.logicPortBuffer.put(new NEIDAndSlotIDKey(iNEID, iSlotID), logicPortList);
                    }
                }
                catch (TEUnknowmKeyTypeException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                }
                catch (UnkownRefresherException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                }
            }
        }
        if (logicPortList != null && !logicPortList.isEmpty()) {
            try {
                logicPortList.trimToSize();
                Collections.sort(logicPortList);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
        }
        return logicPortList;
    }

    public List<TEPort> getLogicPortList(int iNEID, int iSlotID, int portType) {
        ArrayList<TEPort> logicList = new ArrayList<TEPort>();
        ArrayList logicPortList = this.getLogicPortList(iNEID, iSlotID);
        if (logicPortList != null) {
            for (int i = 0; i < logicPortList.size(); ++i) {
                int iPortID = (Integer)logicPortList.get(i);
                TEPort port = this.buildTEPort(iNEID, iSlotID, iPortID, portType);
                if (port == null || port.getPortType() != portType) continue;
                logicList.add(port);
            }
        }
        return logicList;
    }

    public List getPortList(int iNEID, int iSlotID, int portType) {
        ArrayList<TEPort> portList = new ArrayList<TEPort>();
        TEBoard board = TEBoardConfigurationDataMgr.getInstance().getBoardRef(iNEID, iSlotID);
        if (board == null) {
            return portList;
        }
        int boardType = board.getBoardType();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        if (cpDesc.isMutativeBoardType(boardType)) {
            List<TEPort> portTmpList = this.queryBoardPortList(board);
            int size = portTmpList.size();
            for (int i = 0; i < size; ++i) {
                TEPort tmpport = portTmpList.get(i);
                if (tmpport.getPortType() != portType) continue;
                portList.add(tmpport);
            }
        }
        String key = "" + iNEID + "-" + iSlotID;
        HashMap<Integer, List<Integer>> existPortMap = TEBoardConfigurationDataMgr.getInstance().getBoardExistPortData().get(key);
        List<TEInstallCPPortRecord> portRecordList = cpDesc.getInstallCPPort(boardType);
        if (portRecordList != null && !portRecordList.isEmpty()) {
            TEInstallCPPortRecord installCPPortRecord = null;
            int size = portRecordList.size();
            for (int i = 0; i < size; ++i) {
                installCPPortRecord = portRecordList.get(i);
                ArrayList portNoList = installCPPortRecord.getPortIDList();
                if (portType != installCPPortRecord.portType) continue;
                int portNoSize = portNoList.size();
                for (int j = 0; j < portNoSize; ++j) {
                    int portID = (Integer)portNoList.get(j);
                    if (boardType == 1573 && (existPortMap == null || !existPortMap.containsKey(portID))) continue;
                    TEPort resultport = new TEPort(iNEID, iSlotID, boardType, portID, installCPPortRecord.portType, installCPPortRecord.interfaceLevel);
                    resultport.setPortAddibleType(installCPPortRecord.portDynType);
                    if (portList.contains(resultport)) continue;
                    portList.add(resultport);
                }
            }
        }
        Collections.sort(portList);
        return portList;
    }

    private List<Integer> getLogicPortListOnInter(int iNEID, int iSlotID) {
        return TEQueryLogicPortForDataMgr.getLogicPortListOnInter(iNEID, iSlotID);
    }

    public List<Integer> getDynLogicPortList(int iNEID, int iSlotID, int boardType) {
        ArrayList<Integer> logicPortList;
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            logicPortList = this.getLogicPortListOnSingle(iNEID, iSlotID);
        } else {
            List<TEPort> tempList = TEQueryPortForDataMgr.getPortListOnInter(iNEID, iSlotID, boardType);
            logicPortList = new ArrayList<Integer>();
            int size = tempList.size();
            for (int i = 0; i < size; ++i) {
                TEPort port = tempList.get(i);
                logicPortList.add(port.getPortNo());
            }
        }
        return logicPortList;
    }

    private int getDomainType(int portType) {
        return TEPortDescription.getInstance().getPortDomain(portType);
    }

    public static int getVCTrunkNumberFromNE(int neID, int slotid) {
        int number = -1;
        Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_ETHN_CFG_GET_PORTNUM");
        if (oper != null) {
            String numberStr;
            oper.getInput().setPartValue("slotid", String.valueOf(slotid));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)20).retCode;
            if (result == 0 && String.valueOf(0).equals(oper.getOutput(0).getFault(0).getCode()) && (numberStr = oper.getOutput(0).getPartValue("number")) != null && !numberStr.equals("")) {
                number = Integer.parseInt(numberStr);
            }
        }
        return number;
    }

    public int getCacheSpeed(int neid, int slotid, int port) {
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            Hashtable<String, List<TEPort>> boardPortData = this.dynBoardPortData.get(neid);
            if (boardPortData == null) {
                return -1;
            }
            int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            String boardKey = String.valueOf(slotid) + boardType;
            List<TEPort> ports = boardPortData.get(boardKey);
            if (ports == null) {
                return -1;
            }
            for (TEPort tempPort : ports) {
                if (port != tempPort.getPortNo()) continue;
                return tempPort.getLevel();
            }
            return -1;
        }
        TEPort tePort = TEConfigurationDataMgr.getInstance().getPort(neid, slotid, port);
        if (tePort != null) {
            return tePort.getLevel();
        }
        return -1;
    }

    public int getCachePortType(int neid, int slotid, int port) {
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            Hashtable<String, List<TEPort>> boardPortData = this.dynBoardPortData.get(neid);
            if (boardPortData == null) {
                return -1;
            }
            int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            String boardKey = String.valueOf(slotid) + boardType;
            List<TEPort> ports = boardPortData.get(boardKey);
            if (ports == null) {
                return -1;
            }
            for (TEPort tempPort : ports) {
                if (port != tempPort.getPortNo()) continue;
                return tempPort.getPortType();
            }
            return -1;
        }
        TEPort tePort = TEConfigurationDataMgr.getInstance().getPort(neid, slotid, port);
        if (tePort != null) {
            return tePort.getPortType();
        }
        return -1;
    }

    public int convertNMSLevelFromPortSpeed(int portSpeed) {
        int levalValue = -1;
        switch (portSpeed) {
            case 1: {
                levalValue = 6401;
                break;
            }
            case 2: {
                levalValue = 6404;
                break;
            }
            case 3: {
                levalValue = 6416;
                break;
            }
            case 4: {
                levalValue = 6464;
                break;
            }
            case 5: {
                levalValue = 6656;
                break;
            }
        }
        return levalValue;
    }
}

